/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.flatgeobuf.FeatureConversions;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.wololo.flatgeobuf.HeaderMeta;

final class ReadAllInterable
implements Iterable<SimpleFeature> {
    private final HeaderMeta headerMeta;
    private final LittleEndianDataInputStream data;
    private final SimpleFeatureBuilder fb;

    ReadAllInterable(HeaderMeta headerMeta, LittleEndianDataInputStream data, SimpleFeatureBuilder fb) {
        this.headerMeta = headerMeta;
        this.data = data;
        this.fb = fb;
    }

    @Override
    public Iterator<SimpleFeature> iterator() {
        IteratorImplementation it = new IteratorImplementation();
        return it;
    }

    private final class IteratorImplementation
    implements Iterator<SimpleFeature> {
        long count = 0L;
        SimpleFeature feature;
        SimpleFeature nextFeature;
        boolean done = false;

        private IteratorImplementation() {
        }

        @Override
        public boolean hasNext() {
            if (this.done) {
                return false;
            }
            if (this.nextFeature == null) {
                try {
                    this.nextFeature = this.next();
                }
                catch (NoSuchElementException e) {
                    this.done = true;
                    return false;
                }
                return true;
            }
            this.feature = this.nextFeature;
            this.nextFeature = null;
            return true;
        }

        @Override
        public SimpleFeature next() {
            if (this.nextFeature != null) {
                this.feature = this.nextFeature;
                this.nextFeature = null;
            } else {
                try {
                    this.feature = FeatureConversions.deserialize(ReadAllInterable.this.data, ReadAllInterable.this.fb, ReadAllInterable.this.headerMeta, this.count++);
                }
                catch (IOException e) {
                    throw new NoSuchElementException();
                }
            }
            return this.feature;
        }
    }
}

