/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.flatgeobuf.FlatgeobufDataStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class FlatgeobufDirectoryDataStore
extends ContentDataStore {
    private File directory;

    public FlatgeobufDirectoryDataStore(File directory) {
        this.directory = directory;
    }

    protected File getDirectory() {
        return this.directory;
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        File file;
        if (!typeName.endsWith(".fgb")) {
            typeName = typeName + ".fgb";
        }
        if (!(file = new File(this.directory, typeName)).exists()) {
            throw new IOException("Can't delete " + file.getAbsolutePath() + " because it doesn't exist!");
        }
        file.delete();
    }

    protected FlatgeobufDataStore getDataStore(String name) {
        File file = new File(this.directory, name + ".fgb");
        return new FlatgeobufDataStore(file);
    }

    protected List<Name> createTypeNames() throws IOException {
        File[] files = this.directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".fgb");
            }
        });
        ArrayList<Name> names = new ArrayList<Name>();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                names.add((Name)new NameImpl(name.substring(0, name.lastIndexOf(46))));
            }
        }
        return names;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.getDataStore(featureType.getTypeName()).createSchema(featureType);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        return this.getDataStore(contentEntry.getTypeName()).createFeatureSource(contentEntry);
    }
}

