/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.flatgeobuf.FlatgeobufDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufDirectoryDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FlatgeobufFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    private SimpleFeature nextFeature;
    private File file;
    private InputStream inputStream;
    private FlatgeobufReader flatgeobufReader;

    public FlatgeobufFeatureReader(ContentState state, Query query) throws IOException {
        this.state = state;
        ContentDataStore dataStore = state.getEntry().getDataStore();
        this.file = dataStore instanceof FlatgeobufDirectoryDataStore ? ((FlatgeobufDirectoryDataStore)dataStore).getDataStore(state.getFeatureType().getTypeName()).getFile() : ((FlatgeobufDataStore)dataStore).getFile();
    }

    private FlatgeobufReader getFlatgeobufReader() throws IOException {
        if (this.flatgeobufReader == null) {
            this.inputStream = new FileInputStream(this.file);
            this.flatgeobufReader = new FlatgeobufReader(this.state.getFeatureType().getTypeName(), this.state.getFeatureType().getGeometryDescriptor().getLocalName(), this.inputStream);
            this.flatgeobufReader.getFeatureType();
        }
        return this.flatgeobufReader;
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature feature = null;
        if (this.nextFeature != null) {
            feature = this.nextFeature;
            this.nextFeature = null;
        } else {
            feature = this.getFlatgeobufReader().getNextFeature();
        }
        return feature;
    }

    public boolean hasNext() throws IOException {
        if (this.nextFeature != null) {
            return true;
        }
        this.nextFeature = this.getFlatgeobufReader().getNextFeature();
        return this.nextFeature != null;
    }

    public void close() throws IOException {
        this.inputStream.close();
    }
}

