/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.FileInputStream;
import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.flatgeobuf.FlatgeobufDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufDirectoryDataStore;
import org.geotools.data.flatgeobuf.FlatgeobufFeatureReader;
import org.geotools.data.flatgeobuf.FlatgeobufReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.Envelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FlatgeobufFeatureSource
extends ContentFeatureSource {
    public FlatgeobufFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public FlatgeobufDataStore getDataStore() {
        ContentDataStore dataStore = super.getDataStore();
        if (dataStore instanceof FlatgeobufDirectoryDataStore) {
            return ((FlatgeobufDirectoryDataStore)dataStore).getDataStore(this.entry.getTypeName());
        }
        return (FlatgeobufDataStore)dataStore;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new FlatgeobufFeatureReader(this.getState(), query);
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope referencedEnvelope = null;
        try (FileInputStream in = new FileInputStream(this.getDataStore().getFile());){
            SimpleFeature feature;
            FlatgeobufReader reader = new FlatgeobufReader(this.getState().getFeatureType().getTypeName(), this.getState().getFeatureType().getGeometryDescriptor().getLocalName(), in);
            while ((feature = reader.getNextFeature()) != null) {
                if (referencedEnvelope == null) {
                    referencedEnvelope = new ReferencedEnvelope(feature.getBounds());
                    continue;
                }
                referencedEnvelope.expandToInclude((Envelope)new ReferencedEnvelope(feature.getBounds()));
            }
        }
        return referencedEnvelope;
    }

    protected int getCountInternal(Query query) throws IOException {
        int count = -1;
        try (FileInputStream in = new FileInputStream(this.getDataStore().getFile());){
            FlatgeobufReader reader = new FlatgeobufReader(this.getState().getFeatureType().getTypeName(), this.getState().getFeatureType().getGeometryDescriptor().getLocalName(), in);
            count = 0;
            while (reader.getNextFeature() != null) {
                ++count;
            }
        }
        return count;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.getDataStore().getFeatureType();
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

