/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.IOException;
import java.io.OutputStream;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.wololo.flatgeobuf.geotools.FeatureConversions;
import org.wololo.flatgeobuf.geotools.FeatureTypeConversions;
import org.wololo.flatgeobuf.geotools.HeaderMeta;

public class FlatgeobufWriter {
    private final OutputStream outputStream;
    private HeaderMeta headerMeta;

    public FlatgeobufWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void writeFeature(SimpleFeature feature) throws IOException {
        byte[] bytes = FeatureConversions.serialize((SimpleFeature)feature, (HeaderMeta)this.headerMeta);
        this.outputStream.write(bytes);
    }

    public void writeFeatureType(SimpleFeatureType featureType) throws IOException {
        this.headerMeta = FeatureTypeConversions.serialize((SimpleFeatureType)featureType, (long)0L, (OutputStream)this.outputStream);
    }
}

