/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.flatgeobuf.FlatGeobufFeatureSource;
import org.geotools.data.flatgeobuf.FlatGeobufFeatureStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.GeometryConversions;
import org.wololo.flatgeobuf.HeaderMeta;

public class FlatGeobufDataStore
extends ContentDataStore {
    final URL url;
    final File file;
    final String typeName;
    HeaderMeta headerMeta;
    SimpleFeatureType phantomFeatureType;

    public FlatGeobufDataStore(URL url) {
        this.url = url;
        this.file = FlatGeobufDataStore.getFile(url);
        this.typeName = FlatGeobufDataStore.getTypeName(url);
    }

    static File getFile(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                return Paths.get(url.toURI()).toFile();
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    static String getTypeName(URL url) {
        String path;
        try {
            path = url.toURI().getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        String lastSegment = path.substring(path.lastIndexOf(47) + 1);
        String name = lastSegment.substring(0, lastSegment.lastIndexOf(46));
        return name;
    }

    boolean hasIndex() throws IOException {
        this.getHeaderMeta();
        if (this.headerMeta != null) {
            return this.headerMeta.indexNodeSize > 0;
        }
        return false;
    }

    protected HeaderMeta getHeaderMeta() throws IOException {
        if (this.headerMeta == null) {
            if (this.file != null && !this.file.exists()) {
                return null;
            }
            this.headerMeta = HeaderMeta.read((InputStream)this.url.openStream());
        }
        return this.headerMeta;
    }

    protected URL getURL() {
        return this.url;
    }

    protected File getFile() {
        return this.file;
    }

    protected SimpleFeatureType getFeatureType(Name name) throws IOException {
        this.getHeaderMeta();
        if (this.headerMeta != null) {
            CoordinateReferenceSystem crs;
            SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
            ftb.setName(name);
            ftb.setAbstract(false);
            try {
                crs = this.headerMeta.srid > 0 ? CRS.decode((String)("EPSG:" + this.headerMeta.srid)) : null;
            }
            catch (FactoryException e) {
                throw new IOException(e);
            }
            ftb.setCRS(crs);
            ftb.add("geom", GeometryConversions.getGeometryClass((int)this.headerMeta.geometryType));
            for (ColumnMeta columnMeta : this.headerMeta.columns) {
                ftb.add(columnMeta.name, columnMeta.getBinding());
            }
            SimpleFeatureType featureType = ftb.buildFeatureType();
            return featureType;
        }
        if (this.phantomFeatureType != null) {
            return this.phantomFeatureType;
        }
        throw new RuntimeException("Could not get FeatureType");
    }

    protected List<Name> createTypeNames() throws IOException {
        return Collections.singletonList(this.getTypeName());
    }

    Name getTypeName() throws IOException {
        this.getHeaderMeta();
        return new NameImpl(this.namespaceURI, this.typeName);
    }

    public void createSchema(SimpleFeatureType featureType) {
        this.phantomFeatureType = featureType;
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        if (this.file != null && !this.file.exists()) {
            return new FlatGeobufFeatureStore(contentEntry, Query.ALL);
        }
        return new FlatGeobufFeatureSource(contentEntry, Query.ALL);
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("Can't delete " + this.file.getAbsolutePath() + " because it doesn't exist!");
        }
        this.file.delete();
    }

    void clearHeaderMeta() {
        this.headerMeta = null;
    }
}

