/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.feature.FeatureVisitor;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.api.filter.spatial.BBOX;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.flatgeobuf.FlatGeobufDataStore;
import org.geotools.data.flatgeobuf.FlatGeobufDirectoryDataStore;
import org.geotools.data.flatgeobuf.FlatGeobufFeatureReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Envelope;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.PackedRTree;

public class FlatGeobufFeatureSource
extends ContentFeatureSource {
    public FlatGeobufFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
    }

    public FlatGeobufDataStore getDataStore() {
        ContentDataStore dataStore = super.getDataStore();
        if (dataStore instanceof FlatGeobufDirectoryDataStore) {
            return ((FlatGeobufDirectoryDataStore)dataStore).getDataStore(this.entry.getTypeName());
        }
        return (FlatGeobufDataStore)dataStore;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new FlatGeobufFeatureReader(this.getState(), query, this.getDataStore().getHeaderMeta());
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope bbox;
        CoordinateReferenceSystem crs;
        if (query.getFilter() != Filter.INCLUDE && !(query.getFilter() instanceof BBOX)) {
            return null;
        }
        HeaderMeta headerMeta = this.getDataStore().getHeaderMeta();
        try {
            crs = headerMeta.srid > 0 ? CRS.decode((String)("EPSG:" + headerMeta.srid)) : null;
        }
        catch (FactoryException e) {
            throw new IOException(e);
        }
        Envelope env = headerMeta.envelope;
        if (env == null) {
            return null;
        }
        ReferencedEnvelope result = new ReferencedEnvelope(env, crs);
        if (query.getFilter() == Filter.INCLUDE) {
            return result;
        }
        if (query.getFilter() instanceof BBOX && (bbox = ReferencedEnvelope.reference((Bounds)((BBOX)query.getFilter()).getBounds())).contains(env)) {
            return result;
        }
        return null;
    }

    protected boolean canOffset(Query query) {
        try {
            return query.getFilter() == Filter.INCLUDE && this.getDataStore().hasIndex();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean canSort(Query query) {
        try {
            return query.getFilter() == Filter.INCLUDE && this.getDataStore().hasIndex();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected int getCountInternal(Query query) throws IOException {
        ReferencedEnvelope bounds;
        int count;
        HeaderMeta headerMeta = this.getDataStore().getHeaderMeta();
        if (headerMeta == null) {
            return -1;
        }
        Filter filter = query.getFilter();
        if ((filter == null || filter == Filter.INCLUDE) && (count = (int)this.getDataStore().getHeaderMeta().featuresCount) > 0) {
            return count;
        }
        if (filter instanceof BBOX && headerMeta.indexNodeSize > 0 && (bounds = ReferencedEnvelope.reference((Bounds)((BBOX)filter).getBounds())) != null) {
            int count2;
            Envelope headerEnvelope = headerMeta.envelope;
            if (headerEnvelope != null && bounds.contains(headerEnvelope) && (count2 = (int)this.getDataStore().getHeaderMeta().featuresCount) > 0) {
                return count2;
            }
            URL url = this.getDataStore().getURL();
            try (InputStream is = url.openStream();){
                FlatGeobufFeatureReader.skipNBytes(is, headerMeta.offset);
                PackedRTree.SearchResult result = PackedRTree.search((InputStream)is, (int)headerMeta.offset, (int)((int)headerMeta.featuresCount), (int)headerMeta.indexNodeSize, (Envelope)ReferencedEnvelope.reference((ReferencedEnvelope)bounds));
                int n = result.hits.size();
                return n;
            }
        }
        return -1;
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        return this.getDataStore().getFeatureType(this.getEntry().getName());
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

