/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.io.OutputStream;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.flatgeobuf.FeatureConversions;
import org.geotools.data.flatgeobuf.HeaderMetaUtil;
import org.wololo.flatgeobuf.Constants;
import org.wololo.flatgeobuf.HeaderMeta;

public class FlatGeobufWriter {
    private final OutputStream outputStream;
    private final FlatBufferBuilder builder;
    private HeaderMeta headerMeta;

    public FlatGeobufWriter(OutputStream outputStream, FlatBufferBuilder builder) {
        this.outputStream = outputStream;
        this.builder = builder;
    }

    public void writeFeature(SimpleFeature feature) throws IOException {
        FeatureConversions.serialize(feature, this.headerMeta, this.outputStream, this.builder);
        this.builder.clear();
    }

    public void writeFeatureType(SimpleFeatureType featureType) throws IOException {
        this.outputStream.write(Constants.MAGIC_BYTES);
        this.headerMeta = HeaderMetaUtil.fromFeatureType(featureType, 0L);
        HeaderMeta.write((HeaderMeta)this.headerMeta, (OutputStream)this.outputStream, (FlatBufferBuilder)this.builder);
        this.builder.clear();
    }
}

