/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import com.google.common.io.LittleEndianDataInputStream;
import com.google.flatbuffers.FlatBufferBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.flatgeobuf.FeatureConversions;
import org.geotools.data.flatgeobuf.FlatBuffers;
import org.geotools.data.flatgeobuf.FlatGeobufFeatureReader;
import org.geotools.data.flatgeobuf.HeaderMetaUtil;
import org.geotools.data.flatgeobuf.ReadAllInterable;
import org.geotools.data.flatgeobuf.ReadFidsIterable;
import org.geotools.data.flatgeobuf.ReadHitsIterable;
import org.geotools.data.memory.MemoryFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.locationtech.jts.geom.Envelope;
import org.wololo.flatgeobuf.Constants;
import org.wololo.flatgeobuf.HeaderMeta;
import org.wololo.flatgeobuf.PackedRTree;

public class FeatureCollectionConversions {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void serialize(SimpleFeatureCollection featureCollection, long featuresCount, OutputStream outputStream) throws IOException {
        SimpleFeatureType featureType = (SimpleFeatureType)featureCollection.getSchema();
        FlatBufferBuilder builder = FlatBuffers.newBuilder(16384);
        try {
            HeaderMeta headerMeta = HeaderMetaUtil.fromFeatureType(featureType, featuresCount);
            outputStream.write(Constants.MAGIC_BYTES);
            HeaderMeta.write((HeaderMeta)headerMeta, (OutputStream)outputStream, (FlatBufferBuilder)builder);
            builder.clear();
            try (SimpleFeatureIterator iterator = featureCollection.features();){
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    FeatureConversions.serialize(feature, headerMeta, outputStream, builder);
                    builder.clear();
                }
            }
        }
        finally {
            FlatBuffers.release(builder);
        }
    }

    public static SimpleFeatureCollection deserializeSFC(InputStream stream) throws IOException {
        HeaderMeta headerMeta = HeaderMeta.read((InputStream)stream);
        SimpleFeatureType featureType = HeaderMetaUtil.toFeatureType(headerMeta, "unknown");
        return FeatureCollectionConversions.deserializeSFC(stream, headerMeta, featureType);
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream) throws IOException {
        HeaderMeta headerMeta = HeaderMeta.read((InputStream)stream);
        SimpleFeatureType featureType = HeaderMetaUtil.toFeatureType(headerMeta, "unknown");
        return FeatureCollectionConversions.deserialize(stream, headerMeta, featureType);
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream, Envelope rect) throws IOException {
        HeaderMeta headerMeta = HeaderMeta.read((InputStream)stream);
        SimpleFeatureType featureType = HeaderMetaUtil.toFeatureType(headerMeta, "unknown");
        return FeatureCollectionConversions.deserialize(stream, headerMeta, featureType, rect);
    }

    public static SimpleFeatureCollection deserializeSFC(InputStream stream, HeaderMeta headerMeta, SimpleFeatureType ft) throws IOException {
        Iterator<SimpleFeature> it = FeatureCollectionConversions.deserialize(stream, headerMeta, ft).iterator();
        MemoryFeatureCollection fc = new MemoryFeatureCollection(ft);
        while (it.hasNext()) {
            fc.add(it.next());
        }
        return fc;
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream, long[] fids) throws IOException {
        HeaderMeta headerMeta = HeaderMeta.read((InputStream)stream);
        SimpleFeatureType featureType = HeaderMetaUtil.toFeatureType(headerMeta, "unknown");
        return FeatureCollectionConversions.deserialize(stream, headerMeta, featureType, fids);
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream, HeaderMeta headerMeta, SimpleFeatureType ft, long[] fids) throws IOException {
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(stream);
        ReadFidsIterable it = new ReadFidsIterable(fb, fids, headerMeta, data);
        return it;
    }

    private static int getTreeSize(HeaderMeta headerMeta) {
        int treeSize = headerMeta.featuresCount > 0L && headerMeta.indexNodeSize > 0 ? (int)PackedRTree.calcSize((int)((int)headerMeta.featuresCount), (int)headerMeta.indexNodeSize) : 0;
        return treeSize;
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream, HeaderMeta headerMeta, SimpleFeatureType ft) throws IOException {
        int treeSize = FeatureCollectionConversions.getTreeSize(headerMeta);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(stream);
        if (treeSize > 0) {
            FlatGeobufFeatureReader.skipNBytes((InputStream)data, treeSize);
        }
        ReadAllInterable iterable = new ReadAllInterable(headerMeta, data, fb, 0);
        return iterable;
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream, HeaderMeta headerMeta, SimpleFeatureType ft, int startIndex) throws IOException {
        int treeSize = FeatureCollectionConversions.getTreeSize(headerMeta);
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(stream);
        if (treeSize > 0) {
            if ((long)startIndex >= headerMeta.featuresCount) {
                throw new IndexOutOfBoundsException();
            }
            long[] offsets = PackedRTree.readFeatureOffsets((LittleEndianDataInputStream)data, (long[])new long[]{startIndex}, (HeaderMeta)headerMeta);
            FlatGeobufFeatureReader.skipNBytes((InputStream)data, offsets[0]);
        } else {
            startIndex = 0;
        }
        ReadAllInterable iterable = new ReadAllInterable(headerMeta, data, fb, startIndex);
        return iterable;
    }

    public static Iterable<SimpleFeature> deserialize(InputStream stream, HeaderMeta headerMeta, SimpleFeatureType ft, Envelope rect) throws IOException {
        Iterable<SimpleFeature> iterable;
        int treeSize = FeatureCollectionConversions.getTreeSize(headerMeta);
        int featuresOffset = headerMeta.offset + treeSize;
        SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ft);
        LittleEndianDataInputStream data = new LittleEndianDataInputStream(stream);
        if (headerMeta.indexNodeSize > 1) {
            PackedRTree.SearchResult result = PackedRTree.search((InputStream)data, (int)headerMeta.offset, (int)((int)headerMeta.featuresCount), (int)headerMeta.indexNodeSize, (Envelope)rect);
            int skip = treeSize - result.pos;
            if (skip > 0) {
                FlatGeobufFeatureReader.skipNBytes((InputStream)data, treeSize - result.pos);
            }
            iterable = new ReadHitsIterable(fb, result.hits, headerMeta, featuresOffset, data);
        } else {
            iterable = new ReadAllInterable(headerMeta, data, fb, 0);
        }
        return iterable;
    }
}

