/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.flatgeobuf;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.ArrayList;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.CRS;
import org.wololo.flatgeobuf.ColumnMeta;
import org.wololo.flatgeobuf.GeometryConversions;
import org.wololo.flatgeobuf.HeaderMeta;

public class HeaderMetaUtil {
    public static SimpleFeatureType toFeatureType(HeaderMeta headerMeta, String defaultName) {
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        String name = headerMeta.name;
        if (name == null || name.isEmpty()) {
            ftb.setName(defaultName);
        } else {
            ftb.setName(name);
        }
        ftb.setAbstract(false);
        ftb.setDefaultGeometry("geom");
        CoordinateReferenceSystem crs = null;
        try {
            if (headerMeta.srid != 0) {
                crs = CRS.decode((String)("EPSG:" + headerMeta.srid), (boolean)true);
            }
        }
        catch (FactoryException e) {
            throw new RuntimeException(e);
        }
        ftb.crs(crs);
        ftb.add("geom", GeometryConversions.getGeometryClass((int)headerMeta.geometryType));
        for (ColumnMeta columnMeta : headerMeta.columns) {
            ftb.add(columnMeta.name, columnMeta.getBinding());
        }
        SimpleFeatureType featureType = ftb.buildFeatureType();
        return featureType;
    }

    public static HeaderMeta fromFeatureType(SimpleFeatureType featureType, long featuresCount) {
        List types = featureType.getAttributeDescriptors();
        ArrayList<ColumnMeta> columns = new ArrayList<ColumnMeta>();
        for (AttributeDescriptor ad : types) {
            if (ad instanceof GeometryDescriptor) continue;
            String key = ad.getLocalName();
            Class binding = ad.getType().getBinding();
            ColumnMeta column = new ColumnMeta();
            column.name = key;
            if (binding.isAssignableFrom(Boolean.class)) {
                column.type = (byte)2;
            } else if (binding.isAssignableFrom(Byte.class)) {
                column.type = 0;
            } else if (binding.isAssignableFrom(Short.class)) {
                column.type = (byte)3;
            } else if (binding.isAssignableFrom(Integer.class)) {
                column.type = (byte)5;
            } else if (binding.isAssignableFrom(BigInteger.class)) {
                column.type = (byte)7;
            } else if (binding.isAssignableFrom(BigDecimal.class)) {
                column.type = (byte)10;
            } else if (binding.isAssignableFrom(Long.class)) {
                column.type = (byte)7;
            } else if (binding.isAssignableFrom(Double.class)) {
                column.type = (byte)10;
            } else if (binding.isAssignableFrom(LocalDateTime.class) || binding.isAssignableFrom(LocalDate.class) || binding.isAssignableFrom(LocalTime.class) || binding.isAssignableFrom(OffsetDateTime.class) || binding.isAssignableFrom(OffsetTime.class) || binding.isAssignableFrom(Date.class) || binding.isAssignableFrom(Time.class) || binding.isAssignableFrom(Timestamp.class)) {
                column.type = (byte)13;
            } else if (binding.isAssignableFrom(String.class)) {
                column.type = (byte)11;
            } else {
                throw new RuntimeException("Cannot handle type " + binding.getName());
            }
            columns.add(column);
        }
        byte geometryType = 0;
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        HeaderMeta headerMeta = new HeaderMeta();
        headerMeta.featuresCount = featuresCount;
        headerMeta.geometryType = geometryType;
        headerMeta.columns = columns;
        if (geometryDescriptor != null) {
            CoordinateReferenceSystem crs = geometryDescriptor.getCoordinateReferenceSystem();
            geometryType = GeometryConversions.toGeometryType((Class)featureType.getGeometryDescriptor().getType().getBinding());
            if (crs != null) {
                try {
                    Integer srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                    if (srid != null) {
                        headerMeta.srid = srid;
                    }
                }
                catch (FactoryException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return headerMeta;
    }
}

