/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.geotools.data.Query;
import org.geotools.data.geobuf.GeobufFeatureSource;
import org.geotools.data.geobuf.GeobufFeatureStore;
import org.geotools.data.geobuf.GeobufFeatureType;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class GeobufDataStore
extends ContentDataStore {
    private File file;
    private int precision = 6;
    private int dimension = 2;

    public GeobufDataStore(File file, int precision, int dimension) {
        this.file = file;
        this.precision = precision;
        this.dimension = dimension;
    }

    protected File getFile() {
        return this.file;
    }

    protected List<Name> createTypeNames() throws IOException {
        String name = this.file.getName();
        name = name.substring(0, name.lastIndexOf(46));
        NameImpl typeName = new NameImpl(name);
        return Collections.singletonList(typeName);
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        GeobufFeatureType geobufFeatureType = new GeobufFeatureType();
        try (FileOutputStream out = new FileOutputStream(this.file);){
            geobufFeatureType.encode(featureType, out);
        }
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        if (!this.file.exists() || this.file.canWrite()) {
            return new GeobufFeatureStore(contentEntry, Query.ALL, this.precision, this.dimension);
        }
        return new GeobufFeatureSource(contentEntry, Query.ALL, this.precision, this.dimension);
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        if (!this.file.exists()) {
            throw new IOException("Can't delete " + this.file.getAbsolutePath() + " because it doesn't exist!");
        }
        this.file.delete();
    }

    protected SimpleFeatureType getFeatureType() throws IOException {
        if (this.file.exists()) {
            try (FileInputStream in = new FileInputStream(this.file);){
                GeobufFeatureType geobufFeatureType = new GeobufFeatureType(this.precision, this.dimension);
                SimpleFeatureType simpleFeatureType = geobufFeatureType.decode(this.createTypeNames().get(0).getLocalPart(), in);
                return simpleFeatureType;
            }
        }
        return null;
    }
}

