/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.geotools.data.geobuf.GeobufDataStore;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.NameImpl;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;

public class GeobufDirectoryDataStore
extends ContentDataStore {
    private File directory;
    private int precision = 6;
    private int dimension = 2;

    public GeobufDirectoryDataStore(File directory, int precision, int dimension) {
        this.directory = directory;
        this.precision = precision;
        this.dimension = dimension;
    }

    protected File getDirectory() {
        return this.directory;
    }

    public void removeSchema(Name typeName) throws IOException {
        this.removeSchema(typeName.getLocalPart());
    }

    public void removeSchema(String typeName) throws IOException {
        File file;
        if (!((String)typeName).endsWith(".pbf")) {
            typeName = (String)typeName + ".pbf";
        }
        if (!(file = new File(this.directory, (String)typeName)).exists()) {
            throw new IOException("Can't delete " + file.getAbsolutePath() + " because it doesn't exist!");
        }
        file.delete();
    }

    protected GeobufDataStore getDataStore(String name) {
        File file = new File(this.directory, name + ".pbf");
        return new GeobufDataStore(file, this.precision, this.dimension);
    }

    protected List<Name> createTypeNames() throws IOException {
        File[] files = this.directory.listFiles((dir, name) -> name.endsWith(".pbf"));
        ArrayList<Name> names = new ArrayList<Name>();
        if (files != null) {
            for (File file : files) {
                String name2 = file.getName();
                names.add((Name)new NameImpl(name2.substring(0, name2.lastIndexOf(46))));
            }
        }
        return names;
    }

    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.getDataStore(featureType.getTypeName()).createSchema(featureType);
    }

    protected ContentFeatureSource createFeatureSource(ContentEntry contentEntry) throws IOException {
        return this.getDataStore(contentEntry.getTypeName()).createFeatureSource(contentEntry);
    }
}

