/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geobuf;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.geobuf.Geobuf;
import org.geotools.data.geobuf.GeobufDataStore;
import org.geotools.data.geobuf.GeobufDirectoryDataStore;
import org.geotools.data.geobuf.GeobufFeature;
import org.geotools.data.geobuf.GeobufGeometry;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentState;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class GeobufFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private ContentState state;
    private SimpleFeature nextFeature;
    private int featureIndex = 0;
    private FileInputStream in;
    private Geobuf.Data data;
    private GeobufGeometry geobufGeometry;
    private GeobufFeature geobufFeature;
    private SimpleFeatureBuilder featureBuilder;

    public GeobufFeatureReader(ContentState state, Query query, int precision, int dimension) throws IOException {
        this.state = state;
        this.geobufGeometry = new GeobufGeometry(precision, dimension, JTSFactoryFinder.getGeometryFactory(null));
        this.geobufFeature = new GeobufFeature(this.geobufGeometry);
        this.featureBuilder = new SimpleFeatureBuilder(state.getFeatureType());
        ContentDataStore dataStore = state.getEntry().getDataStore();
        File file = dataStore instanceof GeobufDirectoryDataStore ? ((GeobufDirectoryDataStore)dataStore).getDataStore(state.getFeatureType().getTypeName()).getFile() : ((GeobufDataStore)dataStore).getFile();
        this.in = new FileInputStream(file);
        this.data = Geobuf.Data.parseFrom(this.in);
    }

    public SimpleFeatureType getFeatureType() {
        return this.state.getFeatureType();
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature feature;
        if (this.nextFeature != null) {
            feature = this.nextFeature;
            this.nextFeature = null;
        } else {
            feature = this.geobufFeature.decode(this.data, this.featureIndex, this.featureBuilder);
            ++this.featureIndex;
        }
        return feature;
    }

    public boolean hasNext() throws IOException {
        if (this.nextFeature != null) {
            return true;
        }
        this.nextFeature = this.geobufFeature.decode(this.data, this.featureIndex, this.featureBuilder);
        ++this.featureIndex;
        return this.nextFeature != null;
    }

    public void close() throws IOException {
        this.in.close();
    }
}

