/*
 * Decompiled with CFR 0.152.
 */
package com.bedatadriven.jackson.datatype.jts.parsers;

import com.bedatadriven.jackson.datatype.jts.parsers.BaseParser;
import com.bedatadriven.jackson.datatype.jts.parsers.GeometryCollectionParser;
import com.bedatadriven.jackson.datatype.jts.parsers.GeometryParser;
import com.bedatadriven.jackson.datatype.jts.parsers.LineStringParser;
import com.bedatadriven.jackson.datatype.jts.parsers.MultiLineStringParser;
import com.bedatadriven.jackson.datatype.jts.parsers.MultiPointParser;
import com.bedatadriven.jackson.datatype.jts.parsers.MultiPolygonParser;
import com.bedatadriven.jackson.datatype.jts.parsers.PointParser;
import com.bedatadriven.jackson.datatype.jts.parsers.PolygonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Closeable;
import java.util.HashMap;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class GenericGeometryParser
extends BaseParser
implements GeometryParser<Geometry> {
    private Map<String, GeometryParser> parsers = new HashMap<String, GeometryParser>();

    public GenericGeometryParser(GeometryFactory geometryFactory) {
        super(geometryFactory);
        this.parsers.put("Point", new PointParser(geometryFactory));
        this.parsers.put("MultiPoint", new MultiPointParser(geometryFactory));
        this.parsers.put("LineString", new LineStringParser(geometryFactory));
        this.parsers.put("MultiLineString", new MultiLineStringParser(geometryFactory));
        this.parsers.put("Polygon", new PolygonParser(geometryFactory));
        this.parsers.put("MultiPolygon", new MultiPolygonParser(geometryFactory));
        this.parsers.put("GeometryCollection", new GeometryCollectionParser(geometryFactory, this));
    }

    @Override
    public Geometry geometryFromJson(JsonNode node) throws JsonMappingException {
        String typeName = node.get("type").asText();
        GeometryParser parser = this.parsers.get(typeName);
        if (parser != null) {
            return parser.geometryFromJson(node);
        }
        throw new JsonMappingException((Closeable)null, "Invalid geometry type: " + typeName);
    }
}

