/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.geotools.geojson.HandlerBase;
import org.geotools.geojson.IContentHandler;
import org.json.simple.parser.ParseException;

public class ComplexPropertyHandler
extends HandlerBase
implements IContentHandler<Object> {
    Object result = null;
    Deque<Object> destinationStack = new ArrayDeque<Object>();
    String objectKey = null;

    void pushState(Object destination) {
        this.destinationStack.push(destination);
    }

    void popState() {
        this.destinationStack.pop();
    }

    public boolean keepGoing() {
        return !this.destinationStack.isEmpty();
    }

    void addValue(Object obj) {
        if (this.result == null || this.destinationStack.peek() == null) {
            this.result = obj;
            return;
        }
        if (this.objectKey != null) {
            ((Map)this.destinationStack.peek()).put(this.objectKey, obj);
            this.objectKey = null;
        } else {
            ((List)this.destinationStack.peek()).add(obj);
        }
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        ArrayList destination = new ArrayList();
        this.addValue(destination);
        this.pushState(destination);
        return true;
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        this.popState();
        return this.keepGoing();
    }

    @Override
    public boolean startObject() throws ParseException, IOException {
        LinkedHashMap destinationObject = new LinkedHashMap();
        this.addValue(destinationObject);
        this.pushState(destinationObject);
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        this.popState();
        return this.keepGoing();
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        this.objectKey = key;
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        this.addValue(value);
        return true;
    }

    @Override
    public Object getValue() {
        return this.result;
    }
}

