/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geojson.feature;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.DelegatingHandler;
import org.geotools.geojson.IContentHandler;
import org.geotools.geojson.feature.CRSHandler;
import org.geotools.geojson.feature.DefaultAttributeIO;
import org.geotools.geojson.feature.FeatureHandler;
import org.json.simple.parser.ParseException;

public class FeatureTypeHandler
extends DelegatingHandler<SimpleFeatureType>
implements IContentHandler<SimpleFeatureType> {
    SimpleFeatureType featureType;
    private boolean inFeatures = false;
    private Map<String, Class<?>> propertyTypes = new LinkedHashMap();
    private boolean inProperties;
    private int complexNestingLevel;
    private String currentProp;
    private CoordinateReferenceSystem crs;
    private boolean nullValuesEncoded;
    private GeometryDescriptor geom;

    public FeatureTypeHandler(boolean nullValuesEncoded) {
        this.nullValuesEncoded = nullValuesEncoded;
    }

    @Override
    public boolean startObjectEntry(String key) throws ParseException, IOException {
        if (this.complexNestingLevel > 0) {
            return true;
        }
        if ("crs".equals(key)) {
            this.delegate = new CRSHandler();
            return true;
        }
        if ("features".equals(key)) {
            this.delegate = UNINITIALIZED;
            this.inFeatures = true;
            return true;
        }
        if (this.inFeatures && this.delegate == NULL) {
            if ("properties".equals(key)) {
                this.inProperties = true;
                return true;
            }
            if (this.inProperties) {
                if (!this.propertyTypes.containsKey(key)) {
                    this.propertyTypes.put(key, Object.class);
                }
                this.currentProp = key;
                return true;
            }
        }
        return super.startObjectEntry(key);
    }

    @Override
    public boolean startArray() throws ParseException, IOException {
        if (this.delegate == UNINITIALIZED) {
            this.delegate = new FeatureHandler(null, new DefaultAttributeIO());
            return true;
        }
        if (this.inProperties && this.currentProp != null) {
            if (this.complexNestingLevel++ == 0) {
                if (!this.propertyTypes.containsKey(this.currentProp)) {
                    this.propertyTypes.put(this.currentProp, List.class);
                } else {
                    this.checkValueCompatibility(List.class);
                }
            }
            return true;
        }
        return super.startArray();
    }

    @Override
    public boolean endArray() throws ParseException, IOException {
        super.endArray();
        if (this.inProperties) {
            --this.complexNestingLevel;
        }
        return true;
    }

    @Override
    public boolean startObject() throws ParseException, IOException {
        super.startObject();
        if (this.inProperties && this.currentProp != null && this.complexNestingLevel++ == 0) {
            if (!this.propertyTypes.containsKey(this.currentProp)) {
                this.propertyTypes.put(this.currentProp, Map.class);
            } else {
                this.checkValueCompatibility(Map.class);
            }
        }
        return true;
    }

    @Override
    public boolean endObject() throws ParseException, IOException {
        SimpleFeature feature;
        super.endObject();
        if (this.inProperties && this.currentProp != null) {
            --this.complexNestingLevel;
        }
        if (this.complexNestingLevel > 0) {
            return true;
        }
        if (this.delegate instanceof FeatureHandler && (feature = ((FeatureHandler)this.delegate).getValue()) != null) {
            this.geom = feature.getFeatureType().getGeometryDescriptor();
            List attributeDescriptors = feature.getFeatureType().getAttributeDescriptors();
            for (AttributeDescriptor ad : attributeDescriptors) {
                if (ad.equals(this.geom)) continue;
                this.propertyTypes.put(ad.getLocalName(), ad.getType().getBinding());
            }
            this.delegate = NULL;
            if (this.foundAllValues()) {
                this.buildType();
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean primitive(Object value) throws ParseException, IOException {
        if (this.inProperties && this.complexNestingLevel == 0 && this.currentProp != null && !this.checkValueCompatibility(value)) {
            return false;
        }
        return super.primitive(value);
    }

    private boolean checkValueCompatibility(Object value) {
        if (value != null) {
            return this.checkValueCompatibility(value.getClass());
        }
        return true;
    }

    private boolean checkValueCompatibility(Class<?> newType) {
        Class<?> knownType = this.propertyTypes.get(this.currentProp);
        if (knownType == Object.class) {
            this.propertyTypes.put(this.currentProp, newType);
            if (this.foundAllValues()) {
                this.buildType();
                return false;
            }
        } else if (knownType != newType) {
            if (Number.class.isAssignableFrom(knownType) && newType == Double.class || Number.class.isAssignableFrom(newType) && knownType == Double.class) {
                this.propertyTypes.put(this.currentProp, Double.class);
            } else {
                throw new IllegalStateException("Found conflicting types " + knownType.getSimpleName() + " and " + newType.getSimpleName() + " for property " + this.currentProp);
            }
        }
        return true;
    }

    private boolean foundAllValues() {
        return this.nullValuesEncoded && this.geom != null && this.crs != null && !this.thereAreUnknownDataTypes();
    }

    private boolean thereAreUnknownDataTypes() {
        for (Class<?> clazz : this.propertyTypes.values()) {
            if (clazz != Object.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean endObjectEntry() throws ParseException, IOException {
        super.endObjectEntry();
        if (this.complexNestingLevel > 0) {
            return true;
        }
        if (this.delegate != null && this.delegate instanceof CRSHandler) {
            this.crs = ((CRSHandler)this.delegate).getValue();
            if (this.crs != null) {
                this.delegate = NULL;
            }
        } else if (this.currentProp != null) {
            this.currentProp = null;
        }
        return true;
    }

    @Override
    public void endJSON() throws ParseException, IOException {
        this.buildType();
    }

    private void buildType() {
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName("feature");
        typeBuilder.setNamespaceURI("http://geotools.org");
        if (this.geom != null) {
            typeBuilder.add(this.geom.getLocalName(), this.geom.getType().getBinding(), this.crs);
        }
        if (this.propertyTypes != null) {
            Set<Map.Entry<String, Class<?>>> entrySet = this.propertyTypes.entrySet();
            for (Map.Entry<String, Class<?>> entry : entrySet) {
                Class<Object> binding = entry.getValue();
                if (binding.equals(Object.class)) {
                    binding = String.class;
                }
                typeBuilder.add(entry.getKey(), binding);
            }
        }
        if (this.crs != null) {
            typeBuilder.setCRS(this.crs);
        }
        this.featureType = typeBuilder.buildFeatureType();
    }

    @Override
    public SimpleFeatureType getValue() {
        return this.featureType;
    }
}

