/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStore;
import org.geotools.data.FileDataStore;
import org.geotools.data.FileDataStoreFactorySpi;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.util.KVP;
import org.geotools.util.URLs;

public class GeoJSONDataStoreFactory
implements FileDataStoreFactorySpi {
    private static final String[] EXTENSIONS = new String[]{"geojson", "json", "gjson"};
    Boolean isAvailable;
    public static final DataAccessFactory.Param FILE_PARAM = new DataAccessFactory.Param("file", File.class, "GeoJSON file", false, null, (Map)new KVP(new Object[]{"ext", "geojson"}));
    public static final DataAccessFactory.Param URL_PARAM = new DataAccessFactory.Param("url", URL.class, "GeoJSON URL", false, null, (Map)new KVP(new Object[]{"ext", "geojson"}));

    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    public String getDisplayName() {
        return "GeoJSON";
    }

    public String getDescription() {
        return "GeoJSON file or URL";
    }

    public DataStore createDataStore(Map<String, Serializable> params) throws IOException {
        URL url = (URL)URL_PARAM.lookUp(params);
        File file = (File)FILE_PARAM.lookUp(params);
        if (url == null && file == null) {
            throw new IOException("No file or url parameter provided");
        }
        if (file != null) {
            return new GeoJSONDataStore(file);
        }
        return new GeoJSONDataStore(url);
    }

    public DataStore createNewDataStore(Map<String, Serializable> params) throws IOException {
        URL url = (URL)URL_PARAM.lookUp(params);
        File file = (File)FILE_PARAM.lookUp(params);
        if (url == null && file == null) {
            throw new IOException("No file or url parameter provided");
        }
        if (url != null && "file".equalsIgnoreCase(url.getProtocol())) {
            file = URLs.urlToFile((URL)url);
        }
        if (file != null) {
            if (!file.exists()) {
                file.createNewFile();
            }
            return new GeoJSONDataStore(file);
        }
        return new GeoJSONDataStore(url);
    }

    public synchronized boolean isAvailable() {
        if (this.isAvailable == null) {
            try {
                Class<?> geoJSONReaderType = Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
                ObjectMapper mapper = new ObjectMapper();
                mapper.registerModule((Module)new JtsModule());
                this.isAvailable = true;
            }
            catch (ClassNotFoundException e) {
                this.isAvailable = false;
            }
        }
        return this.isAvailable;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return new DataAccessFactory.Param[]{FILE_PARAM, URL_PARAM};
    }

    public String[] getFileExtensions() {
        return EXTENSIONS;
    }

    public boolean canProcess(Map<String, Serializable> params) {
        try {
            URL url = (URL)URL_PARAM.lookUp(params);
            File file = (File)FILE_PARAM.lookUp(params);
            if (file == null && url == null) {
                return false;
            }
            String name = file != null ? file.getPath().toLowerCase() : url.getPath().toLowerCase();
            if (name != null) {
                for (String ext : EXTENSIONS) {
                    if (!name.endsWith(ext)) continue;
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public boolean canProcess(URL url) {
        return false;
    }

    public FileDataStore createDataStore(URL url) throws IOException {
        return null;
    }

    public String getTypeName(URL url) throws IOException {
        return null;
    }
}

