/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import java.io.IOException;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.geojson.GeoJSONDataStore;
import org.geotools.data.geojson.GeoJSONFeatureReader;
import org.geotools.data.geojson.GeoJSONReader;
import org.geotools.data.store.ContentDataStore;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONFeatureSource
extends ContentFeatureSource {
    boolean quick = true;

    public GeoJSONFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
        this.transaction = this.getState().getTransaction();
    }

    public GeoJSONFeatureSource(GeoJSONDataStore datastore) {
        this(datastore, Query.ALL);
    }

    public GeoJSONFeatureSource(GeoJSONDataStore datastore, Query query) {
        this(new ContentEntry((ContentDataStore)datastore, datastore.getTypeName()), query);
    }

    public GeoJSONFeatureSource(ContentEntry entry) {
        this(entry, Query.ALL);
    }

    public GeoJSONDataStore getDataStore() {
        return (GeoJSONDataStore)super.getDataStore();
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        ReferencedEnvelope env = new ReferencedEnvelope(this.getDataStore().getCrs());
        if (query.getFilter() == Filter.INCLUDE) {
            try (GeoJSONReader reader = this.getDataStore().read();
                 FeatureIterator<SimpleFeature> itr = reader.getIterator();){
                while (itr.hasNext()) {
                    SimpleFeature f = (SimpleFeature)itr.next();
                    env.expandToInclude(((Geometry)f.getDefaultGeometry()).getEnvelopeInternal());
                }
            }
        }
        return env;
    }

    protected int getCountInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            try (GeoJSONReader reader = this.getDataStore().read();){
                int n;
                block14: {
                    int count = 0;
                    FeatureIterator<SimpleFeature> itr = reader.getIterator();
                    try {
                        while (itr.hasNext()) {
                            itr.next();
                            ++count;
                        }
                        n = count;
                        if (itr == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (itr != null) {
                            try {
                                itr.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    itr.close();
                }
                return n;
            }
        }
        return -1;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new GeoJSONFeatureReader(this.getState(), query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(this.entry.getName());
        try (GeoJSONReader reader = this.getDataStore().read();){
            try (FeatureIterator<SimpleFeature> itr = reader.getIterator();){
                boolean empty = true;
                while (itr.hasNext()) {
                    empty = false;
                    itr.next();
                    this.schema = (SimpleFeatureType)reader.getSchema();
                    if (!this.quick) continue;
                }
                if (empty) {
                    SimpleFeatureType simpleFeatureType = this.schema = this.getDataStore().getSchema();
                    return simpleFeatureType;
                }
            }
            builder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            SimpleFeatureType simpleFeatureType = this.schema;
            return simpleFeatureType;
        }
    }

    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }

    public boolean isQuick() {
        return this.quick;
    }

    public void setQuick(boolean quick) {
        this.quick = quick;
    }
}

