/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.bedatadriven.jackson.datatype.jts.parsers.GenericGeometryParser;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FilenameUtils;
import org.geotools.data.DataUtilities;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.Geometries;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONReader
implements AutoCloseable {
    public static final String GEOMETRY_NAME = "the_geom";
    private static final Logger LOGGER = Logging.getLogger(GeoJSONReader.class);
    private JsonParser parser;
    private static JsonFactory factory = new JsonFactory();
    private SimpleFeatureType schema;
    SimpleFeatureTypeBuilder typeBuilder = null;
    private SimpleFeatureBuilder builder;
    private int nextID = 0;
    private String baseName = "features";
    private boolean schemaChanged = false;
    private GeometryFactory gFac = new GeometryFactory();
    private URL url;

    public GeoJSONReader(URL url) throws IOException {
        this.url = url;
        this.parser = factory.createParser(url);
        this.baseName = FilenameUtils.getBaseName((String)url.getPath());
    }

    public GeoJSONReader(InputStream is) throws IOException {
        this.parser = factory.createParser(is);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean isConnected() {
        if (this.url != null) {
            try (InputStream inputStream = this.url.openStream();){
                boolean bl;
                block17: {
                    if (inputStream != null && inputStream.available() > 0) {
                        boolean bl2 = true;
                        return bl2;
                    }
                    this.url = new URL(this.url.toExternalForm());
                    InputStream inputStream2 = this.url.openStream();
                    try {
                        boolean bl3 = bl = inputStream2 != null && inputStream2.available() > 0;
                        if (inputStream2 == null) break block17;
                    }
                    catch (Throwable throwable) {
                        if (inputStream2 != null) {
                            try {
                                inputStream2.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    inputStream2.close();
                }
                return bl;
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, "Failure trying to determine if connected", e);
                return false;
            }
        }
        return true;
    }

    public static SimpleFeature parseFeature(String json) throws JsonParseException, IOException {
        try (JsonParser lParser = factory.createParser((InputStream)new ByteArrayInputStream(json.getBytes()));){
            SimpleFeature simpleFeature;
            ObjectMapper mapper = new ObjectMapper();
            mapper.registerModule((Module)new JtsModule());
            ObjectNode node = (ObjectNode)mapper.readTree(lParser);
            try (GeoJSONReader reader = new GeoJSONReader((InputStream)null);){
                SimpleFeature feature;
                simpleFeature = feature = reader.getNextFeature(node);
            }
            return simpleFeature;
        }
    }

    public FeatureCollection getFeatures() throws IOException {
        JsonToken token;
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JtsModule());
        ArrayList<SimpleFeature> features = new ArrayList<SimpleFeature>();
        this.builder = null;
        while (!this.parser.isClosed() && (token = this.parser.nextToken()) != null) {
            if (!JsonToken.FIELD_NAME.equals((Object)token) || !"features".equalsIgnoreCase(this.parser.currentName())) continue;
            token = this.parser.nextToken();
            if (!JsonToken.START_ARRAY.equals((Object)token) || token == null) break;
            while (this.parser.nextToken() == JsonToken.START_OBJECT) {
                ObjectNode node = (ObjectNode)mapper.readTree(this.parser);
                SimpleFeature feature = this.getNextFeature(node);
                features.add(feature);
            }
        }
        if (this.isSchemaChanged()) {
            ArrayList<SimpleFeature> nFeatures = new ArrayList<SimpleFeature>(features.size());
            for (SimpleFeature feature : features) {
                if (feature.getFeatureType() != this.schema) {
                    SimpleFeature nFeature = DataUtilities.reType((SimpleFeatureType)this.schema, (SimpleFeature)feature);
                    nFeatures.add(nFeature);
                    continue;
                }
                nFeatures.add(feature);
            }
            return DataUtilities.collection(nFeatures);
        }
        return DataUtilities.collection(features);
    }

    private SimpleFeature getNextFeature(ObjectNode node) throws IOException {
        JsonNode type = node.get("type");
        if (!"Feature".equalsIgnoreCase(type.asText())) {
            throw new RuntimeException("Unexpected object type in GeoJSON Parsing, expected Feature got '" + type.asText() + "'");
        }
        JsonNode props = node.get("properties");
        if (this.builder == null) {
            this.builder = this.getBuilder(props);
        }
        boolean restart = true;
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JtsModule());
        SimpleFeature feature = null;
        while (restart) {
            restart = false;
            Iterator fields = props.fields();
            while (fields.hasNext()) {
                Class binding;
                Map.Entry n = (Map.Entry)fields.next();
                AttributeDescriptor descriptor = this.schema.getDescriptor((String)n.getKey());
                if (descriptor == null) {
                    restart = true;
                    this.builder = null;
                    this.schema = null;
                    this.builder = this.getBuilder(props);
                    this.setSchemaChanged(true);
                    descriptor = this.schema.getDescriptor((String)n.getKey());
                }
                if ((binding = descriptor.getType().getBinding()) == Integer.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asInt());
                    continue;
                }
                if (binding == Double.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).asDouble());
                    continue;
                }
                if (binding == String.class) {
                    this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).textValue());
                    continue;
                }
                if (binding.isAssignableFrom(Geometry.class)) {
                    GenericGeometryParser gParser = new GenericGeometryParser(this.gFac);
                    Geometry g = gParser.geometryFromJson((JsonNode)n.getValue());
                    this.builder.set((String)n.getKey(), (Object)g);
                    continue;
                }
                LOGGER.warning("Unable to parse object of type " + binding);
                this.builder.set((String)n.getKey(), (Object)((JsonNode)n.getValue()).toString());
            }
            JsonNode geom = node.get("geometry");
            GenericGeometryParser gParser = new GenericGeometryParser(this.gFac);
            Geometry g = gParser.geometryFromJson(geom);
            this.builder.set(GEOMETRY_NAME, (Object)g);
            String newId = this.baseName + "." + this.nextID++;
            feature = this.builder.buildFeature(newId);
        }
        return feature;
    }

    private SimpleFeatureBuilder getBuilder(JsonNode props) {
        if (this.schema == null) {
            this.typeBuilder = new SimpleFeatureTypeBuilder();
            this.typeBuilder.setCRS((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.typeBuilder.setName(this.baseName);
            if (this.typeBuilder.getDefaultGeometry() == null) {
                this.typeBuilder.setDefaultGeometry(GEOMETRY_NAME);
                this.typeBuilder.add(GEOMETRY_NAME, Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            }
            Iterator fields = props.fields();
            while (fields.hasNext()) {
                Map.Entry n = (Map.Entry)fields.next();
                this.typeBuilder.nillable(true);
                JsonNode value = (JsonNode)n.getValue();
                if (value instanceof IntNode) {
                    this.typeBuilder.add((String)n.getKey(), Integer.class);
                    continue;
                }
                if (value instanceof DoubleNode) {
                    this.typeBuilder.add((String)n.getKey(), Double.class);
                    continue;
                }
                if (value instanceof ObjectNode) {
                    String type = value.get("type").asText();
                    Geometries namedType = Geometries.getForName((String)type);
                    if (namedType == null) continue;
                    this.typeBuilder.add((String)n.getKey(), Geometry.class, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                    continue;
                }
                this.typeBuilder.defaultValue((Object)"");
                this.typeBuilder.add((String)n.getKey(), String.class);
            }
            this.schema = this.typeBuilder.buildFeatureType();
        }
        return new SimpleFeatureBuilder(this.schema);
    }

    public FeatureIterator<SimpleFeature> getIterator() throws IOException {
        if (!this.isConnected()) {
            LOGGER.fine("trying to read an unconnected data stream");
            return new DefaultFeatureCollection(null, null).features();
        }
        return new GeoJsonIterator(this.parser);
    }

    public FeatureType getSchema() throws IOException {
        if (!this.isConnected()) {
            throw new IOException("not connected to " + this.url.toExternalForm());
        }
        return this.schema;
    }

    public void setSchema(SimpleFeatureType schema) {
        this.schema = schema;
    }

    public boolean isSchemaChanged() {
        return this.schemaChanged;
    }

    public void setSchemaChanged(boolean schemaChanged) {
        this.schemaChanged = schemaChanged;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
        this.parser = null;
    }

    private class GeoJsonIterator
    implements FeatureIterator<SimpleFeature>,
    AutoCloseable {
        ObjectMapper mapper = new ObjectMapper();
        JsonParser parser;
        private SimpleFeature feature;

        public GeoJsonIterator(JsonParser parser) throws IOException {
            JsonToken token;
            if (!GeoJSONReader.this.isConnected()) {
                throw new IOException("not connected to " + GeoJSONReader.this.url.toExternalForm());
            }
            this.parser = parser;
            GeoJSONReader.this.builder = null;
            while (!parser.isClosed() && (token = parser.nextToken()) != null) {
                if (!JsonToken.FIELD_NAME.equals((Object)token) || !"features".equalsIgnoreCase(parser.currentName())) continue;
                token = parser.nextToken();
                if (JsonToken.START_ARRAY.equals((Object)token) && token != null) break;
                throw new IOException("No Features found");
            }
        }

        public boolean hasNext() {
            if (this.feature != null) {
                return true;
            }
            try {
                if (this.parser.nextToken() == JsonToken.START_OBJECT) {
                    ObjectNode node = (ObjectNode)this.mapper.readTree(this.parser);
                    this.feature = GeoJSONReader.this.getNextFeature(node);
                    if (this.feature != null) {
                        return true;
                    }
                }
            }
            catch (IOException e) {
                LOGGER.log(Level.FINER, e.getMessage(), e);
            }
            return false;
        }

        public SimpleFeature next() throws NoSuchElementException {
            if (this.feature != null) {
                SimpleFeature ret = this.feature;
                this.feature = null;
                return ret;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void close() {
            this.parser = null;
        }
    }
}

