/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geojson;

import com.bedatadriven.jackson.datatype.jts.JtsModule;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.GeometryType;
import org.opengis.feature.type.PropertyType;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class GeoJSONWriter
implements AutoCloseable {
    private OutputStream out;
    JsonGenerator generator;
    private ObjectMapper mapper;
    private CoordinateReferenceSystem outCRS;
    private MathTransform transform;
    private CoordinateReferenceSystem lastCRS;

    public GeoJSONWriter(OutputStream outputStream) throws IOException {
        CRSAuthorityFactory cFactory = CRS.getAuthorityFactory((boolean)true);
        try {
            this.outCRS = cFactory.createCoordinateReferenceSystem("EPSG:4326");
        }
        catch (FactoryException e) {
            throw new RuntimeException("CRS factory not found in GeoJSONDatastore writer", e);
        }
        this.mapper = new ObjectMapper();
        this.mapper.registerModule((Module)new JtsModule());
        this.out = outputStream instanceof BufferedOutputStream ? outputStream : new BufferedOutputStream(outputStream);
        JsonFactory factory = new JsonFactory();
        this.generator = factory.createGenerator(this.out);
        this.generator.writeStartObject();
        this.generator.writeStringField("type", "FeatureCollection");
        this.generator.writeFieldName("features");
        this.generator.writeStartArray();
    }

    public void write(SimpleFeature currentFeature) throws IOException {
        this.generator.writeStartObject();
        this.generator.writeStringField("type", "Feature");
        this.generator.writeFieldName("properties");
        this.generator.writeStartObject();
        for (Property p : currentFeature.getProperties()) {
            PropertyType type = p.getType();
            if (type instanceof GeometryType) continue;
            Object value = p.getValue();
            String name = p.getName().getLocalPart();
            if (value == null) {
                this.generator.writeNullField(name);
                continue;
            }
            Class binding = p.getType().getBinding();
            if (binding == Integer.class) {
                this.generator.writeNumberField(name, ((Integer)value).intValue());
                continue;
            }
            if (binding == Double.class) {
                this.generator.writeNumberField(name, ((Double)value).doubleValue());
                continue;
            }
            this.generator.writeFieldName(name);
            this.generator.writeString(value.toString());
        }
        this.generator.writeEndObject();
        this.generator.writeFieldName("geometry");
        Geometry defaultGeometry = (Geometry)currentFeature.getDefaultGeometry();
        CoordinateReferenceSystem inCRS = currentFeature.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
        if (this.transform == null || inCRS != this.lastCRS) {
            this.lastCRS = inCRS;
            try {
                this.transform = CRS.findMathTransform((CoordinateReferenceSystem)inCRS, (CoordinateReferenceSystem)this.outCRS, (boolean)true);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
        }
        if (!CRS.equalsIgnoreMetadata((Object)inCRS, (Object)this.outCRS)) {
            try {
                defaultGeometry = JTS.transform((Geometry)defaultGeometry, (MathTransform)this.transform);
            }
            catch (MismatchedDimensionException | TransformException e) {
                throw new RuntimeException(e);
            }
        }
        if (defaultGeometry != null) {
            String gString = this.mapper.writeValueAsString((Object)defaultGeometry);
            this.generator.writeRawValue(gString);
            this.generator.writeStringField("id", currentFeature.getID());
        } else {
            this.generator.writeNull();
        }
        this.generator.writeEndObject();
        this.generator.flush();
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.generator.writeEndArray();
            this.generator.writeEndObject();
            this.generator.close();
        }
        finally {
            this.out.close();
        }
    }
}

