/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.api.feature.type.Name;
import org.geotools.api.referencing.FactoryException;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.data.duckdb.DuckDBDialect;
import org.geotools.data.geoparquet.GeoParquetConfig;
import org.geotools.data.geoparquet.GeoParquetFilterToSQL;
import org.geotools.data.geoparquet.GeoParquetViewManager;
import org.geotools.data.geoparquet.GeoparquetDatasetMetadata;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.data.store.ContentEntry;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jackson.datatype.geoparquet.GeoParquetMetadata;
import org.geotools.jdbc.AutoGeneratedPrimaryKeyColumn;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.jdbc.PrimaryKey;
import org.geotools.jdbc.PrimaryKeyFinder;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;

public class GeoParquetDialect
extends DuckDBDialect {
    private static final Logger LOGGER = Logging.getLogger(GeoParquetDialect.class);
    private final GeoParquetViewManager viewManager;
    private Map<String, GeoparquetDatasetMetadata> geoparquetMetadata = new ConcurrentHashMap<String, GeoparquetDatasetMetadata>();
    static final ThreadLocal<String> CURRENT_TYPENAME = new ThreadLocal();

    public GeoParquetDialect(JDBCDataStore dataStore) {
        super(dataStore);
        this.viewManager = new GeoParquetViewManager(dataStore);
    }

    public void ensureViewExists(String viewName) throws IOException {
        this.viewManager.createViewIfNotExists(viewName);
    }

    public List<String> getTypeNames() throws IOException {
        return this.viewManager.getViewNames();
    }

    Connection getConnection() throws IOException {
        return this.viewManager.getConnection();
    }

    @Override
    public FilterToSQL createFilterToSQL() {
        return new GeoParquetFilterToSQL();
    }

    @Override
    public List<String> getDatabaseInitSql() {
        ArrayList<String> initScript = new ArrayList<String>(super.getDatabaseInitSql());
        initScript.add("install httpfs");
        initScript.add("load httpfs");
        initScript.add("install parquet");
        initScript.add("load parquet");
        return initScript;
    }

    public void initialize(GeoParquetConfig config) throws IOException {
        this.geoparquetMetadata.clear();
        this.viewManager.initialize(config);
    }

    public GeoparquetDatasetMetadata getGeoparquetMetadata(String typeName) throws IOException {
        GeoparquetDatasetMetadata md = this.geoparquetMetadata.get(typeName);
        if (md == null) {
            try (Connection c = this.viewManager.getConnection();){
                md = this.getGeoparquetMetadata(typeName, c);
            }
            catch (SQLException e) {
                throw new IOException(e);
            }
        }
        return md;
    }

    GeoparquetDatasetMetadata getGeoparquetMetadata(String featureType, Connection cx) {
        return this.geoparquetMetadata.computeIfAbsent(featureType, view -> this.loadGeoparquetMetadata(featureType, cx));
    }

    public GeoparquetDatasetMetadata loadGeoparquetMetadata(String viewName, Connection cx) {
        String lookUpUri = this.viewManager.getVieUri(viewName);
        String sql = String.format("SELECT file_name, decode(value) AS value FROM parquet_kv_metadata('%s') WHERE key = 'geo'", lookUpUri);
        HashMap<String, GeoParquetMetadata> parquetMetadataByFileName = new HashMap<String, GeoParquetMetadata>();
        try (Statement st = cx.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                String geo;
                String fileName = rs.getString("file_name");
                GeoParquetMetadata md = this.parseMetadata(fileName, geo = rs.getString("value"));
                if (md == null) continue;
                parquetMetadataByFileName.put(fileName, md);
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
        return new GeoparquetDatasetMetadata(parquetMetadataByFileName);
    }

    private GeoParquetMetadata parseMetadata(String fileName, String geoMetadata) {
        if (geoMetadata != null) {
            try {
                return GeoParquetMetadata.readValue(geoMetadata);
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e, () -> String.format("Error parsing geoparquet metadata. File: %s, geo: %s", fileName, geoMetadata));
            }
        }
        return null;
    }

    public PrimaryKeyFinder getPrimaryKeyFinder() {
        return new PrimaryKeyFinder(){

            public PrimaryKey getPrimaryKey(JDBCDataStore store, String schema, String table, Connection cx) {
                List<AutoGeneratedPrimaryKeyColumn> columns = List.of(new AutoGeneratedPrimaryKeyColumn("id", String.class));
                return new PrimaryKey(table, columns);
            }
        };
    }

    @Override
    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        if (null == featureType.getGeometryDescriptor()) {
            return List.of();
        }
        GeoparquetDatasetMetadata md = this.getGeoparquetMetadata(featureType.getTypeName(), cx);
        ReferencedEnvelope bounds = !md.isEmpty() ? md.getBounds() : (featureType.getDescriptor("bbox") != null ? this.computeBoundsFromBboxColumn(featureType, cx) : super.optimizedBounds(featureType, cx));
        return List.of(Objects.requireNonNull(bounds));
    }

    ReferencedEnvelope computeBoundsFromBboxColumn(SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        String sql = String.format("SELECT ST_AsWKB(ST_MakeEnvelope(MIN(bbox.xmin), MIN(bbox.ymin), MAX(bbox.xmax), MAX(bbox.ymax))::GEOMETRY)::BLOB FROM %s", this.escapeName(featureType.getTypeName()));
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            ReferencedEnvelope referencedEnvelope;
            block13: {
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new RuntimeException("Could not compute bounds from bbox column, no result found");
                    }
                    Geometry fullBounds = this.parseWKB(rs.getBlob(1));
                    GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
                    CoordinateReferenceSystem crs = geometryDescriptor.getCoordinateReferenceSystem();
                    referencedEnvelope = new ReferencedEnvelope(fullBounds.getEnvelopeInternal(), crs);
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return referencedEnvelope;
        }
    }

    @Override
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) {
        Objects.requireNonNull(tableName);
        Objects.requireNonNull(columnName);
        Objects.requireNonNull(cx);
        Integer srid = null;
        try {
            GeoparquetDatasetMetadata metadata = this.getGeoparquetMetadata(tableName, cx);
            srid = this.getGeometrySRIDInternal(metadata, columnName);
            if (srid == null) {
                CoordinateReferenceSystem crs = metadata.getCrs();
                srid = this.lookupEpsgCode(crs);
            }
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Error getting CRS from GeoParquet metadata", e);
        }
        if (srid == null) {
            srid = 4326;
        }
        return srid;
    }

    public CoordinateReferenceSystem createCRS(int srid, Connection cx) throws SQLException {
        String typeName = CURRENT_TYPENAME.get();
        if (typeName != null) {
            GeoparquetDatasetMetadata md = this.getGeoparquetMetadata(typeName, cx);
            CoordinateReferenceSystem crs = md.getCrs();
            try {
                Integer id = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)false);
                if (id != null && id == srid) {
                    return crs;
                }
            }
            catch (FactoryException e) {
                LOGGER.log(Level.FINE, "Could not figure out CRS id, proceeding with regular parsing of the provided id");
            }
        }
        boolean longitudeFirst = true;
        try {
            return CRS.decode((String)("EPSG:" + srid), (boolean)longitudeFirst);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Could not decode EPSG:" + srid + " using the EPSG plugins.");
            return null;
        }
    }

    @Override
    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        boolean forceMulti = this.shouldEnforceMuliForCurrentTypeName(gatt.getLocalName());
        this.encodeGeometryColumnInternal(gatt, prefix, hints, forceMulti, sql);
    }

    public SimpleFeatureType fixGeometryTypes(SimpleFeatureType schema) throws IOException {
        SimpleFeatureType featureType;
        this.ensureViewExists(schema.getTypeName());
        try {
            featureType = this.viewManager.getViewFeatureType(schema, this::buildTypeNarrowedGeometryFeatureType);
        }
        catch (UncheckedIOException e) {
            throw e.getCause();
        }
        Name name = featureType.getName();
        ContentEntry entry = this.dataStore.getEntry(name);
        entry.getState(Transaction.AUTO_COMMIT).setFeatureType(featureType);
        return featureType;
    }

    private SimpleFeatureType buildTypeNarrowedGeometryFeatureType(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(schema);
        schema.getAttributeDescriptors().stream().filter(GeometryDescriptor.class::isInstance).map(GeometryDescriptor.class::cast).map(d -> this.buildGeometryDescriptorOverride(schema.getTypeName(), (GeometryDescriptor)d)).forEach(overriding -> builder.set(overriding.getLocalName(), (AttributeDescriptor)overriding));
        return builder.buildFeatureType();
    }

    private GeometryDescriptor buildGeometryDescriptorOverride(String typeName, GeometryDescriptor orig) {
        String geometryAttirbute = orig.getLocalName();
        Class<? extends Geometry> narrowedGeomType = this.getNarrowedGeometryType(typeName, geometryAttirbute);
        if (narrowedGeomType.equals(orig.getType().getBinding())) {
            return orig;
        }
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.init((AttributeDescriptor)orig);
        builder.setBinding(narrowedGeomType);
        return (GeometryDescriptor)builder.buildDescriptor(geometryAttirbute);
    }

    private Class<? extends Geometry> getNarrowedGeometryType(String typeName, String geometryAttirbute) {
        GeoparquetDatasetMetadata md;
        try {
            md = this.getGeoparquetMetadata(typeName);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return md.getNarrowedGeometryType(geometryAttirbute);
    }

    private boolean shouldEnforceMuliForCurrentTypeName(String geometryAttribute) {
        String typeName = CURRENT_TYPENAME.get();
        if (typeName == null) {
            return false;
        }
        Class<? extends Geometry> type = this.getNarrowedGeometryType(typeName, geometryAttribute);
        return GeometryCollection.class.isAssignableFrom(type);
    }

    Integer getGeometrySRIDInternal(GeoparquetDatasetMetadata metadata, String columnName) {
        Integer srid = null;
        if (metadata.getColumn(columnName).isPresent()) {
            CoordinateReferenceSystem crs = metadata.getCrs(columnName);
            srid = this.lookupEpsgCode(crs);
        }
        return srid;
    }

    private Integer lookupEpsgCode(CoordinateReferenceSystem crs) {
        Integer srid = null;
        if (crs != null) {
            try {
                srid = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            }
            catch (FactoryException e) {
                LOGGER.log(Level.FINE, "Could not determine EPSG code from CRS", e);
            }
        }
        return srid;
    }
}

