/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Struct;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.feature.type.AttributeDescriptor;
import org.geotools.api.feature.type.GeometryDescriptor;
import org.geotools.data.duckdb.DuckDBFilterToSQL;
import org.geotools.data.jdbc.FilterToSQL;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.BasicSQLDialect;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.InStream;
import org.locationtech.jts.io.InputStreamInStream;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKTWriter;

public class DuckDBDialect
extends BasicSQLDialect {
    private static final GeometryFactory GEOMETRY_FACTORY = new GeometryFactory();
    private boolean screenMapEnabled = true;
    private boolean simplifyEnabled = true;

    protected DuckDBDialect(JDBCDataStore dataStore) {
        super(dataStore);
    }

    public void setScreenMapEnabled(boolean screenMapEnabled) {
        this.screenMapEnabled = screenMapEnabled;
    }

    public void setSimplifyEnabled(boolean simplifyEnabled) {
        this.simplifyEnabled = simplifyEnabled;
    }

    public List<String> getDatabaseInitSql() {
        return List.of("install spatial", "load spatial");
    }

    public String getNameEscape() {
        return "\"";
    }

    public String escapeName(String name) {
        return this.getNameEscape() + name + this.getNameEscape();
    }

    public boolean includeTable(String schemaName, String tableName, Connection cx) throws SQLException {
        boolean systemTable = tableName.startsWith("pg_") || tableName.startsWith("sqlite_") || tableName.startsWith("information_schema");
        return !systemTable;
    }

    protected void addSupportedHints(Set<Hints.Key> hints) {
        if (this.simplifyEnabled) {
            hints.add(Hints.GEOMETRY_SIMPLIFICATION);
            hints.add(Hints.GEOMETRY_GENERALIZATION);
        }
        hints.add(Hints.FEATURE_2D);
        if (this.screenMapEnabled) {
            hints.add(Hints.SCREENMAP);
        }
    }

    public Class<?> getMapping(ResultSet columnMetaData, Connection cx) throws SQLException {
        super.getMapping(columnMetaData, cx);
        String typeName = columnMetaData.getString("TYPE_NAME");
        if ("GEOMETRY".equalsIgnoreCase(typeName)) {
            return Geometry.class;
        }
        return null;
    }

    public void registerSqlTypeToClassMappings(Map<Integer, Class<?>> mappings) {
        super.registerSqlTypeToClassMappings(mappings);
        mappings.put(2002, Struct.class);
    }

    public void registerClassToSqlMappings(Map<Class<?>, Integer> mappings) {
        super.registerClassToSqlMappings(mappings);
        mappings.put(Geometry.class, 1111);
        mappings.put(Point.class, 1111);
        mappings.put(LineString.class, 1111);
        mappings.put(Polygon.class, 1111);
        mappings.put(MultiPoint.class, 1111);
        mappings.put(MultiLineString.class, 1111);
        mappings.put(MultiPolygon.class, 1111);
        mappings.put(GeometryCollection.class, 1111);
        mappings.put(Struct.class, 2002);
    }

    public void encodePostColumnCreateTable(AttributeDescriptor att, StringBuffer sql) {
        Class binding;
        if (att instanceof GeometryDescriptor && this.isConcreteGeometry(binding = att.getType().getBinding())) {
            sql.append(" GEOMETRY");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGeometrySRID(String schemaName, String tableName, String columnName, Connection cx) throws SQLException {
        String sql = String.format("SELECT ST_SRID(%s) FROM %s WHERE %s IS NOT NULL LIMIT 1", this.escapeName(columnName), this.escapeName(tableName), this.escapeName(columnName));
        Statement st = cx.createStatement();
        try {
            ResultSet rs = st.executeQuery(sql);
            try {
                if (rs.next()) {
                    Integer n = rs.getInt(1);
                    return n;
                }
            }
            finally {
                this.dataStore.closeSafe(rs);
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.WARNING, "Failed to retrieve SRID for geometry column", e);
        }
        finally {
            this.dataStore.closeSafe(st);
        }
        return null;
    }

    public List<ReferencedEnvelope> getOptimizedBounds(String schema, SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        GeometryDescriptor geometryDescriptor = featureType.getGeometryDescriptor();
        if (null == geometryDescriptor) {
            return List.of();
        }
        return List.of(this.optimizedBounds(featureType, cx));
    }

    protected ReferencedEnvelope optimizedBounds(SimpleFeatureType featureType, Connection cx) throws SQLException, IOException {
        GeometryDescriptor geometryDescriptor = Objects.requireNonNull(featureType.getGeometryDescriptor());
        String tableName = featureType.getTypeName();
        String column = geometryDescriptor.getLocalName();
        String sql = String.format("SELECT ST_AsWKB(ST_Extent_Agg(%s)::GEOMETRY)::BLOB FROM %s", this.escapeName(column), this.escapeName(tableName));
        try (PreparedStatement ps = cx.prepareStatement(sql);){
            ReferencedEnvelope referencedEnvelope;
            block13: {
                ResultSet rs = ps.executeQuery();
                try {
                    if (!rs.next()) {
                        throw new RuntimeException("Could not compute optimized bounds, ST_Extent_Agg returned no record");
                    }
                    Blob blob = rs.getBlob(1);
                    Geometry fullBounds = this.parseWKB(blob);
                    referencedEnvelope = new ReferencedEnvelope(fullBounds.getEnvelopeInternal(), geometryDescriptor.getCoordinateReferenceSystem());
                    if (rs == null) break block13;
                }
                catch (Throwable throwable) {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                rs.close();
            }
            return referencedEnvelope;
        }
    }

    public void encodeGeometryEnvelope(String tableName, String geometryColumn, StringBuffer sql) {
        sql.append("ST_AsWKB(ST_Envelope(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append(")::GEOMETRY)::BLOB ");
    }

    public Envelope decodeGeometryEnvelope(ResultSet rs, int column, Connection cx) throws SQLException, IOException {
        Geometry geom = this.parseWKB(GEOMETRY_FACTORY, rs.getBlob(column));
        if (geom == null) {
            return new Envelope();
        }
        return geom.getEnvelopeInternal();
    }

    public void encodeGeometryColumn(GeometryDescriptor gatt, String prefix, int srid, Hints hints, StringBuffer sql) {
        this.encodeGeometryColumnInternal(gatt, prefix, hints, false, sql);
    }

    protected void encodeGeometryColumnInternal(GeometryDescriptor gatt, String prefix, Hints hints, boolean forceMulti, StringBuffer sql) {
        boolean force2D = hints != null && hints.containsKey((Object)Hints.FEATURE_2D) && Boolean.TRUE.equals(hints.get((Object)Hints.FEATURE_2D));
        String geometry = String.format("%s::GEOMETRY", this.encodeColumnName(prefix, gatt.getLocalName()));
        if (forceMulti) {
            geometry = String.format("ST_Multi(%s)", geometry);
        }
        if (force2D) {
            geometry = String.format("ST_Force2D(%s)", geometry);
        }
        String geomSql = String.format("ST_AsWKB(%s)::BLOB", geometry);
        sql.append(geomSql);
    }

    public String encodeColumnName(String prefix, String raw) {
        if (prefix != null) {
            return String.format("%s.%s", this.escapeName(prefix), this.escapeName(raw));
        }
        return this.escapeName(raw);
    }

    public void encodeGeometryColumnGeneralized(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        if (distance == null) {
            this.encodeGeometryColumn(gatt, prefix, srid, null, sql);
        }
        String geometryColumn = gatt.getLocalName();
        sql.append("ST_AsWKB(ST_SimplifyPreserveTopology(");
        this.encodeColumnName(null, geometryColumn, sql);
        sql.append("::GEOMETRY, " + distance + "))::BLOB");
    }

    public void encodeGeometryColumnSimplified(GeometryDescriptor gatt, String prefix, int srid, StringBuffer sql, Double distance) {
        if (this.simplifyEnabled && distance != null) {
            this.encodeGeometryColumnGeneralized(gatt, prefix, srid, sql, distance);
        } else {
            this.encodeGeometryColumn(gatt, prefix, srid, null, sql);
        }
    }

    public Geometry decodeGeometryValue(GeometryDescriptor descriptor, ResultSet rs, String column, GeometryFactory factory, Connection cx, Hints hints) throws IOException, SQLException {
        Blob blob = rs.getBlob(column);
        return this.parseWKB(factory, blob);
    }

    protected Geometry parseWKB(Blob blob) throws SQLException, IOException {
        return this.parseWKB(GEOMETRY_FACTORY, blob);
    }

    protected Geometry parseWKB(GeometryFactory factory, Blob blob) throws SQLException, IOException {
        if (blob == null) {
            return null;
        }
        try {
            InputStreamInStream inStream = new InputStreamInStream(blob.getBinaryStream());
            return new WKBReader(factory).read((InStream)inStream);
        }
        catch (ParseException e) {
            throw new IOException("Error parsing WKB geometry", e);
        }
    }

    public void encodeGeometryValue(Geometry value, int dimension, int srid, StringBuffer sql) throws IOException {
        if (value != null && !value.isEmpty()) {
            sql.append("ST_GeomFromText('");
            sql.append(new WKTWriter().write(value));
            sql.append("', ");
            sql.append(srid);
            sql.append(")");
        } else {
            sql.append("NULL");
        }
    }

    protected boolean isConcreteGeometry(Class<?> binding) {
        return Point.class.isAssignableFrom(binding) || LineString.class.isAssignableFrom(binding) || Polygon.class.isAssignableFrom(binding) || MultiPoint.class.isAssignableFrom(binding) || MultiLineString.class.isAssignableFrom(binding) || MultiPolygon.class.isAssignableFrom(binding);
    }

    public void encodePrimaryKey(String column, StringBuffer sql) {
        this.encodeColumnName(null, column, sql);
        sql.append(" INTEGER PRIMARY KEY");
    }

    public boolean isLimitOffsetSupported() {
        return true;
    }

    public void applyLimitOffset(StringBuffer sql, int limit, int offset) {
        if (limit >= 0 && limit < Integer.MAX_VALUE) {
            sql.append(" LIMIT ").append(limit);
            if (offset > 0) {
                sql.append(" OFFSET ").append(offset);
            }
        } else if (offset > 0) {
            sql.append(" OFFSET ").append(offset);
        }
    }

    public FilterToSQL createFilterToSQL() {
        return new DuckDBFilterToSQL();
    }
}

