/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.geotools.api.data.DataAccessFactory;
import org.geotools.api.util.InternationalString;
import org.geotools.util.SimpleInternationalString;

public class ParamBuilder {
    private final String key;
    private Class<?> type;
    private InternationalString description;
    private InternationalString title;
    private boolean required = false;
    private Object defaultValue = null;
    private Map<String, Object> metadata = new HashMap<String, Object>();
    private int minOccurs = 0;
    private int maxOccurs = 1;

    public ParamBuilder(String key) {
        this.key = Objects.requireNonNull(key, "Parameter key must not be null");
    }

    public ParamBuilder type(Class<?> type) {
        this.type = Objects.requireNonNull(type, "Parameter type must not be null");
        return this;
    }

    public ParamBuilder description(String description) {
        this.description = new SimpleInternationalString(description);
        return this;
    }

    public ParamBuilder description(InternationalString description) {
        this.description = description;
        return this;
    }

    public ParamBuilder title(String title) {
        this.title = new SimpleInternationalString(title);
        return this;
    }

    public ParamBuilder title(InternationalString title) {
        this.title = title;
        return this;
    }

    public ParamBuilder required(boolean required) {
        this.required = required;
        return this;
    }

    public ParamBuilder defaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ParamBuilder metadata(String key, Object value) {
        this.metadata.put(key, value);
        return this;
    }

    public ParamBuilder metadata(Map<String, Object> metadata) {
        this.metadata.clear();
        if (metadata != null) {
            this.metadata.putAll(metadata);
        }
        return this;
    }

    public ParamBuilder minOccurs(int minOccurs) {
        if (minOccurs < 0) {
            throw new IllegalArgumentException("minOccurs cannot be negative");
        }
        this.minOccurs = minOccurs;
        return this;
    }

    public ParamBuilder maxOccurs(int maxOccurs) {
        if (maxOccurs < this.minOccurs) {
            throw new IllegalArgumentException("maxOccurs cannot be less than minOccurs");
        }
        this.maxOccurs = maxOccurs;
        return this;
    }

    public ParamBuilder level(String level) {
        return this.metadata("level", level);
    }

    public ParamBuilder userLevel() {
        return this.level("user");
    }

    public ParamBuilder advancedLevel() {
        return this.level("advanced");
    }

    public ParamBuilder programLevel() {
        return this.level("program");
    }

    public DataAccessFactory.Param build() {
        if (this.type == null) {
            throw new IllegalStateException("Parameter type must be set");
        }
        if (this.title == null) {
            this.title = new SimpleInternationalString(this.key);
        }
        if (this.description == null) {
            this.description = this.title;
        }
        Map<String, Object> metadataCopy = Collections.unmodifiableMap(new HashMap<String, Object>(this.metadata));
        return new DataAccessFactory.Param(this.key, this.type, this.title, this.description, this.required, this.minOccurs, this.maxOccurs, this.defaultValue, metadataCopy);
    }
}

