/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.duckdb.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Properties;
import org.apache.commons.dbcp.DriverConnectionFactory;
import org.duckdb.DuckDBConnection;

class DuckdbConnectionFactory
extends DriverConnectionFactory {
    private DuckDBConnection sentinel;
    private List<String> databaseInitSqls;

    public DuckdbConnectionFactory(Driver driver, String connectUri, Properties props, List<String> databaseInitSqls) {
        super(driver, connectUri, props);
        this.databaseInitSqls = databaseInitSqls;
    }

    public Connection createConnection() throws SQLException {
        if (this.sentinel == null) {
            this.sentinel = (DuckDBConnection)super.createConnection();
            this.initDatabase(this.sentinel);
        }
        return this.sentinel.duplicate();
    }

    public void close() throws SQLException {
        if (this.sentinel != null) {
            try {
                this.sentinel.close();
            }
            finally {
                this.sentinel = null;
            }
        }
    }

    private void initDatabase(DuckDBConnection conn) throws SQLException {
        try (Statement stmt = conn.createStatement();){
            for (String sql : this.databaseInitSqls) {
                stmt.addBatch(sql);
            }
            stmt.executeBatch();
        }
    }
}

