/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.geoparquet;

import java.io.File;
import java.net.URI;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

class HivePartitionResolver {
    private static final Pattern INVALID_NC_CHARS_PATTERN = Pattern.compile("[^a-zA-Z0-9_.-]");
    private static final Pattern MULTIPLE_SEPARATORS_PATTERN = Pattern.compile("[_-]+");

    private HivePartitionResolver() {
    }

    static String toNCName(String input) {
        if (input == null || input.trim().isEmpty()) {
            return "_";
        }
        Object workingString = input.trim();
        workingString = INVALID_NC_CHARS_PATTERN.matcher((CharSequence)workingString).replaceAll("_");
        if (((String)(workingString = MULTIPLE_SEPARATORS_PATTERN.matcher((CharSequence)workingString).replaceAll("_"))).isEmpty() || ((String)workingString).equals("_")) {
            return "_";
        }
        char firstChar = ((String)workingString).charAt(0);
        boolean startsWithLetter = Character.isLetter(firstChar);
        if (!startsWithLetter && firstChar != '_') {
            workingString = "_" + (String)workingString;
        }
        if (((String)workingString).endsWith("_") && ((String)workingString).length() > 1) {
            workingString = ((String)workingString).substring(0, ((String)workingString).length() - 1);
        }
        return workingString;
    }

    public static Map<String, List<String>> getHivePartitionedFiles(Connection connection, URI uri, Integer maxDepth) throws SQLException {
        String targetUri = HivePartitionResolver.sanitizeURI(uri);
        List<String> files = HivePartitionResolver.listFiles(connection, targetUri);
        return HivePartitionResolver.buildPartitionMap(targetUri, files, maxDepth);
    }

    private static String sanitizeURI(URI uri) {
        Object finalPath;
        Optional<File> file = HivePartitionResolver.toFile(uri);
        if (file.isPresent()) {
            File fileOrDir = file.orElseThrow();
            finalPath = fileOrDir.getAbsolutePath();
            if (fileOrDir.isDirectory()) {
                finalPath = (String)finalPath + "/*";
            }
        } else {
            finalPath = uri.toASCIIString();
        }
        return finalPath;
    }

    private static Optional<File> toFile(URI uri) {
        if (StringUtils.isEmpty((CharSequence)uri.getScheme())) {
            uri = URI.create("file:" + uri);
        }
        if ("file".equals(uri.getScheme())) {
            File file = new File(uri).getAbsoluteFile();
            return Optional.of(file);
        }
        return Optional.empty();
    }

    public static List<String> listFiles(Connection connection, String uri) throws SQLException {
        ArrayList<String> files = new ArrayList<String>();
        try (Statement stmt = connection.createStatement();){
            String query = String.format("SELECT file FROM glob('%s')", uri);
            try (ResultSet rs = stmt.executeQuery(query);){
                while (rs.next()) {
                    files.add(rs.getString("file"));
                }
            }
        }
        return files;
    }

    static Map<String, List<String>> buildPartitionMap(String uri, List<String> files, Integer maxDepth) {
        HashMap<String, List<String>> partitionToFiles = new HashMap<String, List<String>>();
        for (String filePath : files) {
            String fullPartitionParts = HivePartitionResolver.extractPartitionPath(filePath);
            String partitionUri = fullPartitionParts.isEmpty() ? filePath : HivePartitionResolver.buildPartitionUri(filePath, fullPartitionParts, maxDepth);
            partitionToFiles.computeIfAbsent(partitionUri, k -> new ArrayList()).add(filePath);
        }
        return partitionToFiles;
    }

    private static String buildPartitionUri(String filePath, String fullPartitionParts, Integer maxDepth) {
        String partitionUri;
        int partitionLimit;
        String basePath = filePath.substring(0, filePath.indexOf(fullPartitionParts));
        if (basePath.endsWith("/")) {
            basePath = basePath.substring(0, basePath.length() - 1);
        }
        int partitionCount = HivePartitionResolver.partitionCount(filePath);
        int n = partitionLimit = maxDepth == null ? partitionCount : Math.min(partitionCount, maxDepth);
        if (partitionLimit == 0) {
            partitionUri = String.format("%s/**/*", basePath);
        } else {
            String limitedPartitionParts = HivePartitionResolver.extractPartitionPath(filePath, partitionLimit);
            String glob = partitionCount > partitionLimit ? "**/*" : "*";
            partitionUri = String.format("%s/%s/%s", basePath, limitedPartitionParts, glob);
        }
        if (filePath.contains("?")) {
            return partitionUri + filePath.substring(filePath.indexOf("?"), filePath.length());
        }
        return partitionUri;
    }

    public static String buildPartitionName(String partitionUri) {
        String part;
        boolean glob;
        Objects.requireNonNull(partitionUri);
        if (partitionUri.trim().isEmpty()) {
            throw new IllegalArgumentException("empty partition uri");
        }
        String partition = HivePartitionResolver.extractPartitionPath(partitionUri);
        if (!partition.isEmpty()) {
            return HivePartitionResolver.toNCName(partition);
        }
        List parts = Arrays.stream(partitionUri.split("/")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        String name = "_";
        Iterator iterator = parts.iterator();
        while (iterator.hasNext() && !(glob = (part = (String)iterator.next()).contains("*"))) {
            name = part;
        }
        if (name.endsWith(".parquet")) {
            name = name.substring(0, name.lastIndexOf(".parquet"));
        }
        return HivePartitionResolver.toNCName(name);
    }

    private static String extractPartitionPath(String fileUri) {
        return HivePartitionResolver.extractPartitionPath(fileUri, null);
    }

    static String extractPartitionPath(String fileUri, Integer maxDepth) {
        if (maxDepth != null && maxDepth < 0) {
            throw new IllegalArgumentException("maxDepth is negative: " + maxDepth);
        }
        if (fileUri.contains("?")) {
            fileUri = fileUri.substring(0, fileUri.indexOf("?"));
        }
        String[] parts = fileUri.split("/");
        ArrayList<String> partitionParts = new ArrayList<String>();
        for (String part : parts) {
            if (!part.contains("=")) continue;
            partitionParts.add(part);
        }
        int depth = maxDepth == null || maxDepth == 0 ? partitionParts.size() : Math.min(maxDepth, partitionParts.size());
        return String.join((CharSequence)"/", partitionParts.subList(0, depth));
    }

    public static int partitionCount(String fileUri) {
        return (int)Arrays.stream(fileUri.split("/")).filter(part -> part.contains("=")).count();
    }
}

