/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geopkg;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import org.geotools.jdbc.EnumMapping;
import org.geotools.util.Converters;

class JSONArrayIO {
    JsonFactory factory = new JsonFactory();

    JSONArrayIO() {
    }

    public <T> T[] parse(String json, Class<T> type, EnumMapping mapping) {
        ArrayList<Object> result = new ArrayList<Object>();
        try (JsonParser parser = this.factory.createParser(json);){
            JsonToken token = parser.nextToken();
            if (token.id() != 3) {
                throw new IllegalArgumentException("Not a JSON array: " + json);
            }
            while ((token = parser.nextToken()).id() != 4) {
                if (token.isScalarValue()) {
                    if (mapping != null) {
                        String value = mapping.fromKey(parser.getValueAsString());
                        result.add(value);
                        continue;
                    }
                    result.add(Converters.convert((Object)parser.getText(), type));
                    continue;
                }
                throw new IllegalArgumentException("Unexpected nested object found");
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Object array = Array.newInstance(type, result.size());
        for (int i = 0; i < result.size(); ++i) {
            Array.set(array, i, result.get(i));
        }
        Object[] ra = (Object[])array;
        return ra;
    }
}

