/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.graph.structure.basic;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.geotools.graph.structure.DirectedEdge;
import org.geotools.graph.structure.DirectedNode;
import org.geotools.graph.structure.Edge;
import org.geotools.graph.structure.Node;
import org.geotools.graph.structure.basic.BasicGraphable;

public class BasicDirectedNode
extends BasicGraphable
implements DirectedNode {
    private transient ArrayList<DirectedEdge> m_in = new ArrayList();
    private transient ArrayList<DirectedEdge> m_out = new ArrayList();

    @Override
    public void add(Edge e) {
        throw new UnsupportedOperationException("add(Edge)");
    }

    @Override
    public void addIn(DirectedEdge e) {
        this.m_in.add(e);
    }

    @Override
    public void addOut(DirectedEdge e) {
        this.m_out.add(e);
    }

    @Override
    public void remove(Edge e) {
        this.m_in.remove(e);
        this.m_out.remove(e);
    }

    @Override
    public void removeIn(DirectedEdge e) {
        this.m_in.remove(e);
    }

    @Override
    public void removeOut(DirectedEdge e) {
        this.m_out.remove(e);
    }

    @Override
    public Edge getEdge(Node other) {
        Edge e = this.getInEdge((DirectedNode)other);
        if (e != null) {
            return e;
        }
        return this.getOutEdge((DirectedNode)other);
    }

    @Override
    public Edge getInEdge(DirectedNode other) {
        for (DirectedEdge edge : this.m_in) {
            if (!edge.getInNode().equals(other) || !edge.getOutNode().equals(this)) continue;
            return edge;
        }
        return null;
    }

    @Override
    public Edge getOutEdge(DirectedNode other) {
        for (DirectedEdge edge : this.m_out) {
            if (!edge.getOutNode().equals(other) || !edge.getInNode().equals(this)) continue;
            return edge;
        }
        return null;
    }

    public List<DirectedEdge> getEdges() {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        edges.addAll(this.m_in);
        edges.addAll(this.m_out);
        return edges;
    }

    public List<DirectedEdge> getInEdges() {
        return this.m_in;
    }

    public List<DirectedEdge> getOutEdges() {
        return this.m_out;
    }

    public List<DirectedEdge> getEdges(Node other) {
        List<DirectedEdge> edges = this.getInEdges((DirectedNode)other);
        edges.addAll(this.getOutEdges((DirectedNode)other));
        return edges;
    }

    public List<DirectedEdge> getInEdges(DirectedNode other) {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (DirectedEdge edge : this.m_in) {
            if (!edge.getInNode().equals(other)) continue;
            edges.add(edge);
        }
        return edges;
    }

    public List<DirectedEdge> getOutEdges(DirectedNode other) {
        ArrayList<DirectedEdge> edges = new ArrayList<DirectedEdge>();
        for (DirectedEdge edge : this.m_out) {
            if (!edge.getOutNode().equals(other)) continue;
            edges.add(edge);
        }
        return edges;
    }

    @Override
    public int getDegree() {
        return this.m_in.size() + this.m_out.size();
    }

    @Override
    public int getInDegree() {
        return this.m_in.size();
    }

    @Override
    public int getOutDegree() {
        return this.m_out.size();
    }

    public Iterator<DirectedNode> getRelated() {
        ArrayList<DirectedNode> related = new ArrayList<DirectedNode>(this.m_out.size() + this.m_in.size());
        for (DirectedEdge e : this.m_in) {
            related.add(e.getInNode());
        }
        for (DirectedEdge e : this.m_out) {
            related.add(e.getOutNode());
        }
        return related.iterator();
    }

    public Iterator<DirectedNode> getInRelated() {
        ArrayList<DirectedNode> related = new ArrayList<DirectedNode>(this.m_in.size());
        for (DirectedEdge e : this.m_in) {
            related.add(e.getInNode());
        }
        return related.iterator();
    }

    public Iterator<DirectedNode> getOutRelated() {
        ArrayList<DirectedNode> related = new ArrayList<DirectedNode>(this.m_out.size());
        for (DirectedEdge e : this.m_out) {
            related.add(e.getOutNode());
        }
        return related.iterator();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.m_in = new ArrayList();
        this.m_out = new ArrayList();
    }
}

