/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterFactory;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.InvalidGridGeometryException;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.image.ImageWorker;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class JGrassUtilities {
    public static final String NORTH = "NORTH";
    public static final String SOUTH = "SOUTH";
    public static final String WEST = "WEST";
    public static final String EAST = "EAST";
    public static final String XRES = "XRES";
    public static final String YRES = "YRES";
    public static final String ROWS = "ROWS";
    public static final String COLS = "COLS";
    public static Interpolation interpolation = Interpolation.getInstance((int)0);

    public static boolean checkRasterMapConsistence(String mapsetPath, String mapname) {
        File file = null;
        File file2 = null;
        file = new File(mapsetPath + File.separator + "fcell" + File.separator + mapname);
        file2 = new File(mapsetPath + File.separator + "cell" + File.separator + mapname);
        if (!file.exists() && !file2.exists()) {
            return false;
        }
        file = new File(mapsetPath + File.separator + "cellhd" + File.separator + mapname);
        if (!file.exists()) {
            return false;
        }
        file = new File(mapsetPath + File.separator + "cell_misc" + File.separator + mapname);
        return file.exists();
    }

    public static BufferedImage ByteBufferImage(byte[] data, int width, int height) {
        int[] bandoffsets = new int[]{0, 1, 2, 3};
        DataBufferByte dbb = new DataBufferByte(data, data.length);
        WritableRaster wr = Raster.createInterleavedRaster(dbb, width, height, width * 4, 4, bandoffsets, null);
        int[] bitfield = new int[]{8, 8, 8, 8};
        ColorSpace cs = ColorSpace.getInstance(1000);
        ComponentColorModel cm = new ComponentColorModel(cs, bitfield, true, false, 3, 0);
        return new BufferedImage(cm, wr, false, null);
    }

    public static Envelope reprojectEnvelopeByEpsg(int srcEpsg, int destEpsg, Envelope srcEnvelope) throws FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = CRS.decode((String)("EPSG:" + srcEpsg));
        CoordinateReferenceSystem targetCRS = CRS.decode((String)("EPSG:" + destEpsg));
        MathTransform tr = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        return JTS.transform((Envelope)srcEnvelope, (MathTransform)tr);
    }

    public static JGrassRegion getRectangleAroundPoint(JGrassRegion activeRegion, double x, double y) {
        double minx = activeRegion.getRectangle().getBounds2D().getMinX();
        double ewres = activeRegion.getWEResolution();
        double snapx = minx + (double)Math.round((x - minx) / ewres) * ewres;
        double miny = activeRegion.getRectangle().getBounds2D().getMinY();
        double nsres = activeRegion.getNSResolution();
        double snapy = miny + (double)Math.round((y - miny) / nsres) * nsres;
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        if (x >= snapx) {
            xmin = snapx;
            xmax = xmin + ewres;
        } else {
            xmax = snapx;
            xmin = xmax - ewres;
        }
        if (y <= snapy) {
            ymax = snapy;
            ymin = ymax - nsres;
        } else {
            ymin = snapy;
            ymax = ymin + nsres;
        }
        return new JGrassRegion(xmin, xmax, ymin, ymax, 1, 1);
    }

    public static Coordinate rowColToCenterCoordinates(JGrassRegion active, int row, int col) {
        double north = active.getNorth();
        double west = active.getWest();
        double nsres = active.getNSResolution();
        double ewres = active.getWEResolution();
        double northing = north - (double)row * nsres - nsres / 2.0;
        double easting = west + (double)col * ewres + ewres / 2.0;
        return new Coordinate(easting, northing);
    }

    public static int[] coordinateToNearestRowCol(JGrassRegion active, Coordinate coord) {
        double easting = coord.x;
        double northing = coord.y;
        int[] rowcol = new int[2];
        if (easting > active.getEast() || easting < active.getWest() || northing > active.getNorth() || northing < active.getSouth()) {
            return null;
        }
        double minx = active.getWest();
        double ewres = active.getWEResolution();
        for (int i = 0; i < active.getCols(); ++i) {
            if (!(easting < (minx += ewres))) continue;
            rowcol[1] = i;
            break;
        }
        double maxy = active.getNorth();
        double nsres = active.getNSResolution();
        for (int i = 0; i < active.getRows(); ++i) {
            if (!(northing > (maxy -= nsres))) continue;
            rowcol[0] = i;
            break;
        }
        return rowcol;
    }

    public static String[] filesOfRasterMap(String mapsetPath, String mapname) {
        String[] filesOfRaster = new String[]{mapsetPath + File.separator + "fcell" + File.separator + mapname, mapsetPath + File.separator + "cell" + File.separator + mapname, mapsetPath + File.separator + "cats" + File.separator + mapname, mapsetPath + File.separator + "hist" + File.separator + mapname, mapsetPath + File.separator + "cellhd" + File.separator + mapname, mapsetPath + File.separator + "colr" + File.separator + mapname, mapsetPath + File.separator + "cell_misc" + File.separator + mapname, mapsetPath + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_format", mapsetPath + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_quant", mapsetPath + File.separator + "cell_misc" + File.separator + mapname + File.separator + "f_range", mapsetPath + File.separator + "cell_misc" + File.separator + mapname + File.separator + "null"};
        return filesOfRaster;
    }

    public static double[] rowColToNodeboundCoordinates(JGrassRegion active, int row, int col) {
        double anorth = active.getNorth();
        double awest = active.getWest();
        double nsres = active.getNSResolution();
        double ewres = active.getWEResolution();
        double[] nsew = new double[]{anorth - (double)row * nsres, anorth - (double)row * nsres - nsres, awest + (double)col * ewres + ewres, awest + (double)col * ewres};
        return nsew;
    }

    public static int factorial(int n) {
        int fact = 1;
        for (int i = 1; i <= n; ++i) {
            fact *= i;
        }
        return fact;
    }

    public static void makeColorRulesPersistent(File colrFile, List<String> rules, double[] minMax, int alpha) throws IOException {
        if (!colrFile.getParentFile().exists()) {
            colrFile.getParentFile().mkdir();
        }
        try (BufferedWriter bw = new BufferedWriter(new FileWriter(colrFile));){
            if (rules.size() == 0) {
                throw new IllegalArgumentException("The list of colorrules can't be empty.");
            }
            String header = "% " + minMax[0] + "   " + minMax[1] + "   " + alpha;
            bw.write(header + "\n");
            for (String r : rules) {
                bw.write(r + "\n");
            }
        }
    }

    public static int[] getTilesBasedOnFreeMemory(int rows, int cols) {
        long freeMemory = Runtime.getRuntime().freeMemory();
        int tileSizeY = 256;
        int tileSizeX = 256;
        if (freeMemory > 8L * (long)cols) {
            tileSizeX = cols;
            tileSizeY = (int)(freeMemory / 8L) / cols;
            if (tileSizeY > rows) {
                tileSizeY = rows;
            }
        }
        return new int[]{tileSizeX, tileSizeY};
    }

    public static JGrassRegion getJGrassRegionFromGridCoverage(GridCoverage2D gridCoverage2D) throws InvalidGridGeometryException, TransformException {
        Envelope2D env = gridCoverage2D.getEnvelope2D();
        GridEnvelope2D worldToGrid = gridCoverage2D.getGridGeometry().worldToGrid(env);
        double xRes = env.getWidth() / worldToGrid.getWidth();
        double yRes = env.getHeight() / worldToGrid.getHeight();
        JGrassRegion region = new JGrassRegion(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), xRes, yRes);
        return region;
    }

    public static RenderedImage scaleJAIImage(int requestedCols, int requestedRows, RenderedImage translatedImage, Interpolation interpolation) {
        if (interpolation == null) {
            interpolation = JGrassUtilities.interpolation;
        }
        ImageWorker worker = new ImageWorker(translatedImage);
        worker.scale((double)((float)requestedCols / (float)translatedImage.getWidth()), (double)((float)requestedRows / (float)translatedImage.getHeight()), 0.0, 0.0, interpolation);
        return worker.getRenderedOperation();
    }

    public static GridCoverage2D buildCoverage(String name, double[][] dataMatrix, double n, double s, double w, double e, CoordinateReferenceSystem crs, boolean matrixIsRowCol) {
        WritableRaster writableRaster = JGrassUtilities.createWritableRasterFromMatrix(dataMatrix, matrixIsRowCol);
        Envelope2D writeEnvelope = new Envelope2D(crs, w, s, e - w, n - s);
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory((Hints)GeoTools.getDefaultHints());
        GridCoverage2D coverage2D = factory.create((CharSequence)name, writableRaster, (org.opengis.geometry.Envelope)writeEnvelope);
        return coverage2D;
    }

    public static WritableRaster createWritableRasterFromMatrix(double[][] matrix, boolean matrixIsRowCol) {
        int height = matrix.length;
        int width = matrix[0].length;
        if (!matrixIsRowCol) {
            int tmp = height;
            height = width;
            width = tmp;
        }
        WritableRaster writableRaster = JGrassUtilities.createDoubleWritableRaster(width, height, null, null, null);
        WritableRandomIter disckRandomIter = RandomIterFactory.createWritable((WritableRaster)writableRaster, null);
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                if (matrixIsRowCol) {
                    disckRandomIter.setSample(x, y, 0, matrix[y][x]);
                    continue;
                }
                disckRandomIter.setSample(x, y, 0, matrix[x][y]);
            }
        }
        disckRandomIter.done();
        return writableRaster;
    }

    public static WritableRaster createDoubleWritableRaster(int width, int height, Class<?> dataClass, SampleModel sampleModel, Double value) {
        int dataType = 5;
        if (dataClass != null) {
            if (dataClass.isAssignableFrom(Integer.class)) {
                dataType = 3;
            } else if (dataClass.isAssignableFrom(Float.class)) {
                dataType = 4;
            } else if (dataClass.isAssignableFrom(Byte.class)) {
                dataType = 0;
            }
        }
        if (sampleModel == null) {
            sampleModel = new ComponentSampleModel(dataType, width, height, 1, width, new int[]{0});
        }
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)sampleModel, null);
        if (value != null) {
            double v = value;
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    raster.setSample(x, y, 0, v);
                }
            }
        }
        return raster;
    }

    public static boolean isGrass(String path) {
        File file = new File(path);
        File cellFolderFile = file.getParentFile();
        File mapsetFile = cellFolderFile.getParentFile();
        File windFile = new File(mapsetFile, "WIND");
        return cellFolderFile.getName().toLowerCase().equals("cell") && windFile.exists();
    }

    public static void printImage(GridCoverage2D coverage2D) {
        RenderedImage renderedImage = coverage2D.getRenderedImage();
        JGrassUtilities.printImage(renderedImage);
    }

    public static void printImage(RenderedImage renderedImage) {
        RectIter rectIter = RectIterFactory.create((RenderedImage)renderedImage, null);
        while (true) {
            double value = rectIter.getSampleDouble();
            System.out.print(value + " ");
            if (!rectIter.nextPixelDone()) continue;
            rectIter.startPixels();
            if (rectIter.nextLineDone()) break;
        }
    }
}

