/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.awt.Rectangle;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.coverage.grid.GridCoverage;
import org.geotools.api.coverage.grid.GridCoverageWriter;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.Position;
import org.geotools.api.parameter.GeneralParameterValue;
import org.geotools.api.parameter.ParameterValue;
import org.geotools.api.util.ProgressListener;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverageWriter;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.GrassBinaryImageWriter;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.format.GrassCoverageFormat;
import org.geotools.gce.grassraster.spi.GrassBinaryImageWriterSpi;
import org.geotools.geometry.GeneralBounds;
import org.geotools.geometry.jts.ReferencedEnvelope;

public class GrassCoverageWriter
extends AbstractGridCoverageWriter
implements GridCoverageWriter {
    private File output;
    private ProgressListener monitor = new DummyProgressListener();

    public GrassCoverageWriter(Object output) {
        if (!(output instanceof File)) {
            throw new IllegalArgumentException("Illegal input argument!");
        }
        this.output = (File)output;
    }

    public void setProgressListener(ProgressListener monitor) {
        this.monitor = monitor;
    }

    public void writeRaster(GridCoverage2D gridCoverage2D) throws IOException {
        try {
            ReferencedEnvelope env = gridCoverage2D.getEnvelope2D();
            GridEnvelope2D worldToGrid = gridCoverage2D.getGridGeometry().worldToGrid(env);
            double xRes = env.getWidth() / worldToGrid.getWidth();
            double yRes = env.getHeight() / worldToGrid.getHeight();
            JGrassRegion region = new JGrassRegion(env.getMinX(), env.getMaxX(), env.getMinY(), env.getMaxY(), xRes, yRes);
            GrassBinaryImageWriterSpi writerSpi = new GrassBinaryImageWriterSpi();
            GrassBinaryImageWriter writer = new GrassBinaryImageWriter(writerSpi, this.monitor);
            RenderedImage renderedImage = gridCoverage2D.getRenderedImage();
            writer.setOutput(this.output, region);
            writer.write(renderedImage);
            writer.dispose();
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
    }

    public void writeRaster(GridCoverage2D gridCoverage2D, GeneralParameterValue[] params) throws IOException {
        GeneralBounds requestedEnvelope = null;
        Rectangle dim = null;
        JGrassRegion writeRegion = null;
        if (params != null) {
            for (GeneralParameterValue generalParameterValue : params) {
                ParameterValue param = (ParameterValue)generalParameterValue;
                String name = param.getDescriptor().getName().getCode();
                if (!name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) continue;
                GridGeometry2D gg = (GridGeometry2D)param.getValue();
                requestedEnvelope = new GeneralBounds((Bounds)gg.getEnvelope2D());
                dim = gg.getGridRange2D().getBounds();
            }
            if (requestedEnvelope != null && dim != null) {
                Position lowerCorner = requestedEnvelope.getLowerCorner();
                double[] westSouth = lowerCorner.getCoordinate();
                Position upperCorner = requestedEnvelope.getUpperCorner();
                double[] eastNorth = upperCorner.getCoordinate();
                writeRegion = new JGrassRegion(westSouth[0], eastNorth[0], westSouth[1], eastNorth[1], dim.height, dim.width);
            }
        }
        if (writeRegion == null) {
            throw new IOException("Unable to define writing region.");
        }
        GrassBinaryImageWriterSpi writerSpi = new GrassBinaryImageWriterSpi();
        GrassBinaryImageWriter writer = new GrassBinaryImageWriter(writerSpi, this.monitor);
        RenderedImage renderedImage = gridCoverage2D.getRenderedImage();
        writer.setOutput(this.output, writeRegion);
        writer.write(renderedImage);
        writer.dispose();
    }

    public Format getFormat() {
        return new GrassCoverageFormat();
    }

    public void write(GridCoverage coverage, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        if (coverage instanceof GridCoverage2D) {
            GridCoverage2D gridCoverage = (GridCoverage2D)coverage;
            if (parameters == null) {
                this.writeRaster(gridCoverage);
            } else {
                this.writeRaster(gridCoverage, parameters);
            }
        } else {
            throw new IllegalArgumentException("Coverage not a GridCoverage2D");
        }
    }
}

