/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.grassraster;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.IIOImage;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import org.geotools.api.util.ProgressListener;
import org.geotools.gce.grassraster.DummyProgressListener;
import org.geotools.gce.grassraster.JGrassMapEnvironment;
import org.geotools.gce.grassraster.JGrassRegion;
import org.geotools.gce.grassraster.core.GrassBinaryRasterWriteHandler;
import org.geotools.gce.grassraster.spi.GrassBinaryImageWriterSpi;

public class GrassBinaryImageWriter
extends ImageWriter {
    private boolean hasListeners = false;
    private GrassBinaryRasterWriteHandler rasterWriter = null;
    private double noDataValue = Double.NaN;
    private JGrassRegion writeRegion;
    private ProgressListener monitor = new DummyProgressListener();

    public GrassBinaryImageWriter(GrassBinaryImageWriterSpi originatingProvider, ProgressListener monitor) {
        super(originatingProvider);
        if (monitor != null) {
            this.monitor = monitor;
        }
    }

    public void setOutput(Object output, JGrassRegion writeRegion) {
        this.writeRegion = writeRegion;
        this.setOutput(output);
    }

    @Override
    public void setOutput(Object output) {
        if (output instanceof File) {
            File outFile = (File)output;
            JGrassMapEnvironment tmp = new JGrassMapEnvironment(outFile);
            this.rasterWriter = new GrassBinaryRasterWriteHandler(tmp.getMAPSET(), tmp.getMapName(), this.monitor);
            try {
                if (this.writeRegion == null) {
                    this.writeRegion = this.rasterWriter.getWriteRegion();
                }
                this.rasterWriter.setWriteRegion(this.writeRegion);
            }
            catch (IOException e) {
                throw new IllegalArgumentException("The supplied input isn't a GRASS raster map path!");
            }
        } else {
            throw new IllegalArgumentException("Input is not decodable!");
        }
    }

    @Override
    public void write(IIOMetadata streamMetadata, IIOImage image, ImageWriteParam param) throws IOException {
        boolean bl = this.hasListeners = this.progressListeners != null && !this.progressListeners.isEmpty();
        if (this.hasListeners) {
            this.clearAbortRequest();
            this.processImageStarted(0);
        }
        RenderedImage renderedImage = image.getRenderedImage();
        this.noDataValue = this.rasterWriter.getNoData();
        this.writeRegion.setCols(renderedImage.getWidth());
        this.writeRegion.setRows(renderedImage.getHeight());
        int nColumns = this.writeRegion.getCols();
        int nRows = this.writeRegion.getRows();
        double west = this.writeRegion.getWest();
        double south = this.writeRegion.getSouth();
        double cellsizeX = this.writeRegion.getWEResolution();
        double cellsizeY = this.writeRegion.getNSResolution();
        this.rasterWriter.writeRaster(renderedImage, nColumns, nRows, west, south, cellsizeX, cellsizeY, this.noDataValue);
        if (this.hasListeners) {
            if (this.rasterWriter.isAborting()) {
                this.processWriteAborted();
            } else {
                this.processImageComplete();
            }
        }
    }

    @Override
    public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier its, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertStreamMetadata(IIOMetadata md, ImageWriteParam param) {
        return null;
    }

    @Override
    public IIOMetadata convertImageMetadata(IIOMetadata md, ImageTypeSpecifier its, ImageWriteParam param) {
        return md;
    }

    @Override
    public void dispose() {
        try {
            this.rasterWriter.close();
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.INFO, "", e);
        }
        super.dispose();
    }

    @Override
    public synchronized void abort() {
        if (this.rasterWriter != null) {
            this.rasterWriter.abort();
        }
    }

    @Override
    public synchronized boolean abortRequested() {
        return this.rasterWriter.isAborting();
    }

    @Override
    public void reset() {
        super.reset();
        this.rasterWriter = null;
    }
}

