/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.graticule;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import org.geotools.api.data.Query;
import org.geotools.api.data.SimpleFeatureReader;
import org.geotools.api.data.SimpleFeatureSource;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.data.DataUtilities;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.graticule.GraticuleFeatureSource;
import org.geotools.data.graticule.gridsupport.LineFeatureBuilder;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.ortholine.LineOrientation;
import org.geotools.grid.ortholine.OrthoLineBuilder;
import org.geotools.grid.ortholine.OrthoLineDef;

public class GraticuleFeatureReader
implements SimpleFeatureReader {
    private final List<Double> steps;
    private SimpleFeatureSource currentGrid;
    private SimpleFeatureIterator delegate;
    SimpleFeatureType schema;
    Query query;
    int level = 0;

    public GraticuleFeatureReader(GraticuleFeatureSource fs, Query query) throws IOException {
        this.query = query;
        this.steps = fs.getSteps();
        this.schema = fs.getSchema();
        this.currentGrid = this.buildGrid(fs.getBounds());
        this.delegate = this.currentGrid.getFeatures(query).features();
    }

    public SimpleFeatureType getFeatureType() {
        return this.schema;
    }

    public SimpleFeatureIterator getDelegate() {
        return this.delegate;
    }

    public SimpleFeature next() throws IllegalArgumentException, NoSuchElementException {
        SimpleFeature next = (SimpleFeature)this.delegate.next();
        return next;
    }

    public boolean hasNext() throws IOException {
        return this.delegate.hasNext();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private SimpleFeatureSource buildGrid(ReferencedEnvelope box) {
        ArrayList<SimpleFeature> lines = new ArrayList<SimpleFeature>();
        for (int i = 0; i < this.steps.size(); ++i) {
            double step = this.steps.get(i);
            ArrayList<OrthoLineDef> vertLines = new ArrayList<OrthoLineDef>();
            vertLines.add(new OrthoLineDef(LineOrientation.VERTICAL, i, step));
            ArrayList<OrthoLineDef> horLines = new ArrayList<OrthoLineDef>();
            horLines.add(new OrthoLineDef(LineOrientation.HORIZONTAL, i, step));
            OrthoLineBuilder lineBuilder = new OrthoLineBuilder(box);
            LineFeatureBuilder gridBuilder = new LineFeatureBuilder(this.schema);
            ListFeatureCollection fc = new ListFeatureCollection(this.schema);
            lineBuilder.buildGrid(vertLines, (GridFeatureBuilder)gridBuilder, -1.0, fc);
            lines.addAll(this.updatePosition(fc));
            fc.clear();
            lineBuilder.buildGrid(horLines, (GridFeatureBuilder)gridBuilder, -1.0, fc);
            lines.addAll(this.updatePosition(fc));
        }
        return DataUtilities.source((FeatureCollection)new ListFeatureCollection(this.schema, lines));
    }

    private List<SimpleFeature> updatePosition(ListFeatureCollection fc) {
        List list = DataUtilities.list((FeatureCollection)fc);
        int i = 0;
        for (SimpleFeature f : list) {
            String position = "mid";
            if (i == 0) {
                position = "start";
            } else if (i == list.size() - 1) {
                position = "end";
            }
            f.setAttribute("sequence", (Object)position);
            ++i;
        }
        return list;
    }
}

