/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.graticule;

import java.io.IOException;
import java.util.List;
import org.geotools.api.data.FeatureReader;
import org.geotools.api.data.Query;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.filter.Filter;
import org.geotools.data.graticule.GraticuleFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.locationtech.jts.geom.LineString;

public class GraticuleFeatureSource
extends ContentFeatureSource {
    private final List<Double> steps;
    private final ReferencedEnvelope bounds;

    public GraticuleFeatureSource(ContentEntry entry, List<Double> steps, ReferencedEnvelope bounds) {
        super(entry, Query.ALL);
        this.steps = steps;
        this.bounds = bounds;
    }

    List<Double> getSteps() {
        return this.steps;
    }

    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (query.getFilter() != Filter.INCLUDE) {
            return null;
        }
        return this.bounds;
    }

    protected int getCountInternal(Query query) throws IOException {
        return -1;
    }

    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        return new GraticuleFeatureReader(this, query);
    }

    protected SimpleFeatureType buildFeatureType() throws IOException {
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.setName(this.getEntry().getName());
        tb.add("id", Integer.class);
        tb.add("element", LineString.class, this.bounds.getCoordinateReferenceSystem());
        tb.setDefaultGeometry("element");
        tb.setCRS(this.bounds.getCoordinateReferenceSystem());
        tb.add("level", Integer.class);
        tb.add("label", String.class);
        tb.add("value", Double.class);
        tb.add("horizontal", Boolean.class);
        tb.add("sequence", String.class);
        SimpleFeatureType type = tb.buildFeatureType();
        return type;
    }
}

