/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.graticule.gridsupport;

import java.text.Format;
import java.util.Map;
import org.geotools.api.feature.simple.SimpleFeatureType;
import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.api.referencing.crs.ProjectedCRS;
import org.geotools.api.referencing.cs.CoordinateSystem;
import org.geotools.grid.GridElement;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.ortholine.LineOrientation;
import org.geotools.grid.ortholine.OrthoLine;
import org.geotools.referencing.CoordinateFormat;
import org.locationtech.jts.geom.Coordinate;

public class LineFeatureBuilder
extends GridFeatureBuilder {
    public static final String DEFAULT_TYPE_NAME = "linegrid";
    public static final String ID_ATTRIBUTE_NAME = "id";
    public static final String LEVEL_ATTRIBUTE_NAME = "level";
    public static final String VALUE_ATTRIBUTE_NAME = "value";
    public static final String VALUE_LABEL_NAME = "label";
    public static final String HORIZONTAL = "horizontal";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String ANCHOR_X = "anchorX";
    public static final String ANCHOR_Y = "anchorY";
    public static final String OFFSET_X = "offsetX";
    public static final String OFFSET_Y = "offsetY";
    public static final String SEQUENCE = "sequence";
    public static final String SEQUENCE_START = "start";
    public static final String SEQUENCE_MID = "mid";
    public static final String SEQUENCE_END = "end";
    private boolean projected;
    protected int id;
    private final CoordinateFormat formatter = new CoordinateFormat();
    private final Format xFormat;
    private final Format yFormat;
    private final String xUnit;
    private final String yUnit;

    public LineFeatureBuilder(SimpleFeatureType type) {
        super(type);
        this.formatter.setNumberPattern("##0.00");
        this.formatter.setAnglePattern("DD.dd");
        this.formatter.setCoordinateReferenceSystem(type.getCoordinateReferenceSystem());
        this.xFormat = this.formatter.getFormat(0);
        this.yFormat = this.formatter.getFormat(1);
        CoordinateReferenceSystem coordinateSystem = type.getCoordinateReferenceSystem();
        this.projected = coordinateSystem instanceof ProjectedCRS;
        CoordinateSystem coordinateSystem1 = coordinateSystem.getCoordinateSystem();
        if (coordinateSystem1.getAxis(0).getUnit().getSymbol() != null) {
            this.xUnit = coordinateSystem1.getAxis(0).getUnit().getSymbol();
            this.yUnit = coordinateSystem1.getAxis(1).getUnit().getSymbol();
        } else if (coordinateSystem1.getAxis(0).getUnit().toString().equalsIgnoreCase("deg")) {
            this.xUnit = "\u00b0";
            this.yUnit = "\u00b0";
        } else {
            this.xUnit = coordinateSystem1.getAxis(0).getUnit().toString();
            this.yUnit = coordinateSystem1.getAxis(1).getUnit().toString();
        }
    }

    public void setAttributes(GridElement el, Map<String, Object> attributes) {
        Boolean horizontal;
        Object label;
        Double value;
        if (el instanceof OrthoLine) {
            OrthoLine orthoLine = (OrthoLine)el;
            attributes.put(ID_ATTRIBUTE_NAME, ++this.id);
            attributes.put(LEVEL_ATTRIBUTE_NAME, orthoLine.getLevel());
            Coordinate v0 = orthoLine.getVertices()[0];
            value = null;
            label = "";
            if (orthoLine.getOrientation() == LineOrientation.HORIZONTAL) {
                value = v0.y;
                label = this.yFormat.format(v0.y) + this.yUnit;
                if (!this.projected) {
                    label = this.yFormat.format(Math.abs(v0.y)) + this.yUnit;
                    if (v0.y < 0.0) {
                        label = (String)label + "S";
                    } else if (v0.y > 0.0) {
                        label = (String)label + "N";
                    }
                }
                horizontal = true;
            } else {
                value = v0.x;
                label = this.xFormat.format(v0.x) + this.xUnit;
                if (!this.projected) {
                    label = this.xFormat.format(Math.abs(v0.x)) + this.xUnit;
                    if (v0.x < 0.0) {
                        label = (String)label + "W";
                    } else if (v0.x > 0.0) {
                        label = (String)label + "E";
                    }
                }
                horizontal = false;
            }
        } else {
            throw new IllegalArgumentException("Expected an instance of OrthoLine");
        }
        attributes.put(VALUE_ATTRIBUTE_NAME, value);
        attributes.put(VALUE_LABEL_NAME, label);
        attributes.put(HORIZONTAL, horizontal);
    }
}

