/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverage.io.grib;

import java.io.File;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.io.netcdf.NetCDFFormat;
import org.geotools.imageio.netcdf.utilities.NetCDFUtilities;
import org.geotools.parameter.DefaultParameterDescriptor;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.filter.Filter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;

public class GRIBFormat
extends NetCDFFormat {
    public static final ParameterDescriptor<Filter> FILTER = new DefaultParameterDescriptor("Filter", Filter.class, null, null);
    private static final Logger LOGGER = Logging.getLogger(GRIBFormat.class);

    public GRIBFormat() {
        this.setInfo();
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "GRIB");
        info.put("description", "GRIB store plugin");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", "1.0");
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, TIME, ELEVATION, FILTER}));
        this.writeParameters = null;
    }

    public boolean accepts(Object source, Hints hints) {
        File file = null;
        if (source instanceof URL) {
            file = URLs.urlToFile((URL)((URL)source));
        } else if (source instanceof File) {
            file = (File)source;
        }
        if (file != null) {
            boolean gribExtension;
            if (file.isDirectory()) {
                return false;
            }
            String fileName = file.getName();
            boolean bl = gribExtension = NetCDFUtilities.isGribAvailable() && (fileName.contains("grb") || fileName.contains("grib"));
            if (fileName.endsWith("ncml") || gribExtension) {
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest("File is accepted: " + fileName);
                }
                return true;
            }
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Object is not accepted: " + String.valueOf(source));
        }
        return false;
    }
}

