/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.ortholine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.GridFeatureBuilder;
import org.geotools.grid.ortholine.LineOrientation;
import org.geotools.grid.ortholine.OrthoLine;
import org.geotools.grid.ortholine.OrthoLineDef;

public class OrthoLineBuilder {
    private static final double TOL = 1.0E-8;
    private final ReferencedEnvelope gridBounds;
    private boolean hasVerticals;
    private boolean hasHorizontals;
    private boolean densify;
    private SimpleFeatureBuilder featureBuilder;

    public OrthoLineBuilder(ReferencedEnvelope gridBounds) {
        this.gridBounds = gridBounds;
    }

    public void buildGrid(Collection<OrthoLineDef> lineDefs, GridFeatureBuilder lineFeatureBuilder, double vertexSpacing, ListFeatureCollection fc) {
        this.init(lineDefs, lineFeatureBuilder, vertexSpacing);
        ArrayList<OrthoLineDef> horizontal = new ArrayList<OrthoLineDef>();
        ArrayList<OrthoLineDef> vertical = new ArrayList<OrthoLineDef>();
        for (OrthoLineDef lineDef : lineDefs) {
            switch (lineDef.getOrientation()) {
                case HORIZONTAL: {
                    horizontal.add(lineDef);
                    break;
                }
                case VERTICAL: {
                    vertical.add(lineDef);
                }
            }
        }
        this.doBuildLineFeatures(horizontal, LineOrientation.HORIZONTAL, lineFeatureBuilder, this.densify, vertexSpacing, fc);
        this.doBuildLineFeatures(vertical, LineOrientation.VERTICAL, lineFeatureBuilder, this.densify, vertexSpacing, fc);
    }

    private void doBuildLineFeatures(List<OrthoLineDef> lineDefs, LineOrientation orientation, GridFeatureBuilder lineFeatureBuilder, boolean densify, double vertexSpacing, ListFeatureCollection fc) {
        int NDEFS = lineDefs.size();
        if (NDEFS > 0) {
            double maxOrdinate;
            double minOrdinate;
            if (orientation == LineOrientation.HORIZONTAL) {
                minOrdinate = this.gridBounds.getMinY();
                maxOrdinate = this.gridBounds.getMaxY();
            } else {
                minOrdinate = this.gridBounds.getMinX();
                maxOrdinate = this.gridBounds.getMaxX();
            }
            double[] pos = new double[NDEFS];
            boolean[] active = new boolean[NDEFS];
            boolean[] atCurPos = new boolean[NDEFS];
            boolean[] generate = new boolean[NDEFS];
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            String geomPropName = lineFeatureBuilder.getType().getGeometryDescriptor().getLocalName();
            for (int i = 0; i < NDEFS; ++i) {
                pos[i] = minOrdinate;
                active[i] = true;
            }
            int numActive = NDEFS;
            while (numActive > 0) {
                int i;
                double curPos = maxOrdinate;
                for (i = 0; i < NDEFS; ++i) {
                    if (!active[i] || !(pos[i] < curPos - 1.0E-8)) continue;
                    curPos = pos[i];
                }
                for (i = 0; i < NDEFS; ++i) {
                    atCurPos[i] = active[i] && Math.abs(pos[i] - curPos) < 1.0E-8;
                }
                System.arraycopy(atCurPos, 0, generate, 0, NDEFS);
                block4: for (i = 0; i < NDEFS - 1; ++i) {
                    if (generate[i] && atCurPos[i]) {
                        for (int j = i + 1; j < NDEFS; ++j) {
                            if (!generate[j] || !atCurPos[j]) continue;
                            if (lineDefs.get(i).getLevel() >= lineDefs.get(j).getLevel()) {
                                generate[j] = false;
                                continue;
                            }
                            generate[i] = false;
                            continue block4;
                        }
                        continue;
                    }
                    generate[i] = false;
                }
                for (i = 0; i < NDEFS; ++i) {
                    OrthoLine element;
                    if (!generate[i] || !lineFeatureBuilder.getCreateFeature(element = new OrthoLine(this.gridBounds, orientation, pos[i], lineDefs.get(i).getLevel()))) continue;
                    lineFeatureBuilder.setAttributes(element, attributes);
                    if (densify) {
                        this.featureBuilder.set(geomPropName, (Object)element.toDenseGeometry(vertexSpacing));
                    } else {
                        this.featureBuilder.set(geomPropName, (Object)element.toGeometry());
                    }
                    for (String propName : attributes.keySet()) {
                        this.featureBuilder.set(propName, attributes.get(propName));
                    }
                    String featureID = lineFeatureBuilder.getFeatureID(element);
                    SimpleFeature feature = this.featureBuilder.buildFeature(featureID);
                    fc.add(feature);
                }
                for (i = 0; i < NDEFS; ++i) {
                    if (!atCurPos[i]) continue;
                    int n = i;
                    pos[n] = pos[n] + lineDefs.get(i).getSpacing();
                    if (!(pos[i] > maxOrdinate + 1.0E-8)) continue;
                    active[i] = false;
                    --numActive;
                }
            }
        }
    }

    private boolean isValidDenseVertexSpacing(double v) {
        double minDim = this.hasVerticals ? (this.hasHorizontals ? Math.min(this.gridBounds.getWidth(), this.gridBounds.getHeight()) : this.gridBounds.getHeight()) : this.gridBounds.getWidth();
        return v > 0.0 && v < minDim / 2.0;
    }

    private void init(Collection<OrthoLineDef> controls, GridFeatureBuilder lineFeatureBuilder, double vertexSpacing) {
        if (this.gridBounds == null || this.gridBounds.isEmpty()) {
            throw new IllegalArgumentException("gridBounds must not be null or empty");
        }
        if (controls == null || controls.isEmpty()) {
            throw new IllegalArgumentException("required one or more line parameters");
        }
        for (OrthoLineDef param : controls) {
            if (param.getOrientation() == LineOrientation.HORIZONTAL) {
                this.hasHorizontals = true;
                continue;
            }
            if (param.getOrientation() == LineOrientation.VERTICAL) {
                this.hasVerticals = true;
                continue;
            }
            throw new IllegalArgumentException("Only horizontal and vertical lines are supported");
        }
        this.densify = this.isValidDenseVertexSpacing(vertexSpacing);
        this.featureBuilder = new SimpleFeatureBuilder(lineFeatureBuilder.getType());
    }
}

