/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.grid.oval;

import org.geotools.api.referencing.crs.CoordinateReferenceSystem;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.grid.oval.Oval;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.util.GeometricShapeFactory;

public class OvalImpl
implements Oval {
    private static final GeometryFactory geomFactory = JTSFactoryFinder.getGeometryFactory(null);
    private final ReferencedEnvelope envelope;

    public OvalImpl(double minX, double minY, double width, double height, CoordinateReferenceSystem crs) {
        if (width <= 0.0 || height <= 0.0) {
            throw new IllegalArgumentException("width and height must both be positive");
        }
        this.envelope = new ReferencedEnvelope(minX, minX + width, minY, minY + height, crs);
    }

    @Override
    public double getArea() {
        return this.envelope.getArea();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return new ReferencedEnvelope(this.envelope);
    }

    @Override
    public Coordinate getCenter() {
        return this.envelope.centre();
    }

    @Override
    public Coordinate[] getVertices() {
        Coordinate[] vertices = new Coordinate[]{new Coordinate(this.envelope.getMinX(), this.envelope.getMinY()), new Coordinate(this.envelope.getMinX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMaxY()), new Coordinate(this.envelope.getMaxX(), this.envelope.getMinY())};
        return vertices;
    }

    @Override
    public Geometry toGeometry() {
        GeometricShapeFactory geometryShapeFactory = new GeometricShapeFactory(geomFactory);
        geometryShapeFactory.setEnvelope((Envelope)this.envelope);
        geometryShapeFactory.setNumPoints(100);
        Polygon geometry = geometryShapeFactory.createEllipse();
        return geometry;
    }

    @Override
    public Geometry toDenseGeometry(double maxSpacing) {
        return Densifier.densify((Geometry)this.toGeometry(), (double)maxSpacing);
    }
}

