/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.StringTokenizer;
import org.geotools.util.URLs;

final class GT30Stats {
    private int minimum;
    private int maximum;
    private double average;
    private double stddev;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GT30Stats(URL statsURL) throws IOException {
        File stats = URLs.urlToFile((URL)statsURL);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(stats));
            String line = reader.readLine();
            if (line == null) {
                throw new IllegalArgumentException("Invalid empty stats file at " + statsURL);
            }
            StringTokenizer stok = new StringTokenizer(line, " ");
            Integer.parseInt(stok.nextToken());
            this.minimum = Integer.parseInt(stok.nextToken());
            this.maximum = Integer.parseInt(stok.nextToken());
            this.average = Double.parseDouble(stok.nextToken());
            this.stddev = Double.parseDouble(stok.nextToken());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public void writeTo(OutputStream out) {
        if (out == null) {
            return;
        }
        PrintWriter writer = new PrintWriter(out);
        writer.println(1);
        writer.print(this.minimum);
        writer.println(this.maximum);
        writer.print(this.average);
        writer.println(this.stddev);
        writer.flush();
        writer.close();
    }

    int getMin() {
        return this.minimum;
    }

    void setMin(int min) {
        this.minimum = min;
    }

    int getMax() {
        return this.maximum;
    }

    void setMax(int max) {
        this.maximum = max;
    }

    double getAverage() {
        return this.average;
    }

    void setAverage(double avg) {
        this.average = avg;
    }

    double getStdDev() {
        return this.stddev;
    }

    void setStdDev(double sd) {
        this.stddev = sd;
    }
}

