/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.media.jai.CRIFImpl;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.RegistryElementDescriptor;
import javax.media.jai.iterator.RectIter;
import javax.media.jai.iterator.RectIterFactory;
import javax.media.jai.iterator.WritableRectIter;
import org.geotools.coverage.grid.AbstractGridCoverage;
import org.geotools.image.TransfertRectIter;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Loggings;

public final class NoDataReplacerOpImage
extends PointOpImage {
    public static final String OPERATION_NAME = "org.geotools.gce.gtopo30.NoDataReplacer";
    private double EPS;
    private Number oldNoData;
    private int newNoData;
    private boolean oldNoDataIsNaN;

    private NoDataReplacerOpImage(RenderedImage image, Number oldNoData, Short newNoData, Double EPS, RenderingHints hints) {
        super(image, NoDataReplacerOpImage.getRightLayout(image), (Map)hints, false);
        this.EPS = EPS;
        this.oldNoData = oldNoData;
        this.oldNoDataIsNaN = Double.isNaN(oldNoData.doubleValue());
        this.newNoData = newNoData.intValue();
        this.permitInPlaceOperation();
    }

    private static ImageLayout getRightLayout(RenderedImage image) {
        SampleModel sm = image.getSampleModel();
        int dataType = 2;
        if (sm.getDataType() == 2) {
            return new ImageLayout(image);
        }
        ColorModel cm = image.getColorModel();
        if (sm instanceof ComponentSampleModel) {
            ComponentColorModel newCm = new ComponentColorModel(cm.getColorSpace(), false, false, cm.getTransparency(), 2);
            ComponentSampleModelJAI newSm = new ComponentSampleModelJAI(2, sm.getWidth(), sm.getHeight(), ((ComponentSampleModel)sm).getPixelStride(), ((ComponentSampleModel)sm).getScanlineStride(), ((ComponentSampleModel)sm).getBankIndices(), ((ComponentSampleModel)sm).getBandOffsets());
            ImageLayout layout = ImageUtilities.getImageLayout((RenderedImage)image);
            layout.setColorModel((ColorModel)newCm);
            layout.setSampleModel((SampleModel)newSm);
            return layout;
        }
        return null;
    }

    protected void computeRect(PlanarImage[] sources, WritableRaster dest, Rectangle destRect) {
        PlanarImage source = sources[0];
        WritableRectIter iterator = RectIterFactory.createWritable((WritableRaster)dest, (Rectangle)destRect);
        iterator = TransfertRectIter.create((RectIter)RectIterFactory.create((RenderedImage)source, (Rectangle)destRect), (WritableRectIter)iterator);
        this.formatRect(iterator);
    }

    private void formatRect(WritableRectIter iterator) {
        double actualValue = 0.0;
        iterator.startLines();
        if (!iterator.finishedLines()) {
            do {
                iterator.startPixels();
                if (iterator.finishedPixels()) continue;
                do {
                    actualValue = iterator.getSampleDouble();
                    if (!this.oldNoDataIsNaN) continue;
                    if (Double.isNaN(actualValue)) {
                        iterator.setSample(this.newNoData);
                        continue;
                    }
                    if (Math.abs(this.oldNoData.doubleValue() - actualValue) <= this.EPS) {
                        iterator.setSample(this.newNoData);
                        continue;
                    }
                    iterator.setSample(actualValue);
                } while (!iterator.nextPixelDone());
            } while (!iterator.nextLineDone());
        }
    }

    public static void register(JAI jai) {
        OperationRegistry registry = jai.getOperationRegistry();
        try {
            registry.registerDescriptor((RegistryElementDescriptor)new NoDataReplacerDescriptor());
            registry.registerFactory("rendered", OPERATION_NAME, "gce.geotools.org", (Object)new NoDataReplacerCRIF());
        }
        catch (IllegalArgumentException exception) {
            LogRecord record = Loggings.format((Level)Level.SEVERE, (int)10, (Object)OPERATION_NAME);
            record.setSourceClassName("GridSampleDimension");
            record.setSourceMethodName("<classinit>");
            record.setThrown(exception);
            AbstractGridCoverage.LOGGER.log(record);
        }
    }

    private static final class NoDataReplacerCRIF
    extends CRIFImpl {
        private NoDataReplacerCRIF() {
        }

        public RenderedImage create(ParameterBlock param, RenderingHints hints) {
            RenderedImage source = (RenderedImage)param.getSource(0);
            Number oldNoData = (Number)param.getObjectParameter(0);
            Short newNoData = (Short)param.getObjectParameter(1);
            Double EPS = (Double)param.getObjectParameter(2);
            return new NoDataReplacerOpImage(source, oldNoData, newNoData, EPS, hints);
        }
    }

    private static final class NoDataReplacerDescriptor
    extends OperationDescriptorImpl {
        private static final long serialVersionUID = 1L;

        public NoDataReplacerDescriptor() {
            super((String[][])new String[][]{{"GlobalName", NoDataReplacerOpImage.OPERATION_NAME}, {"LocalName", NoDataReplacerOpImage.OPERATION_NAME}, {"Vendor", "Geotools 2"}, {"Description", "Nodata replacement and layout adjustment."}, {"DocURL", "http://www.geotools.org/"}, {"Version", "1.0"}}, new String[]{"rendered"}, 1, new String[]{"oldNoData", "newNoData", "EPS"}, new Class[]{Number.class, Short.class, Double.class}, new Object[]{Double.NaN, (short)-9999, 1.0E-5}, null);
        }

        protected boolean validateParameters(String modeName, ParameterBlock param, StringBuffer message) {
            return super.validateParameters(modeName, param, message);
        }
    }
}

