/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http.commons;

import java.awt.RenderingHints;
import org.geotools.http.HTTPClient;
import org.geotools.http.HTTPClientFinder;
import org.geotools.http.HTTPConnectionPooling;
import org.geotools.http.commons.MultithreadedHttpClient;
import org.geotools.http.commons.MultithreadedHttpClientFactory;
import org.geotools.util.factory.Hints;
import org.junit.Assert;
import org.junit.Test;

public class HTTPClientFinderTest {
    @Test
    public void testConnectionPooling() throws Exception {
        int CONN_POOL = 4;
        Hints.putSystemDefault((RenderingHints.Key)Hints.HTTP_CLIENT_FACTORY, MultithreadedHttpClientFactory.class);
        try {
            HTTPClient client = HTTPClientFinder.createClient();
            Assert.assertTrue((boolean)(client instanceof HTTPConnectionPooling));
            ((HTTPConnectionPooling)client).setMaxConnections(4);
            Assert.assertEquals((long)4L, (long)((HTTPConnectionPooling)client).getMaxConnections());
            Assert.assertTrue((boolean)(client instanceof MultithreadedHttpClient));
            ((HTTPConnectionPooling)client).close();
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.HTTP_CLIENT_FACTORY);
        }
    }

    @Test
    public void testLogging() throws Exception {
        int CONN_POOL = 3;
        Hints.putSystemDefault((RenderingHints.Key)Hints.HTTP_CLIENT_FACTORY, MultithreadedHttpClientFactory.class);
        try {
            HTTPClient client = HTTPClientFinder.createClient((Hints)new Hints((RenderingHints.Key)Hints.HTTP_LOGGING, (Object)"True"));
            Assert.assertTrue((boolean)(client instanceof HTTPConnectionPooling));
            ((HTTPConnectionPooling)client).setMaxConnections(3);
            Assert.assertEquals((long)3L, (long)((HTTPConnectionPooling)client).getMaxConnections());
            Assert.assertTrue((boolean)(client instanceof MultithreadedHttpClientFactory.LoggingConnectionPoolingHTTPClient));
            ((HTTPConnectionPooling)client).close();
        }
        finally {
            Hints.removeSystemDefault((RenderingHints.Key)Hints.HTTP_CLIENT_FACTORY);
        }
    }

    @Test
    public void testBehaviors() throws Exception {
        HTTPClient client = HTTPClientFinder.createClient((Class[])new Class[]{HTTPConnectionPooling.class});
        Assert.assertTrue((boolean)(client instanceof HTTPConnectionPooling));
    }
}

