/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http.commons;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.matching.ContainsPattern;
import com.github.tomakehurst.wiremock.matching.StringValuePattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.apache.http.HttpException;
import org.geotools.http.HTTPResponse;
import org.geotools.http.commons.MultithreadedHttpClient;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import wiremock.org.apache.commons.io.IOUtils;

public class MultithreadedHttpClientTest {
    private static final String SYS_PROP_KEY_NONPROXYHOSTS = "http.nonProxyHosts";
    private static final String SYS_PROP_KEY_HOST = "http.proxyHost";
    private static final String SYS_PROP_KEY_PORT = "http.proxyPort";
    private String[] sysPropOriginalValue = new String[3];
    @ClassRule
    public static WireMockClassRule classRule = new WireMockClassRule((Options)WireMockConfiguration.options().dynamicPort());
    @ClassRule
    public static WireMockClassRule classProxyRule = new WireMockClassRule((Options)WireMockConfiguration.options().dynamicPort());
    @Rule
    public WireMockClassRule service = classRule;
    @Rule
    public WireMockClassRule proxyService = classProxyRule;

    @Test
    public void testGetWithoutNonProxyHost() throws MalformedURLException, IOException {
        URL proxy = new URL("http://localhost:" + this.proxyService.port());
        System.setProperty(SYS_PROP_KEY_HOST, proxy.getHost());
        System.setProperty(SYS_PROP_KEY_PORT, Integer.toString(proxy.getPort()));
        this.proxyService.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/fred")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        try (MultithreadedHttpClient sut = new MultithreadedHttpClient();){
            sut.get(new URL("http://geotools.org/fred"));
        }
        this.proxyService.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/fred")));
    }

    @Test
    public void testWithBasicAuthProvided() throws Exception {
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/testba")).withBasicAuth("flup", "top").willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<ok>authorized</ok>")));
        try (MultithreadedHttpClient toTest = new MultithreadedHttpClient();){
            toTest.setUser("flup");
            toTest.setPassword("top");
            toTest.get(new URL("http://localhost:" + this.service.port() + "/testba"));
        }
    }

    @Test
    public void testGetWithMatchingNonProxyHost() throws HttpException, IOException {
        URL proxy = new URL("http://localhost:" + this.proxyService.port());
        System.setProperty(SYS_PROP_KEY_HOST, proxy.getHost());
        System.setProperty(SYS_PROP_KEY_PORT, Integer.toString(this.proxyService.port()));
        System.setProperty(SYS_PROP_KEY_NONPROXYHOSTS, "localhost");
        URL testURL = new URL("http://localhost:" + this.service.port() + "/test");
        this.proxyService.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/fred")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        try (MultithreadedHttpClient sut = new MultithreadedHttpClient();){
            sut.get(new URL("http://geotools.org/fred"));
        }
        this.proxyService.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/fred")));
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        System.setProperty(SYS_PROP_KEY_NONPROXYHOSTS, "\"localhost|www.geotools.org\"");
        sut = new MultithreadedHttpClient();
        try {
            sut.get(testURL);
        }
        finally {
            sut.close();
        }
        this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")));
    }

    @Before
    public void setupSaveOriginalSysPropValue() {
        this.sysPropOriginalValue[0] = System.getProperty(SYS_PROP_KEY_NONPROXYHOSTS);
        this.sysPropOriginalValue[1] = System.getProperty(SYS_PROP_KEY_HOST);
        this.sysPropOriginalValue[2] = System.getProperty(SYS_PROP_KEY_PORT);
    }

    @After
    public void setupRestoreOriginalSysPropValue() {
        if (this.sysPropOriginalValue[0] == null) {
            System.clearProperty(SYS_PROP_KEY_NONPROXYHOSTS);
        } else {
            System.setProperty(SYS_PROP_KEY_NONPROXYHOSTS, this.sysPropOriginalValue[0]);
        }
        if (this.sysPropOriginalValue[1] == null) {
            System.clearProperty(SYS_PROP_KEY_HOST);
        } else {
            System.setProperty(SYS_PROP_KEY_HOST, this.sysPropOriginalValue[1]);
        }
        if (this.sysPropOriginalValue[2] == null) {
            System.clearProperty(SYS_PROP_KEY_PORT);
        } else {
            System.setProperty(SYS_PROP_KEY_PORT, this.sysPropOriginalValue[2]);
        }
    }

    @Test
    public void testBasicHeaderGET() throws IOException {
        String longPassword = "0123456789".repeat(10);
        String userName = "user";
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(WireMock.aResponse().withStatus(401).withHeader("WWW-Authenticate", new String[]{"Basic realm=\"User Visible Realm\""})));
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test")).withBasicAuth(userName, longPassword).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        try (MultithreadedHttpClient client = new MultithreadedHttpClient();){
            client.setUser(userName);
            client.setPassword(longPassword);
            client.get(new URL("http://localhost:" + this.service.port() + "/test"));
            String encodedCredentials = "dXNlcjowMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5";
            this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)("Basic " + encodedCredentials))));
        }
    }

    @Test
    public void testBasicHeaderPOST() throws IOException {
        String longPassword = "0123456789".repeat(10);
        String userName = "user";
        this.service.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(WireMock.aResponse().withStatus(401).withHeader("WWW-Authenticate", new String[]{"Basic realm=\"User Visible Realm\""})));
        this.service.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/test")).withBasicAuth(userName, longPassword).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        try (MultithreadedHttpClient client = new MultithreadedHttpClient();){
            client.setUser(userName);
            client.setPassword(longPassword);
            String body = "<data>A body string</data>";
            client.post(new URL("http://localhost:" + this.service.port() + "/test"), (InputStream)new ByteArrayInputStream(body.getBytes()), "text/xml");
            String encodedCredentials = "dXNlcjowMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5";
            this.service.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)("Basic " + encodedCredentials))));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserAgentInRequests() throws Exception {
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/agent")).withHeader("User-Agent", (StringValuePattern)new ContainsPattern("GeoTools")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"plain/text"}).withBody("OK")));
        HTTPResponse response = null;
        try (MultithreadedHttpClient client = new MultithreadedHttpClient();){
            response = client.get(new URL("http://localhost:" + this.service.port() + "/agent"));
            String result = IOUtils.toString((InputStream)response.getResponseStream(), (String)response.getResponseCharset());
            Assert.assertEquals((Object)"OK", (Object)result);
            this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/agent")));
        }
        finally {
            if (response != null) {
                response.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestsWithAdditionalHeaders() throws IOException {
        MultithreadedHttpClient client;
        URL url = new URL("http://localhost:" + this.service.port() + "/test");
        UrlPattern urlPattern = WireMock.urlEqualTo((String)"/test");
        ResponseDefinitionBuilder responseBldr = WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>");
        ByteArrayInputStream postBody = new ByteArrayInputStream("GeoTools".getBytes());
        HTTPResponse response = null;
        this.service.stubFor(WireMock.get((UrlPattern)urlPattern).willReturn(responseBldr));
        String headerValue = "Bearer " + System.currentTimeMillis();
        try {
            client = new MultithreadedHttpClient();
            try {
                response = client.get(url, Map.of("Authorization", headerValue));
                this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)headerValue)));
            }
            finally {
                client.close();
            }
        }
        finally {
            if (response != null) {
                response.dispose();
                response = null;
            }
        }
        this.service.stubFor(WireMock.post((UrlPattern)urlPattern).willReturn(responseBldr));
        headerValue = "Bearer " + System.currentTimeMillis() + "1";
        try {
            client = new MultithreadedHttpClient();
            try {
                response = client.post(url, (InputStream)postBody, "text/plain", Map.of("Authorization", headerValue));
                this.service.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)headerValue)));
            }
            finally {
                client.close();
            }
        }
        finally {
            if (response != null) {
                response.dispose();
            }
        }
    }
}

