/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import org.geotools.http.HTTPResponse;
import org.geotools.http.MockHttpResponse;
import org.junit.Assert;
import org.junit.Test;

public class MockHttpResponseTest {
    private static final byte[] THE_RESPONSE = new byte[]{1, 2, 3};

    @Test
    public void testReplay() throws IOException {
        byte[] payload = new byte[THE_RESPONSE.length];
        MockHttpResponse response = new MockHttpResponse(THE_RESPONSE, "application/octet-stream", new String[0]);
        this.readAndCompare(payload, response);
        this.readAndCompare(payload, response);
    }

    private void readAndCompare(byte[] payload, HTTPResponse response) throws IOException {
        try (InputStream is = response.getResponseStream();){
            is.read(payload);
            Assert.assertArrayEquals((byte[])THE_RESPONSE, (byte[])payload);
        }
    }
}

