/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.geotools.http.AbstractHttpClient;
import org.geotools.http.HTTPResponse;

public class MockHttpClient
extends AbstractHttpClient {
    Map<Request, HTTPResponse> expectedRequests = new LinkedHashMap<Request, HTTPResponse>();

    public void expectGet(URL url, HTTPResponse response) {
        this.expectedRequests.put(new Request(url), response);
    }

    public void expectPost(URL url, HTTPResponse response) {
        this.expectedRequests.put(new Request(url, false), response);
    }

    public void expectPost(URL url, String postContent, String postContentType, HTTPResponse response) {
        this.expectPost(url, postContent.getBytes(StandardCharsets.UTF_8), postContentType, response);
    }

    public void expectPost(URL url, byte[] postContent, String postContentType, HTTPResponse response) {
        this.expectedRequests.put(new Request(url, postContent, postContentType), response);
    }

    public HTTPResponse post(URL url, InputStream postContent, String postContentType) throws IOException {
        return this.getResponse(new Request(url, this.toByteArray(postContent), postContentType));
    }

    private byte[] toByteArray(InputStream is) throws IOException {
        byte[] result;
        try (InputStream inputStream = is;){
            result = new byte[is.available()];
            is.read(result);
        }
        return result;
    }

    private HTTPResponse getResponse(Request request) {
        HTTPResponse response = this.expectedRequests.get(request);
        if (response == null) {
            StringBuilder sb = new StringBuilder("Unexpected request \n" + request + "\nNo response is bound to it. Bound urls are: ");
            for (Request r : this.expectedRequests.keySet()) {
                sb.append("\n").append(r);
            }
            throw new IllegalArgumentException(sb.toString());
        }
        return response;
    }

    public HTTPResponse get(URL url) throws IOException {
        return this.getResponse(new Request(url));
    }

    private static class Request {
        String path;
        Map<String, Object> kvp;
        String contentType;
        boolean isGetRequest;
        byte[] postContent;

        public Request(URL url, boolean isGetRequest) {
            this.path = url.getProtocol() + "://" + url.getHost() + url.getPath();
            Map<String, String> parsedQueryString = this.parseQueryString(url);
            this.kvp = new TreeMap<String, Object>();
            for (Map.Entry<String, String> entry : parsedQueryString.entrySet()) {
                this.kvp.put(entry.getKey().toUpperCase(), entry.getValue());
            }
            this.isGetRequest = isGetRequest;
        }

        public Request(URL url) {
            this(url, true);
        }

        public Map<String, String> parseQueryString(URL url) {
            if (url.getQuery() == null || url.getQuery().isEmpty()) {
                return Collections.emptyMap();
            }
            return Arrays.stream(url.getQuery().split("&")).map(s -> s.split("=")).collect(Collectors.toMap(o -> Request.decode(o[0]), o -> ((String[])o).length == 2 ? Request.decode(o[1]) : ""));
        }

        private static String decode(String encoded) {
            try {
                return encoded == null ? null : URLDecoder.decode(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }

        public Request(URL url, byte[] postContent, String postContentType) {
            this(url, false);
            this.postContent = postContent;
            this.contentType = postContentType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.contentType == null ? 0 : this.contentType.hashCode());
            result = 31 * result + (this.isGetRequest ? 1231 : 1237);
            result = 31 * result + (this.kvp == null ? 0 : this.kvp.hashCode());
            result = 31 * result + (this.path == null ? 0 : this.path.hashCode());
            result = 31 * result + Arrays.hashCode(this.postContent);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            if (this.contentType == null ? other.contentType != null : !this.contentType.equals(other.contentType)) {
                return false;
            }
            if (this.isGetRequest != other.isGetRequest) {
                return false;
            }
            if (this.kvp == null ? other.kvp != null : !this.kvp.equals(other.kvp)) {
                return false;
            }
            if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
                return false;
            }
            return Arrays.equals(this.postContent, other.postContent);
        }

        public String toString() {
            if (this.isGetRequest) {
                return "GET " + this.path + ", " + this.kvp;
            }
            return "POST " + this.path + ", " + this.kvp + (String)(this.contentType == null ? "" : ", content type " + this.contentType + ", content [" + new String(this.postContent, StandardCharsets.UTF_8)) + "]";
        }
    }
}

