/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.http.ssl.SSLContextBuilder;
import com.github.tomakehurst.wiremock.http.ssl.TrustSelfSignedStrategy;
import com.github.tomakehurst.wiremock.http.ssl.TrustStrategy;
import com.github.tomakehurst.wiremock.junit.WireMockClassRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.geotools.http.HTTPResponse;
import org.geotools.http.SimpleHttpClient;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import wiremock.org.apache.commons.io.IOUtils;

public class SimpleHttpClientTest {
    @ClassRule
    public static WireMockClassRule classRule = new WireMockClassRule((Options)WireMockConfiguration.options().dynamicPort().dynamicHttpsPort());
    @Rule
    public WireMockClassRule service = classRule;

    @Test
    public void testBasicHeader() throws IOException {
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>")));
        String longPassword = "0123456789".repeat(10);
        String userName = "user";
        SimpleHttpClient client = new SimpleHttpClient();
        client.setUser(userName);
        client.setPassword(longPassword);
        client.get(new URL("http://localhost:" + this.service.port() + "/test"));
        String encodedCredentials = "dXNlcjowMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5MDEyMzQ1Njc4OTAxMjM0NTY3ODkwMTIzNDU2Nzg5";
        this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)("Basic " + encodedCredentials))));
    }

    @Test
    public void testRequestsWithAdditionalHeaders() throws IOException {
        URL url = new URL("http://localhost:" + this.service.port() + "/test");
        UrlPattern urlPattern = WireMock.urlEqualTo((String)"/test");
        ResponseDefinitionBuilder response = WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>");
        ByteArrayInputStream postBody = new ByteArrayInputStream("GeoTools".getBytes());
        SimpleHttpClient client = new SimpleHttpClient();
        this.service.stubFor(WireMock.get((UrlPattern)urlPattern).willReturn(response));
        String headerValue = "Bearer " + System.currentTimeMillis();
        client.get(url, Map.of("Authorization", headerValue));
        this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)headerValue)));
        this.service.stubFor(WireMock.post((UrlPattern)urlPattern).willReturn(response));
        headerValue = "Bearer " + System.currentTimeMillis() + "1";
        client.post(url, (InputStream)postBody, "text/plain", Map.of("Authorization", headerValue));
        this.service.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test")).withHeader("Authorization", WireMock.equalTo((String)headerValue)));
    }

    @Test
    public void testRequestsWithExtraParams() throws IOException {
        SimpleHttpClient client = new SimpleHttpClient();
        Map<String, String> testExtraParams = Map.of("key1", "123", "key2", "value2", "key%3", "value/3");
        URL urlWithoutExtraParams = new URL("http://localhost:" + this.service.port() + "/test?key2=duplicate");
        UrlPattern urlPattern = WireMock.urlMatching((String)"/test[\\w?&=%]*");
        ResponseDefinitionBuilder response = WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody("<response>Some content</response>");
        this.service.stubFor(WireMock.get((UrlPattern)urlPattern).willReturn(response));
        this.service.stubFor(WireMock.post((UrlPattern)urlPattern).willReturn(response));
        client.setExtraParams(testExtraParams);
        client.get(urlWithoutExtraParams);
        this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlMatching((String)"/test[\\w?&=%]*")).withQueryParam("key1", WireMock.equalTo((String)"123")).withQueryParam("key2", WireMock.equalTo((String)"value2")).withQueryParam("key2", WireMock.equalTo((String)"duplicate")).withQueryParam("key%3", WireMock.equalTo((String)"value/3")));
        ByteArrayInputStream postBody = new ByteArrayInputStream("GeoTools".getBytes());
        client.post(urlWithoutExtraParams, (InputStream)postBody, "text/plain");
        this.service.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlMatching((String)"/test[\\w?&=%]*")).withQueryParam("key1", WireMock.equalTo((String)"123")).withQueryParam("key2", WireMock.equalTo((String)"value2")).withQueryParam("key2", WireMock.equalTo((String)"duplicate")).withQueryParam("key%3", WireMock.equalTo((String)"value/3")));
    }

    @Test
    public void testRedirect() throws IOException {
        this.trustSelfSignedCertificate();
        String expectedContent = "<response>Redirected content</response>";
        String redirectURL = "https://localhost:" + this.service.httpsPort() + "/test-redirected";
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test-redirect")).willReturn(WireMock.aResponse().withStatus(301).withHeader("Location", new String[]{redirectURL})));
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test-redirected")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"text/xml"}).withBody(expectedContent)));
        SimpleHttpClient client = new SimpleHttpClient();
        HTTPResponse response = client.get(new URL("http://localhost:" + this.service.port() + "/test-redirect"));
        String actualContent = IOUtils.toString((InputStream)response.getResponseStream(), (Charset)StandardCharsets.UTF_8);
        Assert.assertEquals((Object)actualContent, (Object)expectedContent);
        this.service.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test-redirected")));
    }

    @Test
    public void testMaxRedirectionLimit() throws IOException {
        this.trustSelfSignedCertificate();
        String httpRedirectURL = "http://localhost:" + this.service.port() + "/test-redirect-loop-http";
        String httpsRedirectURL = "https://localhost:" + this.service.httpsPort() + "/test-redirect-loop-https";
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test-redirect-loop-http")).willReturn(WireMock.aResponse().withStatus(301).withHeader("Location", new String[]{httpsRedirectURL})));
        this.service.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/test-redirect-loop-https")).willReturn(WireMock.aResponse().withStatus(301).withHeader("Location", new String[]{httpRedirectURL})));
        SimpleHttpClient client = new SimpleHttpClient();
        client.get(new URL(httpRedirectURL));
        this.service.verify(9, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test-redirect-loop-http")));
        this.service.verify(8, WireMock.getRequestedFor((UrlPattern)WireMock.urlEqualTo((String)"/test-redirect-loop-https")));
    }

    private void trustSelfSignedCertificate() {
        SSLContext ctx;
        try {
            SSLContextBuilder sslContextBuilder = SSLContextBuilder.create().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy());
            ctx = sslContextBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        if (ctx != null) {
            SSLContext.setDefault(ctx);
        }
    }
}

