/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.http.AbstractHttpClient;
import org.geotools.http.DefaultHttpResponse;
import org.geotools.http.HTTPProxy;
import org.geotools.http.HTTPResponse;
import org.geotools.util.Base64;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.logging.Logging;

public class SimpleHttpClient
extends AbstractHttpClient
implements HTTPProxy {
    private static final Logger LOGGER = Logging.getLogger(SimpleHttpClient.class);
    private static final int DEFAULT_TIMEOUT = 30;
    private static final int MAX_FOLLOW_REDIRECT = Integer.getInteger("org.geotools.http.simpleHttpClient.maxFollowRedirect", 16);

    public SimpleHttpClient() {
        this.connectTimeout = 30;
        this.readTimeout = 30;
    }

    @Override
    public HTTPResponse get(URL url) throws IOException {
        return this.get(url, null);
    }

    @Override
    public HTTPResponse get(URL url, Map<String, String> headers) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "URL is " + url);
        }
        if (this.isFile(url)) {
            return this.createFileResponse(url);
        }
        URLConnection connection = this.get(url, headers, 0);
        if (connection == null) {
            return null;
        }
        return new DefaultHttpResponse(connection);
    }

    @Override
    public HTTPResponse post(URL url, InputStream content, String contentType) throws IOException {
        return this.post(url, content, contentType, null);
    }

    @Override
    public HTTPResponse post(URL url, InputStream postContent, String postContentType, Map<String, String> headers) throws IOException {
        URLConnection connection;
        headers = headers == null ? new HashMap<String, String>(1) : new HashMap<String, String>(headers);
        if (postContentType != null) {
            headers.put("Content-type", postContentType);
        }
        if ((connection = this.openConnection(url, headers)) instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("POST");
        }
        connection.setDoOutput(true);
        connection.connect();
        try (OutputStream outputStream = connection.getOutputStream();){
            int count;
            byte[] buff = new byte[512];
            while ((count = postContent.read(buff)) > -1) {
                outputStream.write(buff, 0, count);
            }
            outputStream.flush();
        }
        return new DefaultHttpResponse(connection);
    }

    private URLConnection get(URL url, Map<String, String> headers, int redirectionCount) throws IOException {
        HttpURLConnection httpConnection;
        URLConnection connection = this.openConnection(url, headers);
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).setRequestMethod("GET");
        }
        connection.connect();
        if (connection instanceof HttpURLConnection && SimpleHttpClient.hasRedirect((httpConnection = (HttpURLConnection)connection).getResponseCode())) {
            return this.followRedirect(httpConnection, headers, redirectionCount);
        }
        return connection;
    }

    private URLConnection openConnection(URL finalURL, Map<String, String> headers) throws IOException {
        Map<String, String> extraParams = this.getExtraParams();
        if (!extraParams.isEmpty()) {
            finalURL = SimpleHttpClient.appendURL(finalURL, extraParams);
        }
        URLConnection connection = finalURL.openConnection();
        boolean http = connection instanceof HttpURLConnection;
        headers = headers == null ? new HashMap<String, String>() : new HashMap<String, String>(headers);
        if (http && this.tryGzip) {
            headers.put("Accept-Encoding", "gzip");
        }
        if (http && this.getConnectTimeout() > 0) {
            connection.setConnectTimeout(1000 * this.getConnectTimeout());
        }
        if (http && this.getReadTimeout() > 0) {
            connection.setReadTimeout(1000 * this.getReadTimeout());
        }
        String username = this.getUser();
        String password = this.getPassword();
        if (http && username != null && password != null) {
            String userpassword = username + ":" + password;
            String encodedAuthorization = Base64.encodeBytes((byte[])userpassword.getBytes(StandardCharsets.UTF_8), (int)8);
            headers.put("Authorization", "Basic " + encodedAuthorization);
        }
        headers.put("User-Agent", "GeoTools HTTPClient (" + GeoTools.getVersion() + ")");
        for (Map.Entry<String, String> headerNameValue : headers.entrySet()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Setting header " + headerNameValue.getKey() + " = " + headerNameValue.getValue());
            }
            connection.setRequestProperty(headerNameValue.getKey(), headerNameValue.getValue());
        }
        return connection;
    }

    private static boolean hasRedirect(int responseCode) {
        return responseCode == 303 || responseCode == 301 || responseCode == 302;
    }

    private URLConnection followRedirect(HttpURLConnection connection, Map<String, String> headers, int redirectionCount) throws IOException {
        String redirect = connection.getHeaderField("Location");
        if (redirect == null) {
            LOGGER.warning("Tried to follow redirect but no url was provided in Location header");
        } else if (redirectionCount < MAX_FOLLOW_REDIRECT) {
            ++redirectionCount;
            try {
                URL redirectURL = new URI(redirect).toURL();
                LOGGER.fine("Following redirect to " + redirect);
                return this.get(redirectURL, headers, redirectionCount);
            }
            catch (MalformedURLException | URISyntaxException uri) {
                LOGGER.warning("Tried to follow redirect but invalid url was provided in Location header: " + redirect);
            }
        } else {
            LOGGER.warning("Max number of follow redirect attempts (" + MAX_FOLLOW_REDIRECT + ") reached. Returning null");
        }
        return null;
    }
}

