/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.jp2mrsid;

import it.geosolutions.imageio.plugins.jp2mrsid.JP2GDALMrSidImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.jp2mrsid.JP2MrSIDReader;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class JP2MrSIDFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(JP2MrSIDFormat.class);
    private static BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("JP2K (MrSID) Coverage Format", "JP2MrSID");

    public JP2MrSIDFormat() {
        super((ImageReaderSpi)new JP2GDALMrSidImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new JP2KFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public JP2MrSIDReader getReader(Object source, Hints hints) {
        try {
            return new JP2MrSIDReader(source, hints);
        }
        catch (DataSourceException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

