/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.coverageio.gdal.envihdr;

import it.geosolutions.imageio.plugins.envihdr.ENVIHdrImageReaderSpi;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.api.coverage.grid.Format;
import org.geotools.api.data.DataSourceException;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.coverageio.gdal.BaseGDALGridFormat;
import org.geotools.coverageio.gdal.envihdr.EnviHdrReader;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

public final class EnviHdrFormat
extends BaseGDALGridFormat
implements Format {
    private static final Logger LOGGER = Logging.getLogger(EnviHdrFormat.class);
    private static BaseGDALGridFormat.InfoWrapper INFO = new BaseGDALGridFormat.InfoWrapper("ENVIHdr Coverage Format", "ENVIHdr");

    public EnviHdrFormat() {
        super((ImageReaderSpi)new ENVIHdrImageReaderSpi());
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Creating a new EnviHdrFormat.");
        }
        this.setInfo();
    }

    @Override
    protected void setInfo() {
        this.setInfo(INFO);
    }

    public EnviHdrReader getReader(Object source, Hints hints) {
        try {
            return new EnviHdrReader(source, hints);
        }
        catch (DataSourceException | MismatchedDimensionException e) {
            RuntimeException re = new RuntimeException();
            re.initCause(e);
            throw re;
        }
    }
}

