/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import javax.media.jai.Interpolation;
import javax.media.jai.RenderedOp;
import junit.framework.JUnit4TestAdapter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.OrFileFilter;
import org.apache.commons.io.filefilter.RegexFileFilter;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleRemovalPolicy;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.coverage.util.FeatureUtilities;
import org.geotools.data.CloseableIterator;
import org.geotools.data.DataStoreFinder;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FileGroupProvider;
import org.geotools.data.FileResourceInfo;
import org.geotools.data.Query;
import org.geotools.data.ResourceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.visitor.UniqueVisitor;
import org.geotools.filter.text.ecql.ECQL;
import org.geotools.gce.imagemosaic.ConvertersHack;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicFormat;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.TestUtils;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.CachingDataStoreGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.LockingGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.QueryCacheGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.test.ImageAssert;
import org.geotools.jdbc.JDBCDataStore;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.test.TestData;
import org.geotools.util.DateRange;
import org.geotools.util.NumberRange;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.PropertyIsEqualTo;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.expression.Expression;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.referencing.operation.TransformException;

public class ImageMosaicReaderTest {
    private static final FilterFactory2 FF = FeatureUtilities.DEFAULT_FILTER_FACTORY;
    private static final double DELTA = 1.0E-4;
    private static final Logger LOGGER = Logger.getLogger(ImageMosaicReaderTest.class.toString());
    private static final int BASE_METADATANAMES_LENGTH = 13;
    private static final int ADDITIONAL_DOMAINS_METADATANAMES_LENGTH = 19;
    private URL rgbURL;
    private URL mixedSampleModelURL;
    private URL coverageBandsURL;
    private URL coverageBands2URL;
    private URL heterogeneousGranulesURL;
    private URL indexURL;
    private URL index2URL;
    private URL indexAlphaURL;
    private URL grayURL;
    private URL index_unique_paletteAlphaURL;
    private URL rgbAURL;
    private URL rgbAURLTiff;
    private URL rgbaExtraURLTiff;
    private URL overviewURL;
    static boolean INTERACTIVE;
    private URL timeURL;
    private URL timeAdditionalDomainsURL;
    private URL timeAdditionalDomainsRangeURL;
    private URL timeRangesURL;
    private URL imposedEnvelopeURL;
    static final String H2_SAMPLE_PROPERTIES = "SPI=org.geotools.data.h2.H2DataStoreFactory\ndbtype=h2\nLoose\\ bbox=true #important for performances\nEstimated\\ extends=false #important for performances\nuser=gs\npasswd=gs\nvalidate \\connections=true #important for avoiding errors\nConnection\\ timeout=3600\nmax \\connections=10 #important for performances, internal pooling\nmin \\connections=5  #important for performances, internal pooling\n";
    private URL timeFormatURL;
    private URL oneBitURL;
    @Rule
    public TemporaryFolder tempFolder = new TemporaryFolder();

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(ImageMosaicReaderTest.class);
    }

    @Test
    public void crop() throws Exception {
        this.imageMosaicCropTest(this.rgbURL, "crop-rgbURL", false);
        this.imageMosaicCropTest(this.indexURL, "crop-indexURL", false);
        this.imageMosaicCropTest(this.grayURL, "crop-grayURL", true);
        this.imageMosaicCropTest(this.overviewURL, "crop-overviewURL", true);
        this.imageMosaicCropTest(this.indexAlphaURL, "crop-indexAlphaURL", false);
        this.imageMosaicCropTest(this.rgbAURL, "crop-rgbAURL", false);
        this.imageMosaicCropTest(this.index_unique_paletteAlphaURL, "crop-index_unique_paletteAlphaURL", true);
    }

    @Test
    public void alpha() throws Exception {
        String testName = "alpha-";
        if (INTERACTIVE) {
            this.imageMosaicSimpleParamsTest(this.rgbURL, null, null, "alpha-" + this.rgbURL.getFile() + "-original", false);
        }
        GridCoverage2D coverage = this.imageMosaicSimpleParamsTest(this.rgbURL, Color.black, Color.black, "alpha-" + this.rgbURL.getFile(), false);
        ColorModel colorModel = coverage.getRenderedImage().getColorModel();
        Assert.assertTrue((boolean)colorModel.hasAlpha());
        Assert.assertTrue((boolean)(colorModel instanceof ComponentColorModel));
        if (INTERACTIVE) {
            this.imageMosaicSimpleParamsTest(this.rgbAURL, null, null, "alpha-" + this.rgbAURL.getFile() + "-original", true);
        }
        coverage = this.imageMosaicSimpleParamsTest(this.rgbAURL, Color.black, Color.black, "alpha-" + this.rgbAURL.getFile(), false);
        colorModel = coverage.getRenderedImage().getColorModel();
        Assert.assertTrue((boolean)colorModel.hasAlpha());
        Assert.assertTrue((boolean)(colorModel instanceof ComponentColorModel));
        if (INTERACTIVE) {
            this.imageMosaicSimpleParamsTest(this.indexURL, null, null, "alpha-" + this.indexURL.getFile() + "-original", false);
        }
        coverage = this.imageMosaicSimpleParamsTest(this.indexURL, new Color(58, 49, 8), Color.black, "alpha-" + this.indexURL.getFile(), false);
        colorModel = coverage.getRenderedImage().getColorModel();
        Assert.assertTrue((boolean)colorModel.hasAlpha());
        Assert.assertTrue((boolean)(colorModel instanceof ComponentColorModel));
        if (INTERACTIVE) {
            this.imageMosaicSimpleParamsTest(this.overviewURL, null, null, "alpha-" + this.overviewURL.getFile() + "-original", false);
        }
        coverage = this.imageMosaicSimpleParamsTest(this.overviewURL, new Color(58, 49, 8), Color.black, "alpha-" + this.overviewURL.getFile() + "-indexURL", false);
        colorModel = coverage.getRenderedImage().getColorModel();
        Assert.assertTrue((boolean)colorModel.hasAlpha());
        Assert.assertTrue((boolean)(colorModel instanceof ComponentColorModel));
        if (INTERACTIVE) {
            this.imageMosaicSimpleParamsTest(this.indexAlphaURL, null, null, "alpha-" + this.indexAlphaURL.getFile() + "-original", false);
        }
        coverage = this.imageMosaicSimpleParamsTest(this.indexAlphaURL, new Color(41, 41, 33), Color.black, "alpha-" + this.indexAlphaURL.getFile(), false);
        colorModel = coverage.getRenderedImage().getColorModel();
        Assert.assertTrue((boolean)colorModel.hasAlpha());
        Assert.assertTrue((boolean)(colorModel instanceof ComponentColorModel));
        if (INTERACTIVE) {
            this.imageMosaicSimpleParamsTest(this.grayURL, null, null, "alpha-" + this.grayURL.getFile() + "-original", false);
        }
        coverage = this.imageMosaicSimpleParamsTest(this.grayURL, Color.black, Color.black, "alpha-" + this.grayURL.getFile(), false);
        colorModel = coverage.getRenderedImage().getColorModel();
        Assert.assertTrue((boolean)colorModel.hasAlpha());
        Assert.assertTrue((boolean)(colorModel instanceof ComponentColorModel));
    }

    @Test
    public void overviews() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.overviewURL);
        ParameterValueGroup readParams = format.getReadParameters();
        DefaultParameterDescriptorGroup descriptor = (DefaultParameterDescriptorGroup)readParams.getDescriptor();
        List descriptors = descriptor.descriptors();
        boolean hasOverviewPolicyParam = false;
        for (GeneralParameterDescriptor desc : descriptors) {
            if (!AbstractGridFormat.OVERVIEW_POLICY.getName().toString().equalsIgnoreCase(desc.getName().toString())) continue;
            hasOverviewPolicyParam = true;
            break;
        }
        Assert.assertTrue((boolean)hasOverviewPolicyParam);
        ImageMosaicReader reader = TestUtils.getReader(this.overviewURL, format);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, tileSize}, "overviews test");
        RenderedImage image = coverage.getRenderedImage();
        Assert.assertEquals((long)128L, (long)image.getTileWidth());
        Assert.assertEquals((long)128L, (long)image.getTileHeight());
        for (RenderedImage source : image.getSources()) {
            Assert.assertEquals((long)70L, (long)source.getTileWidth());
            Assert.assertEquals((long)94L, (long)source.getTileHeight());
        }
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void readingResolutions() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.overviewURL);
        ImageMosaicReader reader = TestUtils.getReader(this.overviewURL, format);
        double[] result = reader.getReadingResolutions(OverviewPolicy.QUALITY, new double[]{32.0, 32.0});
        Assert.assertEquals((double)16.0714285714285, (double)result[0], (double)1.0E-4);
        Assert.assertEquals((double)16.0427807486631, (double)result[1], (double)1.0E-4);
        reader.dispose();
    }

    @Test
    public void testReadFromString() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.overviewURL);
        File mosaicFile = URLs.urlToFile((URL)this.overviewURL);
        ImageMosaicReader reader = (ImageMosaicReader)format.getReader((Object)mosaicFile.getAbsolutePath());
        double[] result = reader.getReadingResolutions(OverviewPolicy.QUALITY, new double[]{32.0, 32.0});
        Assert.assertEquals((double)16.0714285714285, (double)result[0], (double)1.0E-4);
        Assert.assertEquals((double)16.0427807486631, (double)result[1], (double)1.0E-4);
        reader.dispose();
    }

    @Test
    public void timeElevationH2() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "water_temp3");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"water_temp3/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"water_temp3");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/water_temp3/datastore.properties"));){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)13L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        Assert.assertNotNull((Object)timeMetadata);
        Assert.assertEquals((long)2L, (long)timeMetadata.split(",").length);
        Assert.assertEquals((Object)timeMetadata.split(",")[0], (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)timeMetadata.split(",")[1], (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        String elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN");
        Assert.assertNotNull((Object)elevationMetadata);
        Assert.assertEquals((Object)"0,100", (Object)elevationMetadata);
        Assert.assertEquals((long)2L, (long)elevationMetadata.split(",").length);
        Assert.assertEquals((double)Double.parseDouble(elevationMetadata.split(",")[0]), (double)Double.parseDouble(reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM")), (double)1.0E-6);
        Assert.assertEquals((double)Double.parseDouble(elevationMetadata.split(",")[1]), (double)Double.parseDouble(reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM")), (double)1.0E-6);
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_DATATYPE"));
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = sdf.parse("2008-10-31T00:00:00.000Z");
        timeValues.add(date);
        time.setValue(timeValues);
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        ParameterValue direct = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        direct.setValue(false);
        ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
        elevation.setValue(Arrays.asList(100.0));
        ResourceInfo info = reader.getInfo(reader.getGridCoverageNames()[0]);
        Assert.assertTrue((boolean)(info instanceof FileResourceInfo));
        FileResourceInfo fileInfo = (FileResourceInfo)info;
        int groups = 0;
        Query query = new Query("water_temp3");
        query.setFilter((Filter)FF.like((Expression)FF.property("location"), "*100_20081031T00*"));
        try (CloseableIterator filesIterator = fileInfo.getFiles(query);){
            while (filesIterator.hasNext()) {
                FileGroupProvider.FileGroup group = (FileGroupProvider.FileGroup)filesIterator.next();
                if (groups == 0) {
                    Map md = group.getMetadata();
                    DateRange metadataTime = (DateRange)md.get("TIME");
                    NumberRange metadataElevation = (NumberRange)md.get("ELEVATION");
                    ReferencedEnvelope metadataBBOX = (ReferencedEnvelope)md.get("BOUNDINGBOX");
                    Assert.assertEquals((long)metadataTime.getMinValue().getTime(), (long)date.getTime());
                    Assert.assertEquals((double)((Double)metadataElevation.getMinValue()), (double)100.0, (double)1.0E-4);
                    Assert.assertEquals((double)envelope.getMinimum(0), (double)metadataBBOX.getMinX(), (double)1.0E-4);
                    Assert.assertEquals((double)envelope.getMinimum(1), (double)metadataBBOX.getMinY(), (double)1.0E-4);
                    Assert.assertEquals((double)envelope.getMaximum(0), (double)metadataBBOX.getMaxX(), (double)1.0E-4);
                    Assert.assertEquals((double)envelope.getMaximum(1), (double)metadataBBOX.getMaxY(), (double)1.0E-4);
                }
                ++groups;
            }
        }
        Assert.assertEquals((long)1L, (long)groups);
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader.dispose();
        reader = TestUtils.getReader(timeElevURL, format);
        elevation.setValue(Arrays.asList(NumberRange.create((double)0.0, (double)10.0)));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"water_temp3"));
        }
        reader.dispose();
    }

    @Test
    public void testTypeNameBackwardsCompatibility() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "water_temp5");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"water_temp5/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"water_temp5");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/water_temp5/datastore.properties"));){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        format = null;
        File mosaicFile = new File(TestData.file((Object)this, (String)"."), "/water_temp5/water_temp5.properties");
        Properties properties = new Properties();
        try (FileInputStream fin = new FileInputStream(mosaicFile);){
            properties.load(fin);
        }
        Assert.assertTrue((boolean)properties.containsKey("SuggestedFormat"));
        Assert.assertTrue((boolean)"org.geotools.gce.geotiff.GeoTiffFormat".equalsIgnoreCase((String)properties.get("SuggestedFormat")));
        try (FileWriter fw = new FileWriter(mosaicFile);){
            Assert.assertNotNull((Object)properties.remove("TypeName"));
            properties.store(fw, "");
        }
        format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"water_temp5"));
        }
    }

    @Test
    public void testMixedTables() throws Exception {
        String mosaicName = "water_temp6";
        File workDir = new File(TestData.file((Object)this, (String)"."), mosaicName);
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)(mosaicName + "/watertemp.zip"));
        URL timeElevURL = TestData.url((Object)this, (String)mosaicName);
        File datastoreProperties = new File(workDir, "datastore.properties");
        try (FileWriter out = new FileWriter(datastoreProperties);){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        format = null;
        File indexerProperties = new File(workDir, "indexer.properties");
        Properties indexer = new Properties();
        indexer.put("UseExistingSchema", "true");
        indexer.put("TypeName", "customIndex");
        try (FileOutputStream os = new FileOutputStream(indexerProperties);){
            indexer.store(os, null);
        }
        Properties props = new Properties();
        try (FileInputStream is = new FileInputStream(datastoreProperties);){
            props.load(is);
        }
        props.put("database", new File(workDir, "imagemosaic").getPath());
        JDBCDataStore store = (JDBCDataStore)DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)props));
        store.createSchema(DataUtilities.createType((String)"aaa_noFootprint", (String)"a:String,b:Integer"));
        store.createSchema(DataUtilities.createType((String)"bbb_noLocation", (String)"geom:Polygon,b:String"));
        try (Connection conn = store.getConnection(Transaction.AUTO_COMMIT);
             Statement st = conn.createStatement();){
            st.execute("alter table \"" + mosaicName + "\" rename to \"customIndex\"");
            st.execute("UPDATE GEOMETRY_COLUMNS SET F_TABLE_NAME = 'customIndex'");
        }
        store.dispose();
        for (File file : FileUtils.listFiles((File)workDir, (IOFileFilter)new RegexFileFilter(mosaicName + ".*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        format = null;
    }

    @Test
    public void timeElevation() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "watertemp2");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"watertemp2/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"watertemp2");
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)13L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        Assert.assertNotNull((Object)timeMetadata);
        Assert.assertEquals((long)2L, (long)timeMetadata.split(",").length);
        Assert.assertEquals((Object)timeMetadata.split(",")[0], (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)timeMetadata.split(",")[1], (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.util.Date", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        String elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN");
        Assert.assertNotNull((Object)elevationMetadata);
        Assert.assertEquals((Object)"0,100", (Object)elevationMetadata);
        Assert.assertEquals((long)2L, (long)elevationMetadata.split(",").length);
        Assert.assertEquals((Object)elevationMetadata.split(",")[0], (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)elevationMetadata.split(",")[1], (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_DATATYPE"));
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = sdf.parse("2008-11-01T00:00:00.000Z");
        timeValues.add(date);
        time.setValue(timeValues);
        ParameterValue direct = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        direct.setValue(false);
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
        elevation.setValue(Arrays.asList(0.0));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader = TestUtils.getReader(timeElevURL, format);
        elevation.setValue(Arrays.asList(NumberRange.create((double)0.0, (double)10.0)));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, time, bkg, elevation, direct}, "Time-Elevation Test");
        reader.dispose();
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"watertemp2"));
        }
    }

    @Test
    public void timeDoubleElevation() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "watertemp1");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"watertemp1/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"watertemp1");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/watertemp1/indexer.properties"));){
            out.write("TimeAttribute=ingestion\n");
            out.write("ElevationAttribute=elevation\n");
            out.write("Schema=*the_geom:Polygon,location:String,ingestion:java.util.Date,elevation:Double\n");
            out.write("PropertyCollectors=TimestampFileNameExtractorSPI[timeregex](ingestion),DoubleFileNameExtractorSPI[elevationregex](elevation)\n");
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)13L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        Assert.assertNotNull((Object)timeMetadata);
        Assert.assertEquals((long)2L, (long)timeMetadata.split(",").length);
        Assert.assertEquals((Object)timeMetadata.split(",")[0], (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)timeMetadata.split(",")[1], (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        String elevationMetadata = reader.getMetadataValue("ELEVATION_DOMAIN");
        Assert.assertNotNull((Object)elevationMetadata);
        Assert.assertEquals((long)2L, (long)elevationMetadata.split(",").length);
        Assert.assertEquals((Object)"0.0", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"100.0", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.lang.Double", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_DATATYPE"));
        reader.dispose();
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"watertemp1"));
        }
    }

    @Test
    public void imposedBBox() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.imposedEnvelopeURL);
        ImageMosaicReader reader = TestUtils.getReader(this.imposedEnvelopeURL, format);
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Assert.assertNotNull((Object)envelope);
        Assert.assertEquals((double)-180.0, (double)envelope.getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)-90.0, (double)envelope.getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)180.0, (double)envelope.getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)90.0, (double)envelope.getMaximum(1), (double)1.0E-6);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 3.0, (double)reader.getOriginalGridRange().getSpan(1) / 3.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai}, "Imposed BBox");
        GridGeometry2D ggCoverage = coverage.getGridGeometry();
        Assert.assertEquals((long)0L, (long)ggCoverage.getGridRange().getLow(0));
        Assert.assertEquals((long)0L, (long)ggCoverage.getGridRange().getLow(1));
        reader.dispose();
    }

    @Test
    public void time() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeURL, format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)13L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-03-01T00:00:00.000Z,2004-04-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
        Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        final SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatD.setTimeZone(TimeZone.getTimeZone("GMT"));
        final Date timeD = formatD.parse("2004-02-01T00:00:00.000Z");
        time.setValue((Object)new ArrayList<Date>(){
            {
                this.add(timeD);
            }
        });
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, time}, "time test");
        reader = TestUtils.getReader(this.timeURL, format);
        time.setValue((Object)new ArrayList<DateRange>(){
            {
                this.add(new DateRange(formatD.parse("2004-02-01T00:00:00.000Z"), formatD.parse("2004-03-01T00:00:00.000Z")));
            }
        });
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, time}, "time test");
        reader.dispose();
    }

    @Test
    public void testTimeFormat() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeFormatURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeFormatURL, format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)13L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2004-02-01T12:05:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"2004-05-30T12:15:59.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"2004-02-01T12:05:00.000Z,2004-03-01T15:07:00.000Z,2004-04-15T19:05:00.000Z,2004-05-30T12:15:59.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
        Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        reader.dispose();
    }

    @Test
    public void timeAdditionalDim() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsURL, format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)19L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DATE_DOMAIN"));
        Assert.assertEquals((Object)"20081031T0000000,20081101T0000000", (Object)reader.getMetadataValue("DATE_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("DATE_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_XX_DOMAIN"));
        Assert.assertEquals((Object)"20,100", (Object)reader.getMetadataValue("DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("DEPTH_DOMAIN_DATATYPE"));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatD.setTimeZone(TimeZone.getTimeZone("GMT"));
        final Date timeD = formatD.parse("2008-10-31T00:00:00.000Z");
        time.setValue((Object)new ArrayList<Date>(){
            {
                this.add(timeD);
            }
        });
        Set params = reader.getDynamicParameters();
        ParameterValue dateValue = null;
        ParameterValue depthValue = null;
        String selectedWaveLength = "020";
        String selectedDate = "20081031T0000000";
        for (ParameterDescriptor param : params) {
            ParameterValue value;
            if (param.getName().getCode().equalsIgnoreCase("DATE")) {
                dateValue = value = param.createValue();
                dateValue.setValue((Object)new ArrayList<String>(){
                    {
                        this.add("20081031T0000000");
                    }
                });
                continue;
            }
            if (!param.getName().getCode().equalsIgnoreCase("DEPTH")) continue;
            depthValue = value = param.createValue();
            depthValue.setValue((Object)new ArrayList<String>(){
                {
                    this.add("020");
                }
            });
        }
        Assert.assertNotNull(depthValue);
        Assert.assertNotNull(dateValue);
        GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, time, dateValue, depthValue};
        GridCoverage2D coverage = TestUtils.getCoverage(reader, values, true);
        String fileSource = (String)coverage.getProperty("OriginalFileSource");
        String baseName = FilenameUtils.getBaseName((String)fileSource);
        Assert.assertEquals((Object)baseName, (Object)"NCOM_wattemp_020_20081031T0000000_12");
        TestUtils.testCoverage(reader, values, "domain test", coverage, null);
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void timeAdditionalDimRanges() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsRangeURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsRangeURL, format);
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((long)19L, (long)metadataNames.length);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z/2008-11-04T00:00:00.000Z/PT1S,2008-11-05T00:00:00.000Z/2008-11-07T00:00:00.000Z/PT1S", (Object)reader.getMetadataValue("TIME_DOMAIN"));
            Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
            Assert.assertEquals((Object)"2008-11-07T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
            String expectedType = Boolean.getBoolean("org.geotools.shapefile.datetime") ? "java.sql.Timestamp" : "java.util.Date";
            Assert.assertEquals((Object)expectedType, (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
            Assert.assertEquals((Object)"20/99,100/150", (Object)reader.getMetadataValue("ELEVATION_DOMAIN"));
            Assert.assertEquals((Object)"20", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM"));
            Assert.assertEquals((Object)"150", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM"));
            Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_DATATYPE"));
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DATE_DOMAIN"));
            Assert.assertEquals((Object)"20081031T000000,20081101T000000,20081105T000000", (Object)reader.getMetadataValue("DATE_DOMAIN"));
            Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("DATE_DOMAIN_DATATYPE"));
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_WAVELENGTH_DOMAIN"));
            Assert.assertEquals((Object)"12/24,25/80", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN"));
            Assert.assertEquals((Object)"12", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN_MINIMUM"));
            Assert.assertEquals((Object)"80", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN_MAXIMUM"));
            Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN_DATATYPE"));
            ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
            useJai.setValue(false);
            ParameterValue time = ImageMosaicFormat.TIME.createValue();
            final Date timeD = this.parseTimeStamp("2008-11-01T00:00:00.000Z");
            time.setValue((Object)new ArrayList<Date>(){
                {
                    this.add(timeD);
                }
            });
            ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
            elevation.setValue((Object)new ArrayList<Double>(){
                {
                    this.add(34.0);
                }
            });
            Set params = reader.getDynamicParameters();
            ParameterValue dateValue = null;
            ParameterValue waveLength = null;
            String selectedWaveLength = "20";
            String selectedDate = "20081031T000000";
            for (ParameterDescriptor param : params) {
                ParameterValue value;
                if (param.getName().getCode().equalsIgnoreCase("DATE")) {
                    dateValue = value = param.createValue();
                    dateValue.setValue((Object)new ArrayList<String>(){
                        {
                            this.add("20081031T000000");
                        }
                    });
                    continue;
                }
                if (!param.getName().getCode().equalsIgnoreCase("WAVELENGTH")) continue;
                waveLength = value = param.createValue();
                waveLength.setValue((Object)new ArrayList<String>(){
                    {
                        this.add("20");
                    }
                });
            }
            Assert.assertNotNull(waveLength);
            Assert.assertNotNull(dateValue);
            GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, dateValue, time, waveLength, elevation};
            GridCoverage2D coverage = TestUtils.getCoverage(reader, values, true);
            String fileSource = (String)coverage.getProperty("OriginalFileSource");
            String baseName = FilenameUtils.getBaseName((String)fileSource);
            Assert.assertEquals((Object)baseName, (Object)"temp_020_099_20081031T000000_20081103T000000_12_24");
            TestUtils.testCoverage(reader, values, "domain test", coverage, null);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmptyMosaic() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "emptyMosaic");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "temperature.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"temperature.zip"), (File)zipFile);
        TestData.unzipFile((Object)this, (String)"emptyMosaic/temperature.zip");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/emptyMosaic/datastore.properties"));){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        FileUtils.deleteQuietly((File)zipFile);
        URL emptyMosaicURL = TestData.url((Object)this, (String)"emptyMosaic");
        AbstractGridFormat mosaicFormat = TestUtils.getFormat(emptyMosaicURL);
        ImageMosaicReader reader = TestUtils.getReader(emptyMosaicURL, mosaicFormat);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNull((Object)metadataNames);
        File source = URLs.urlToFile((URL)this.timeRangesURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "singleHarvest1");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        File renamed = new File(directory1, "temp_020_099_20081101T000000_20081104T000000.tiff");
        try {
            List summary = reader.harvest(null, (Object)renamed, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertEquals((Object)renamed.getCanonicalFile(), (Object)((File)hf.getSource()).getCanonicalFile());
            Assert.assertTrue((boolean)hf.success());
            reader = TestUtils.getReader(emptyMosaicURL, mosaicFormat);
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2008-11-01T00:00:00.000Z/2008-11-04T00:00:00.000Z/PT1S", (Object)reader.getMetadataValue(metadataNames[0]));
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)1L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                String expected = "../singleHarvest1/temp_020_099_20081101T000000_20081104T000000.tiff".replace('/', File.separatorChar);
                Assert.assertEquals((Object)expected, (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2008-11-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
            }
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testImageMosaicConfigFilePath() throws Exception {
        CatalogBuilderConfiguration builderConfig = new CatalogBuilderConfiguration();
        Indexer indexer = builderConfig.getIndexer();
        ParametersType parameters = indexer.getParameters();
        List parameterList = parameters.getParameter();
        File file = TestData.file((Object)this, (String)"merge");
        File auxFile = new File(file, "aux.xml");
        IndexerUtils.setParam((List)parameterList, (String)"RootMosaicDirectory", (String)file.getAbsolutePath());
        IndexerUtils.setParam((List)parameterList, (String)"IndexingDirectories", (String)file.getAbsolutePath());
        IndexerUtils.setParam((List)parameterList, (String)"AuxiliaryFile", (String)auxFile.getAbsolutePath());
        IndexerUtils.setParam((List)parameterList, (String)"AbsolutePath", (String)"true");
        ImageMosaicConfigHandler handler = new ImageMosaicConfigHandler(builderConfig, new ImageMosaicEventHandlers());
        Hints hints = handler.getRunConfiguration().getHints();
        String auxiliaryFilePath = (String)hints.get((Object)Utils.AUXILIARY_FILES_PATH);
        Assert.assertEquals((Object)auxFile.getAbsolutePath(), (Object)auxiliaryFilePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmpytMosaicXML() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "emptyMosaicXML");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "temperature2.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"temperature2.zip"), (File)zipFile);
        TestData.unzipFile((Object)this, (String)"emptyMosaicXML/temperature2.zip");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/emptyMosaicXML/datastore.properties"));){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        FileUtils.deleteQuietly((File)zipFile);
        URL emptyMosaicURL = TestData.url((Object)this, (String)"emptyMosaicXML");
        AbstractGridFormat mosaicFormat = TestUtils.getFormat(emptyMosaicURL);
        ImageMosaicReader reader = TestUtils.getReader(emptyMosaicURL, mosaicFormat);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNull((Object)metadataNames);
        File tempDir = new File(TestData.file((Object)this, (String)"."), "water_temp4");
        if (!tempDir.mkdir()) {
            FileUtils.deleteDirectory((File)tempDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(tempDir)), (boolean)tempDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(tempDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"water_temp4/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"water_temp4");
        File source = URLs.urlToFile((URL)timeElevURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "singleHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        File renamed = new File(directory1, "NCOM_wattemp_000_20081031T0000000_12.tiff");
        try {
            List summary = reader.harvest(null, (Object)renamed, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertEquals((Object)renamed.getCanonicalFile(), (Object)((File)hf.getSource()).getCanonicalFile());
            Assert.assertTrue((boolean)hf.success());
            reader = TestUtils.getReader(emptyMosaicURL, mosaicFormat);
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)1L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                String expected = "../singleHarvest2/NCOM_wattemp_000_20081031T0000000_12.tiff".replace('/', File.separatorChar);
                Assert.assertEquals((Object)expected, (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
            }
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void granuleSourceTest() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsRangeURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsRangeURL, format);
        GranuleSource source = reader.getGranules("time_domainsRanges", true);
        int granules = source.getCount(null);
        SimpleFeatureType type = source.getSchema();
        Assert.assertEquals((Object)"SimpleFeatureTypeImpl time_domainsRanges identified extends polygonFeature(the_geom:MultiPolygon,location:String,time:Date,endtime:Date,date:String,lowz:Integer,highz:Integer,loww:Integer,highw:Integer)", (Object)type.toString());
        Assert.assertEquals((long)granules, (long)12L);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)19L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z/2008-11-04T00:00:00.000Z/PT1S,2008-11-05T00:00:00.000Z/2008-11-07T00:00:00.000Z/PT1S", (Object)reader.getMetadataValue("TIME_DOMAIN"));
        Assert.assertEquals((Object)"2008-10-31T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"2008-11-07T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.util.Date", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"20/99,100/150", (Object)reader.getMetadataValue("ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"20", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"150", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("ELEVATION_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DATE_DOMAIN"));
        Assert.assertEquals((Object)"20081031T000000,20081101T000000,20081105T000000", (Object)reader.getMetadataValue("DATE_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("DATE_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_WAVELENGTH_DOMAIN"));
        Assert.assertEquals((Object)"12/24,25/80", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN"));
        Assert.assertEquals((Object)"12", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"80", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("WAVELENGTH_DOMAIN_DATATYPE"));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        final Date timeD = this.parseTimeStamp("2008-11-01T00:00:00.000Z");
        time.setValue((Object)new ArrayList<Date>(){
            {
                this.add(timeD);
            }
        });
        ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
        elevation.setValue((Object)new ArrayList<Double>(){
            {
                this.add(34.0);
            }
        });
        Set params = reader.getDynamicParameters();
        ParameterValue dateValue = null;
        ParameterValue waveLength = null;
        String selectedWaveLength = "20";
        String selectedDate = "20081031T000000";
        for (ParameterDescriptor param : params) {
            ParameterValue value;
            if (param.getName().getCode().equalsIgnoreCase("DATE")) {
                dateValue = value = param.createValue();
                dateValue.setValue((Object)new ArrayList<String>(){
                    {
                        this.add("20081031T000000");
                    }
                });
                continue;
            }
            if (!param.getName().getCode().equalsIgnoreCase("WAVELENGTH")) continue;
            waveLength = value = param.createValue();
            waveLength.setValue((Object)new ArrayList<String>(){
                {
                    this.add("20");
                }
            });
        }
        Assert.assertNotNull(waveLength);
        Assert.assertNotNull(dateValue);
        File covFile = URLs.urlToFile((URL)this.timeAdditionalDomainsRangeURL);
        File propFile = new File(covFile, "time_domainsRanges.properties");
        Assert.assertTrue((boolean)propFile.exists());
        Properties props = CoverageUtilities.loadPropertiesFromURL((URL)URLs.fileToUrl((File)propFile));
        String suggestedSpi = props.getProperty("SuggestedSPI");
        Assert.assertNotNull((Object)suggestedSpi);
        Class<?> clazz = Class.forName(suggestedSpi);
        Assert.assertNotNull(clazz);
        GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, dateValue, time, waveLength, elevation};
        GridCoverage2D coverage = TestUtils.getCoverage(reader, values, true);
        String fileSource = (String)coverage.getProperty("OriginalFileSource");
        String baseName = FilenameUtils.getBaseName((String)fileSource);
        Assert.assertEquals((Object)baseName, (Object)"temp_020_099_20081031T000000_20081103T000000_12_24");
        TestUtils.testCoverage(reader, values, "domain test", coverage, null);
        reader.dispose();
    }

    @Test
    public void testDimensionsDescriptor() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsRangeURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsRangeURL, format);
        List descriptors = reader.getDimensionDescriptors("time_domainsRanges");
        Assert.assertNotNull((Object)descriptors);
        Assert.assertEquals((long)4L, (long)descriptors.size());
        HashMap<String, DimensionDescriptor> dds = new HashMap<String, DimensionDescriptor>();
        for (DimensionDescriptor dd : descriptors) {
            dds.put(dd.getName(), dd);
        }
        DimensionDescriptor descriptor = (DimensionDescriptor)dds.get("wavelength");
        Assert.assertEquals((Object)"wavelength", (Object)descriptor.getName());
        Assert.assertEquals((Object)"loww", (Object)descriptor.getStartAttribute());
        Assert.assertEquals((Object)"highw", (Object)descriptor.getEndAttribute());
        descriptor = (DimensionDescriptor)dds.get("date");
        Assert.assertEquals((Object)"date", (Object)descriptor.getName());
        Assert.assertEquals((Object)"date", (Object)descriptor.getStartAttribute());
        Assert.assertNull((Object)descriptor.getEndAttribute());
        descriptor = (DimensionDescriptor)dds.get("TIME");
        Assert.assertEquals((Object)"TIME", (Object)descriptor.getName());
        Assert.assertEquals((Object)"time", (Object)descriptor.getStartAttribute());
        Assert.assertEquals((Object)"endtime", (Object)descriptor.getEndAttribute());
        Assert.assertEquals((Object)CoverageUtilities.UCUM.TIME_UNITS.getName(), (Object)descriptor.getUnits());
        Assert.assertEquals((Object)CoverageUtilities.UCUM.TIME_UNITS.getSymbol(), (Object)descriptor.getUnitSymbol());
        descriptor = (DimensionDescriptor)dds.get("ELEVATION");
        Assert.assertEquals((Object)"ELEVATION", (Object)descriptor.getName());
        Assert.assertEquals((Object)"lowz", (Object)descriptor.getStartAttribute());
        Assert.assertEquals((Object)"highz", (Object)descriptor.getEndAttribute());
        reader.dispose();
    }

    @Test
    public void testAdditionalDimRangesNoTimestamp() throws Exception {
        System.setProperty("org.geotools.shapefile.datetime", "false");
        this.timeAdditionalDimRanges();
    }

    @Test
    public void timeTimeRangeSelection() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsRangeURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsRangeURL, format);
        GridCoverage2D coverage = this.readCoverageInDateRange(reader, "2008-10-20T00:00:00.000Z", "2008-10-25T12:00:00.000Z");
        Assert.assertNull((Object)coverage);
        coverage = this.readCoverageInDateRange(reader, "2008-11-20T00:00:00.000Z", "2008-11-25T12:00:00.000Z");
        Assert.assertNull((Object)coverage);
        coverage = this.readCoverageInDateRange(reader, "2008-11-04T12:00:00.000Z", "2008-11-04T18:00:00.000Z");
        Assert.assertNull((Object)coverage);
        coverage = this.readCoverageInDateRange(reader, "2008-10-20T00:00:00.000Z", "2008-11-20T00:00:00.000Z");
        Assert.assertNotNull((Object)coverage);
        coverage = this.readCoverageInDateRange(reader, "2008-10-28T00:00:00.000Z", "2008-10-31T18:00:00.000Z");
        Assert.assertNotNull((Object)coverage);
        String fileSource = (String)coverage.getProperty("OriginalFileSource");
        Assert.assertEquals((Object)"temp_020_099_20081031T000000_20081103T000000_12_24", (Object)FilenameUtils.getBaseName((String)fileSource));
        coverage = this.readCoverageInDateRange(reader, "2008-11-03T12:00:00.000Z", "2008-11-04T00:00:00.000Z");
        Assert.assertNotNull((Object)coverage);
        fileSource = (String)coverage.getProperty("OriginalFileSource");
        Assert.assertEquals((Object)"temp_020_099_20081101T000000_20081104T000000_12_24", (Object)FilenameUtils.getBaseName((String)fileSource));
        coverage = this.readCoverageInDateRange(reader, "2008-10-31T00:00:00.000Z", "2008-10-31T00:00:00.000Z");
        Assert.assertNotNull((Object)coverage);
        fileSource = (String)coverage.getProperty("OriginalFileSource");
        Assert.assertEquals((Object)"temp_020_099_20081031T000000_20081103T000000_12_24", (Object)FilenameUtils.getBaseName((String)fileSource));
        coverage = this.readCoverageInDateRange(reader, "2008-11-04T00:00:00.000Z", "2008-11-04T00:00:00.000Z");
        Assert.assertNotNull((Object)coverage);
        fileSource = (String)coverage.getProperty("OriginalFileSource");
        Assert.assertEquals((Object)"temp_020_099_20081101T000000_20081104T000000_12_24", (Object)FilenameUtils.getBaseName((String)fileSource));
        reader.dispose();
    }

    private GridCoverage2D readCoverageInDateRange(ImageMosaicReader reader, String start, String end) throws Exception {
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        Date s = this.parseTimeStamp(start);
        Date e = this.parseTimeStamp(end);
        DateRange range = new DateRange(s, e);
        time.setValue(Arrays.asList(range));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue elevation = ImageMosaicFormat.ELEVATION.createValue();
        elevation.setValue((Object)new ArrayList<Double>(){
            {
                this.add(34.0);
            }
        });
        Set params = reader.getDynamicParameters();
        ParameterValue waveLength = null;
        String selectedWaveLength = "20";
        for (ParameterDescriptor param : params) {
            ParameterValue value;
            if (!param.getName().getCode().equalsIgnoreCase("WAVELENGTH")) continue;
            waveLength = value = param.createValue();
            waveLength.setValue((Object)new ArrayList<String>(){
                {
                    this.add("20");
                }
            });
        }
        Assert.assertNotNull(waveLength);
        GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, time, waveLength, elevation};
        return TestUtils.getCoverage(reader, values, false);
    }

    private Date parseTimeStamp(String timeStamp) throws ParseException {
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatD.setTimeZone(TimeZone.getTimeZone("GMT"));
        return formatD.parse(timeStamp);
    }

    @Test
    public void multipleDimensionsStacked() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsURL, format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)19L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DATE_DOMAIN"));
        Assert.assertEquals((Object)"20081031T0000000,20081101T0000000", (Object)reader.getMetadataValue("DATE_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("DATE_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"20,100", (Object)reader.getMetadataValue("DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("DEPTH_DOMAIN_DATATYPE"));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatD.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date timeD = formatD.parse("2008-10-31T00:00:00.000Z");
        time.setValue(Arrays.asList(timeD));
        ParameterValue mergeStack = ImageMosaicFormat.MERGE_BEHAVIOR.createValue();
        mergeStack.setValue((Object)MergeBehavior.STACK.toString());
        ParameterValue sort = ImageMosaicFormat.SORT_BY.createValue();
        sort.setValue((Object)"depth A");
        GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, tileSize, time, mergeStack, sort};
        GridCoverage2D coverage = TestUtils.getCoverage(reader, values, false);
        Assert.assertNotNull((Object)coverage);
        String fileLocation = (String)coverage.getProperty("OriginalFileSource");
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.containsString((String)"NCOM_wattemp_020_20081031T0000000_12.tiff,"));
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.endsWith((String)"NCOM_wattemp_100_20081031T0000000_12.tiff"));
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"NCOM_wattemp_100_20081101T0000000_12.tiff")));
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"NCOM_wattemp_020_20081101T0000000_12.tiff")));
        RenderedImage image = coverage.getRenderedImage();
        Assert.assertEquals((String)"wrong number of bands detected", (long)2L, (long)image.getSampleModel().getNumBands());
        GeneralParameterValue[] values20 = new GeneralParameterValue[]{useJai, tileSize, time, this.dynamicParameter(reader, "depth", 20)};
        GridCoverage2D coverage20 = TestUtils.getCoverage(reader, values20, false);
        this.assertBandEqual(image, 0, coverage20.getRenderedImage());
        GeneralParameterValue[] values100 = new GeneralParameterValue[]{useJai, tileSize, time, this.dynamicParameter(reader, "depth", 100)};
        GridCoverage2D coverage100 = TestUtils.getCoverage(reader, values20, false);
        this.assertBandEqual(image, 1, coverage100.getRenderedImage());
        reader.dispose();
    }

    private void assertBandEqual(RenderedImage image, int band, RenderedImage expected) {
        ImageWorker iw = new ImageWorker(image);
        iw.retainBands(new int[]{band});
        iw.subtract(expected);
        double[] maximums = iw.getMaximums();
        Assert.assertArrayEquals((double[])new double[]{0.0}, (double[])maximums, (double)0.0);
    }

    private GeneralParameterValue dynamicParameter(ImageMosaicReader reader, String parameterName, Object parameterValue) {
        Set params = reader.getDynamicParameters();
        ParameterValue depthParam = null;
        for (ParameterDescriptor param : params) {
            if (!param.getName().getCode().equalsIgnoreCase(parameterName)) continue;
            depthParam = param.createValue();
            depthParam.setValue(Arrays.asList(parameterValue));
        }
        return depthParam;
    }

    @Test
    public void testHeterogeneousGranules() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.heterogeneousGranulesURL);
        ImageMosaicReader reader = TestUtils.getReader(this.heterogeneousGranulesURL, format);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize(10, 10);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue op = AbstractGridFormat.OVERVIEW_POLICY.createValue();
        LOGGER.info("\nTesting with OverviewPolicy = QUALITY");
        op.setValue((Object)OverviewPolicy.QUALITY);
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, op}, "heterogeneous granules test: OverviewPolicy=QUALITY", (Rectangle)rasterArea);
        LOGGER.info("\nTesting with OverviewPolicy = SPEED");
        reader = TestUtils.getReader(this.heterogeneousGranulesURL, format);
        op.setValue((Object)OverviewPolicy.SPEED);
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, op}, "heterogeneous granules test: OverviewPolicy=SPEED", (Rectangle)rasterArea);
        LOGGER.info("\nTesting with OverviewPolicy = NEAREST");
        reader = TestUtils.getReader(this.heterogeneousGranulesURL, format);
        op.setValue((Object)OverviewPolicy.NEAREST);
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, op}, "heterogeneous granules test: OverviewPolicy=NEAREST", (Rectangle)rasterArea);
        LOGGER.info("\nTesting with OverviewPolicy = IGNORE");
        reader = TestUtils.getReader(this.heterogeneousGranulesURL, format);
        op.setValue((Object)OverviewPolicy.IGNORE);
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, useJai, op}, "heterogeneous granules test: OverviewPolicy=IGNORE", (Rectangle)rasterArea);
        reader.dispose();
    }

    @Test
    public void defaultParameterValue() throws Exception {
        String baseTestName = "testDefaultParameterValue";
        this.imageMosaicSimpleParamsTest(this.rgbURL, null, null, "testDefaultParameterValue" + this.rgbURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.rgbAURL, null, null, "testDefaultParameterValue" + this.rgbAURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.overviewURL, null, null, "testDefaultParameterValue" + this.overviewURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.indexURL, null, null, "testDefaultParameterValue" + this.indexURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.grayURL, null, null, "testDefaultParameterValue" + this.grayURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.indexAlphaURL, null, null, "testDefaultParameterValue" + this.indexAlphaURL.getFile(), false);
    }

    @Test
    public void oneBit() throws Exception {
        String baseTestName = "oneBit";
        this.imageMosaicSimpleParamsTest(this.oneBitURL, null, null, "oneBit" + this.oneBitURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.oneBitURL, Color.white, null, "oneBit" + this.oneBitURL.getFile(), false);
        this.imageMosaicSimpleParamsTest(this.oneBitURL, null, Color.white, "oneBit" + this.oneBitURL.getFile(), false);
    }

    @Test
    public void errors() throws Exception {
        GridCoverage2D gc;
        Hints hints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)CRS.decode((String)"EPSG:4326", (boolean)true));
        AbstractGridCoverage2DReader reader = null;
        try {
            LOGGER.info("Testing Invalid location attribute. (A DataSourceException should be catched) ");
            reader = GridFormatFinder.findFormat((Object)this.rgbURL, (Hints)hints).getReader((Object)this.rgbURL, new Hints((RenderingHints.Key)Hints.MOSAIC_LOCATION_ATTRIBUTE, (Object)"aaaa"));
            Assert.assertNull((Object)reader);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        try {
            reader = GridFormatFinder.findFormat((Object)this.rgbURL, (Hints)hints).getReader((Object)this.rgbURL, new Hints((RenderingHints.Key)Hints.MOSAIC_LOCATION_ATTRIBUTE, (Object)"location"));
            Assert.assertNotNull((Object)reader);
            reader.dispose();
            Assert.assertTrue((boolean)true);
        }
        catch (Throwable e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
        try {
            reader = GridFormatFinder.findFormat((Object)this.rgbURL).getReader((Object)this.rgbURL, new Hints((RenderingHints.Key)Hints.MAX_ALLOWED_TILES, (Object)2));
            Assert.assertNotNull((Object)reader);
            gc = reader.read(null);
            Assert.fail((String)"MAX_ALLOWED_TILES was not respected");
        }
        catch (Throwable e) {
            if (reader != null) {
                reader.dispose();
            }
            Assert.assertTrue((boolean)true);
        }
        try {
            reader = GridFormatFinder.findFormat((Object)this.rgbURL).getReader((Object)this.rgbURL, new Hints((RenderingHints.Key)Hints.MAX_ALLOWED_TILES, (Object)1000));
            Assert.assertNotNull((Object)reader);
            gc = reader.read(null);
            Assert.assertTrue((boolean)true);
            gc.dispose(true);
            reader.dispose();
        }
        catch (Exception e) {
            Assert.fail((String)e.getLocalizedMessage());
        }
    }

    private GridCoverage2D imageMosaicSimpleParamsTest(URL testURL, Color inputTransparent, Color outputTransparent, String title, boolean blend) throws Exception {
        Assert.assertNotNull((Object)testURL);
        AbstractGridFormat format = TestUtils.getFormat(testURL);
        ImageMosaicReader reader = TestUtils.getReader(testURL, format);
        ParameterValue inTransp = AbstractGridFormat.INPUT_TRANSPARENT_COLOR.createValue();
        inTransp.setValue((Object)inputTransparent);
        ParameterValue outTransp = ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.createValue();
        outTransp.setValue((Object)outputTransparent);
        ParameterValue blendPV = ImageMosaicFormat.FADING.createValue();
        blendPV.setValue(blend);
        GridCoverage2D gridCoverage2D = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{inTransp, blendPV, outTransp}, title);
        reader.dispose();
        return gridCoverage2D;
    }

    static void show(RenderedImage image, String title) {
        ImageIOUtilities.visualize((RenderedImage)image, (String)title);
    }

    private void imageMosaicCropTest(URL testURL, String title, boolean acceptContainment) throws Exception {
        Assert.assertNotNull((Object)testURL);
        AbstractGridFormat format = TestUtils.getFormat(testURL);
        ImageMosaicReader reader = TestUtils.getReader(testURL, format);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope oldEnvelope = reader.getOriginalEnvelope();
        GeneralEnvelope cropEnvelope = new GeneralEnvelope(new double[]{oldEnvelope.getLowerCorner().getOrdinate(0) + oldEnvelope.getSpan(0) / 2.0, oldEnvelope.getLowerCorner().getOrdinate(1) + oldEnvelope.getSpan(1) / 2.0}, new double[]{oldEnvelope.getUpperCorner().getOrdinate(0), oldEnvelope.getUpperCorner().getOrdinate(1)});
        cropEnvelope.setCoordinateReferenceSystem(reader.getCoordinateReferenceSystem());
        gg.setValue((Object)new GridGeometry2D(PixelInCell.CELL_CENTER, reader.getOriginalGridToWorld(PixelInCell.CELL_CENTER), (Envelope)cropEnvelope, null));
        ParameterValue outTransp = ImageMosaicFormat.OUTPUT_TRANSPARENT_COLOR.createValue();
        outTransp.setValue((Object)Color.black);
        double[] baseResolutions = reader.getResolutionLevels()[0];
        double tolerance = Math.max(baseResolutions[0], baseResolutions[1]) * 10.0;
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, outTransp}, title);
        if (acceptContainment) {
            this.assertContainsEnvelope((Envelope)cropEnvelope, coverage.getEnvelope(), tolerance);
        } else {
            this.assertEnvelope((Envelope)cropEnvelope, coverage.getEnvelope(), tolerance);
        }
        RenderedImage ri = coverage.getRenderedImage();
        Assert.assertEquals((float)0.0f, (float)ri.getMinX(), (float)10.0f);
        Assert.assertEquals((float)0.0f, (float)ri.getMinY(), (float)10.0f);
        reader.dispose();
    }

    void assertEnvelope(Envelope expected, Envelope actual, double tolerance) {
        Assert.assertEquals((double)expected.getMinimum(0), (double)actual.getMinimum(0), (double)tolerance);
        Assert.assertEquals((double)expected.getMaximum(0), (double)actual.getMaximum(0), (double)tolerance);
        Assert.assertEquals((double)expected.getMinimum(1), (double)actual.getMinimum(1), (double)tolerance);
        Assert.assertEquals((double)expected.getMaximum(1), (double)actual.getMaximum(1), (double)tolerance);
    }

    void assertContainsEnvelope(Envelope expected, Envelope contained, double tolerance) {
        Assert.assertTrue((expected.getMinimum(0) < contained.getMinimum(0) + tolerance ? 1 : 0) != 0);
        Assert.assertTrue((expected.getMaximum(0) > contained.getMaximum(0) - tolerance ? 1 : 0) != 0);
        Assert.assertTrue((expected.getMinimum(1) < contained.getMinimum(1) + tolerance ? 1 : 0) != 0);
        Assert.assertTrue((expected.getMaximum(1) > contained.getMaximum(1) - tolerance ? 1 : 0) != 0);
    }

    @Test
    public void testRequestInHoleNoData() throws Exception {
        File mosaicSource = TestData.file((Object)this, (String)"rgba");
        File targetRgba = new File("target", "rgba");
        FileUtils.deleteQuietly((File)targetRgba);
        FileUtils.copyDirectory((File)mosaicSource, (File)targetRgba);
        Arrays.stream(targetRgba.listFiles((f, n) -> n.startsWith("rgba") || n.startsWith("sample_image"))).forEach(f -> f.delete());
        URL testMosaicUrl = URLs.fileToUrl((File)targetRgba);
        Properties properties = new Properties();
        properties.put("NoData", "0");
        try (FileOutputStream fos = new FileOutputStream(new File(targetRgba, "indexer.properties"));){
            properties.store(fos, null);
        }
        GridCoverage2D coverage = this.testMosaicHoleOn(testMosaicUrl);
        this.assertNoData(coverage, 0.0);
    }

    private GridCoverage2D testMosaicHoleOn(URL testMosaicUrl) throws FactoryException, IOException {
        ImageMosaicReader reader = TestUtils.getReader(testMosaicUrl);
        ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Envelope2D env = new Envelope2D(reader.getCoordinateReferenceSystem(), 500000.0, 3200000.0, 1000.0, 1000.0);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 100, 100), (Envelope)env);
        ggp.setValue((Object)gg);
        ParameterValue bgp = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bgp.setValue((Object)new double[]{255.0, 0.0, 0.0, 255.0});
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{ggp, bgp});
        Assert.assertNotNull((Object)coverage);
        Assert.assertTrue((boolean)coverage.getEnvelope2D().intersects((Rectangle2D)env));
        int[] pixel = new int[4];
        coverage.evaluate((Point2D)new Point2D.Double(497987.0, 3197819.0), pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        Assert.assertEquals((long)255L, (long)pixel[3]);
        reader.dispose();
        return coverage;
    }

    @Test
    public void testRequestInHole() throws Exception {
        GridCoverage2D coverage = this.testMosaicHoleOn(this.rgbAURL);
        Assert.assertNull((Object)CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage));
    }

    @Test
    public void testBlankResponseWithBandSelection() throws FactoryException, IOException {
        File source = URLs.urlToFile((URL)this.rgbURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "rgbMosaicSource");
        File directory2 = new File(testDataDir, "rgbMosaicBandSelect");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("rgb.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new OrFileFilter((IOFileFilter)new RegexFileFilter("global_mosaic_10.*"), (IOFileFilter)new RegexFileFilter("global_mosaic_12.*")), null)) {
            file.renameTo(new File(directory2, file.getName()));
        }
        URL testUrl = URLs.fileToUrl((File)directory2);
        ImageMosaicReader reader = TestUtils.getReader(testUrl);
        ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Envelope2D env = new Envelope2D(reader.getCoordinateReferenceSystem(), 10.0, 41.0, 1.0, 1.0);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 50, 50), (Envelope)env);
        ggp.setValue((Object)gg);
        ParameterValue bands = ImageMosaicFormat.BANDS.createValue();
        bands.setValue((Object)new int[]{0, 2});
        ParameterValue bgp = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bgp.setValue((Object)new double[]{255.0, 127.0, 64.0});
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{ggp, bgp, bands});
        Assert.assertNotNull((Object)coverage);
        Assert.assertTrue((boolean)coverage.getEnvelope2D().intersects((Rectangle2D)env));
        RenderedImage ri = coverage.getRenderedImage();
        ColorModel cm = ri.getColorModel();
        SampleModel sm = ri.getSampleModel();
        Assert.assertEquals((long)2L, (long)cm.getNumComponents());
        Assert.assertEquals((long)2L, (long)sm.getNumBands());
        int[] pixel = new int[2];
        ri.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)64L, (long)pixel[1]);
        reader.dispose();
    }

    @Test
    public void testRequestInOut() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbAURL, null);
        ImageMosaicReader reader = TestUtils.getReader(this.rgbAURL, format);
        Assert.assertNotNull((Object)reader);
        ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Envelope2D env = new Envelope2D(reader.getCoordinateReferenceSystem(), 44887.0, 2299342.0, 602010.0, 856363.0);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 100, 100), (Envelope)env);
        ggp.setValue((Object)gg);
        ParameterValue bgp = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bgp.setValue((Object)new double[]{255.0, 0.0, 0.0, 255.0});
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{ggp, bgp});
        Assert.assertNotNull((Object)coverage);
        Envelope2D envelope2d = coverage.getEnvelope2D();
        Assert.assertTrue((boolean)envelope2d.contains((Rectangle2D)env));
        int[] pixel = new int[4];
        coverage.evaluate((Point2D)new Point2D.Double(430000.0, 2700000.0), pixel);
        Assert.assertEquals((long)255L, (long)pixel[0]);
        Assert.assertEquals((long)0L, (long)pixel[1]);
        Assert.assertEquals((long)0L, (long)pixel[2]);
        Assert.assertEquals((long)255L, (long)pixel[3]);
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestInAreaWithNoGranulesBecomesTransparent() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(this.rgbURL, format);
        try {
            Assert.assertNotNull((Object)reader);
            ParameterValue ggp = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
            Envelope2D env = new Envelope2D(reader.getCoordinateReferenceSystem(), 19.0, 45.0, 1.0, 1.0);
            GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 50, 50), (Envelope)env);
            ggp.setValue((Object)gg);
            ParameterValue transparent = ImageMosaicFormat.INPUT_TRANSPARENT_COLOR.createValue();
            transparent.setValue((Object)new Color(0, 0, 0));
            GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{ggp, transparent});
            Assert.assertNotNull((Object)coverage);
            Assert.assertTrue((boolean)coverage.getEnvelope2D().contains((Rectangle2D)env));
            int[] pixel = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
            coverage.evaluate((Point2D)new Point2D.Double(20.0, 45.0), pixel);
            Assert.assertEquals((long)0L, (long)pixel[0]);
            Assert.assertEquals((long)0L, (long)pixel[1]);
            Assert.assertEquals((long)0L, (long)pixel[2]);
            Assert.assertEquals((long)0L, (long)pixel[3]);
        }
        finally {
            reader.dispose();
        }
    }

    @BeforeClass
    public static void init() {
        CRS.reset((String)"all");
        System.setProperty("org.geotools.referencing.forceXY", "true");
        System.setProperty("user.timezone", "GMT");
        System.setProperty("org.geotools.shapefile.datetime", "true");
        INTERACTIVE = TestData.isInteractiveTest();
    }

    @Before
    public void setUp() throws Exception {
        this.cleanUp();
        this.rgbURL = TestData.url((Object)this, (String)"rgb");
        this.mixedSampleModelURL = TestData.url((Object)this, (String)"mixed_sample_model");
        this.coverageBandsURL = TestData.url((Object)this, (String)"coverage_bands");
        this.coverageBands2URL = TestData.url((Object)this, (String)"coverage_bands_heterogeneous");
        this.heterogeneousGranulesURL = TestData.url((Object)this, (String)"heterogeneous");
        this.timeURL = TestData.url((Object)this, (String)"time_geotiff");
        this.timeFormatURL = TestData.url((Object)this, (String)"time_format_geotiff");
        this.timeAdditionalDomainsURL = TestData.url((Object)this, (String)"time_additionaldomains");
        this.timeAdditionalDomainsRangeURL = TestData.url((Object)this, (String)"time_domainsRanges");
        this.timeRangesURL = TestData.url((Object)this, (String)"time_ranges");
        this.overviewURL = TestData.url((Object)this, (String)"overview/");
        this.rgbAURL = TestData.url((Object)this, (String)"rgba/");
        this.oneBitURL = TestData.url((Object)this, (String)"onebit/");
        this.indexURL = TestData.url((Object)this, (String)"index/");
        this.index2URL = TestData.url((Object)this, (String)"index_palette_2/");
        this.indexAlphaURL = TestData.url((Object)this, (String)"index_alpha/");
        this.grayURL = TestData.url((Object)this, (String)"gray/");
        this.index_unique_paletteAlphaURL = TestData.url((Object)this, (String)"index_alpha_unique_palette/");
        this.imposedEnvelopeURL = TestData.url((Object)this, (String)"env");
        this.rgbAURLTiff = TestData.url((Object)this, (String)"tiff_rgba/");
        this.rgbaExtraURLTiff = TestData.url((Object)this, (String)"tiff_rgba_extra/");
    }

    private void cleanUp() throws Exception {
        File[] files;
        if (INTERACTIVE) {
            return;
        }
        File dir = TestData.file((Object)this, (String)"overview/");
        for (File file : files = dir.listFiles((FilenameFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"tif"), FileFilterUtils.suffixFileFilter((String)"aux")}), FileFilterUtils.nameFileFilter((String)"datastore.properties")})))) {
            file.delete();
        }
        dir = TestData.file((Object)this, (String)"rgba/");
        for (File file : files = dir.listFiles((FilenameFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"png")), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)"wld"))})))) {
            file.delete();
        }
        dir = TestData.file((Object)this, (String)"time_domainsRanges");
        for (File file : files = dir.listFiles((FilenameFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"prj")}))) {
            file.delete();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.cleanUp();
    }

    @Test
    public void timeAdditionalDimNoResultsDueToWrongDim() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.timeAdditionalDomainsURL);
        ImageMosaicReader reader = TestUtils.getReader(this.timeAdditionalDomainsURL, format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)19L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DATE_DOMAIN"));
        Assert.assertEquals((Object)"20081031T0000000,20081101T0000000", (Object)reader.getMetadataValue("DATE_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("DATE_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"20,100", (Object)reader.getMetadataValue("DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("DEPTH_DOMAIN_DATATYPE"));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatD.setTimeZone(TimeZone.getTimeZone("GMT"));
        final Date timeD = formatD.parse("2008-10-31T00:00:00.000Z");
        time.setValue((Object)new ArrayList<Date>(){
            {
                this.add(timeD);
            }
        });
        Set params = reader.getDynamicParameters();
        ParameterValue dateValue = null;
        ParameterValue depthValue = null;
        String selectedWaveLength = "030";
        String selectedDate = "20081031T0000000";
        for (ParameterDescriptor param : params) {
            if (param.getName().getCode().equalsIgnoreCase("DATE")) {
                dateValue = param.createValue();
                dateValue.setValue((Object)new ArrayList<String>(){
                    {
                        this.add("20081031T0000000");
                    }
                });
                continue;
            }
            if (!param.getName().getCode().equalsIgnoreCase("DEPTH")) continue;
            depthValue = param.createValue();
            depthValue.setValue((Object)new ArrayList<String>(){
                {
                    this.add("030");
                }
            });
        }
        Assert.assertNotNull(depthValue);
        Assert.assertNotNull(dateValue);
        GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, time, dateValue, depthValue};
        GridCoverage2D coverage = TestUtils.getCoverage(reader, values, false);
        Assert.assertNull((Object)coverage);
        reader.dispose();
    }

    @Test
    public void multipleDimensionsStackedSar() throws Exception {
        URL sourceURL = TestData.file((Object)this, (String)"merge").toURI().toURL();
        AbstractGridFormat format = TestUtils.getFormat(sourceURL);
        ImageMosaicReader reader = TestUtils.getReader(sourceURL, format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)16L, (long)metadataNames.length);
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_POLARIZ_DOMAIN"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_POLARIZATION_DOMAIN"));
        Assert.assertEquals((Object)"POLARIZATION", (Object)((ParameterDescriptor)reader.getDynamicParameters().iterator().next()).getName().getCode());
        Assert.assertEquals((Object)"HH,HV,VH,VV", (Object)reader.getMetadataValue("POLARIZATION_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("POLARIZATION_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"2012-01-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN"));
        Assert.assertEquals((Object)"2012-01-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)"2012-01-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        SimpleDateFormat formatD = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        formatD.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date timeD = formatD.parse("2012-01-01T00:00:00.000Z");
        time.setValue(Arrays.asList(timeD));
        Set params = reader.getDynamicParameters();
        ParameterValue polariz = null;
        for (ParameterDescriptor param : params) {
            if (!param.getName().getCode().equalsIgnoreCase("POLARIZATION")) continue;
            polariz = param.createValue();
            polariz.setValue(Arrays.asList("HH", "HV", "VV"));
        }
        ParameterValue paramStacked = ImageMosaicFormat.MERGE_BEHAVIOR.createValue();
        paramStacked.setValue((Object)MergeBehavior.STACK.toString());
        ParameterValue sort = ImageMosaicFormat.SORT_BY.createValue();
        sort.setValue((Object)"polarization A");
        GeneralParameterValue[] values = new GeneralParameterValue[]{useJai, tileSize, time, polariz, paramStacked, sort};
        GridCoverage2D coverage = TestUtils.getCoverage(reader, values, false);
        Assert.assertNotNull((Object)coverage);
        String fileLocation = (String)coverage.getProperty("OriginalFileSource");
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.containsString((String)"imagery_HH_2012.tif,"));
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.containsString((String)"imagery_HV_2012.tif,"));
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.endsWith((String)"imagery_VV_2012.tif"));
        MatcherAssert.assertThat((Object)fileLocation, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.containsString((String)"imagery_VH_2012.tif")));
        RenderedImage image = coverage.getRenderedImage();
        Assert.assertEquals((String)"wrong number of bands detected", (long)3L, (long)image.getSampleModel().getNumBands());
        Assert.assertEquals((long)2L, (long)image.getSampleModel().getDataType());
        GeneralParameterValue[] valuesHH = new GeneralParameterValue[]{useJai, tileSize, time, this.dynamicParameter(reader, "polarization", "HH")};
        GridCoverage2D coverageHH = TestUtils.getCoverage(reader, valuesHH, false);
        this.assertBandEqual(image, 0, coverageHH.getRenderedImage());
        GeneralParameterValue[] valuesHV = new GeneralParameterValue[]{useJai, tileSize, time, this.dynamicParameter(reader, "polarization", "HV")};
        GridCoverage2D coverageHV = TestUtils.getCoverage(reader, valuesHV, false);
        this.assertBandEqual(image, 1, coverageHV.getRenderedImage());
        GeneralParameterValue[] valuesVV = new GeneralParameterValue[]{useJai, tileSize, time, this.dynamicParameter(reader, "polarization", "VV")};
        GridCoverage2D coverageVV = TestUtils.getCoverage(reader, valuesVV, false);
        this.assertBandEqual(image, 2, coverageVV.getRenderedImage());
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestSingleFile() throws Exception {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "singleHarvest1");
        File directory2 = new File(testDataDir, "singleHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("world\\.20040[^25].*\\.tiff"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        String monthFiveName = "world.200405.3x5400x2700.tiff";
        File monthFive = new File(directory1, monthFiveName);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        File renamed = new File(directory2, monthFiveName);
        Assert.assertTrue((boolean)monthFive.renameTo(renamed));
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            List summary = reader.harvest(null, (Object)renamed, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertEquals((Object)renamed.getCanonicalFile(), (Object)((File)hf.getSource()).getCanonicalFile());
            Assert.assertTrue((boolean)hf.success());
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)2L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                Assert.assertEquals((Object)"world.200402.3x5400x2700.tiff", (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
                f = (SimpleFeature)fi.next();
                String expected = "../singleHarvest2/world.200405.3x5400x2700.tiff".replace('/', File.separatorChar);
                Assert.assertEquals((Object)expected, (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2004-05-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
            }
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testHarvestSpatial() throws Exception {
        File source = URLs.urlToFile((URL)this.rgbURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "rgbHarvest1");
        File directory2 = new File(testDataDir, "rgbHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("rgb.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("global_mosaic_[^0].*"), null)) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory2, file.getName())));
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GeneralEnvelope singleGranuleEnvelope = reader.getOriginalEnvelope();
        for (File file : directory2.listFiles()) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory1, file.getName())));
        }
        reader.harvest(null, (Object)directory1, null);
        GeneralEnvelope fullEnvelope = reader.getOriginalEnvelope();
        Assert.assertTrue((boolean)fullEnvelope.contains((Envelope)singleGranuleEnvelope, true));
        Assert.assertTrue((fullEnvelope.getSpan(0) > singleGranuleEnvelope.getSpan(0) ? 1 : 0) != 0);
        Assert.assertTrue((fullEnvelope.getSpan(1) > singleGranuleEnvelope.getSpan(1) ? 1 : 0) != 0);
        MathTransform mt = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        Envelope2D env = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 10.0, 40.0, 15.0, 45.0);
        GridEnvelope2D rasterEnvelope = new GridEnvelope2D(new Envelope2D((Envelope)CRS.transform((MathTransform)mt.inverse(), (Envelope)env)), PixelInCell.CELL_CORNER);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)rasterEnvelope, (Envelope)env);
        ParameterValue ggParameter = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        ggParameter.setValue((Object)gg);
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{ggParameter});
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        GranuleStore store = (GranuleStore)reader.getGranules(null, false);
        store.removeGranules(ECQL.toFilter((String)"location = 'global_mosaic_19.png' OR location = 'global_mosaic_14.png' OR location = 'global_mosaic_9.png' OR location = 'global_mosaic_4.png'"));
        GeneralEnvelope reducedEnvelope = reader.getOriginalEnvelope();
        Assert.assertTrue((boolean)fullEnvelope.contains((Envelope)reducedEnvelope, true));
        Assert.assertTrue((boolean)reducedEnvelope.contains((Envelope)singleGranuleEnvelope, true));
        Assert.assertTrue((fullEnvelope.getSpan(0) > reducedEnvelope.getSpan(0) ? 1 : 0) != 0);
        Assert.assertEquals((double)fullEnvelope.getSpan(1), (double)reducedEnvelope.getSpan(1), (double)0.0);
        reader.dispose();
    }

    @Test
    public void testHarvestSpatialTwoReaders() throws Exception {
        File source = URLs.urlToFile((URL)this.rgbURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "rgbHarvest1_tr");
        File directory2 = new File(testDataDir, "rgbHarvest2_tr");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("rgb.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("global_mosaic_[^0].*"), null)) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory2, file.getName())));
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        ImageMosaicReader reader2 = TestUtils.getReader(harvestSingleURL, format);
        for (File file : directory2.listFiles()) {
            Assert.assertTrue((boolean)file.renameTo(new File(directory1, file.getName())));
        }
        reader.harvest(null, (Object)directory1, null);
        MathTransform mt = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        Envelope2D env = new Envelope2D((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, 10.0, 40.0, 15.0, 45.0);
        GridEnvelope2D rasterEnvelope = new GridEnvelope2D(new Envelope2D((Envelope)CRS.transform((MathTransform)mt.inverse(), (Envelope)env)), PixelInCell.CELL_CORNER);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)rasterEnvelope, (Envelope)env);
        ParameterValue ggParameter = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        ggParameter.setValue((Object)gg);
        GridCoverage2D coverage = reader2.read(new GeneralParameterValue[]{ggParameter});
        Assert.assertNotNull((Object)coverage);
        coverage.dispose(true);
        reader.dispose();
        reader2.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestSingleFileRGBA() throws Exception {
        File source = URLs.urlToFile((URL)this.rgbAURLTiff);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "singleHarvestRGBA1");
        File directory2 = new File(testDataDir, "singleHarvestRGBA2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("rgba.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        String fileNameToMove = "passA2006128211927.tiff";
        File monthFive = new File(directory1, fileNameToMove);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        File renamed = new File(directory2, fileNameToMove);
        Assert.assertTrue((boolean)monthFive.renameTo(renamed));
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            List summary = reader.harvest(null, (Object)renamed, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertEquals((Object)renamed.getCanonicalFile(), (Object)((File)hf.getSource()).getCanonicalFile());
            Assert.assertTrue((boolean)hf.success());
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)2L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                Assert.assertEquals((Object)"passA2006128194218.tiff", (Object)f.getAttribute("location"));
                f = (SimpleFeature)fi.next();
                String expected = "../singleHarvestRGBA2/passA2006128211927.tiff".replace('/', File.separatorChar);
                Assert.assertEquals((Object)expected, (Object)f.getAttribute("location"));
            }
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testRenamedMosaicGranuleSource() throws Exception {
        File source = URLs.urlToFile((URL)this.rgbAURLTiff);
        File testDataDir = TestData.file((Object)this, (String)".");
        File mosaicDirectory = new File(testDataDir, "singleHarvestRGBA1");
        File storageDirectory = new File(testDataDir, "singleHarvestRGBA2");
        if (mosaicDirectory.exists()) {
            FileUtils.deleteDirectory((File)mosaicDirectory);
        }
        FileUtils.copyDirectory((File)source, (File)mosaicDirectory);
        for (File file : FileUtils.listFiles((File)mosaicDirectory, (IOFileFilter)new RegexFileFilter("rgba.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        Properties indexer = new Properties();
        indexer.put("Name", "rgba");
        indexer.put("TypeName", "theTable");
        try (FileOutputStream fos = new FileOutputStream(new File(mosaicDirectory, "indexer.properties"));){
            indexer.store(fos, null);
        }
        try (FileWriter out = new FileWriter(new File(mosaicDirectory, "/datastore.properties"));){
            out.write("database=imagemosaicremove\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        String fileNameToMove = "passA2006128211927.tiff";
        File monthFive = new File(mosaicDirectory, fileNameToMove);
        if (storageDirectory.exists()) {
            FileUtils.deleteDirectory((File)storageDirectory);
        }
        storageDirectory.mkdirs();
        File renamed = new File(storageDirectory, fileNameToMove);
        Assert.assertTrue((boolean)monthFive.renameTo(renamed));
        URL harvestSingleURL = URLs.fileToUrl((File)mosaicDirectory);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleSource gs = reader.getGranules("rgba", true);
        Assert.assertEquals((Object)"rgba", (Object)gs.getSchema().getTypeName());
        SimpleFeatureCollection features = gs.getGranules(new Query("rgba"));
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
        Assert.assertEquals((Object)"rgba", (Object)first.getType().getTypeName());
        Query q = new Query("rgba");
        q.setPropertyNames(new String[]{"location"});
        features = gs.getGranules(q);
        first = (SimpleFeature)DataUtilities.first((FeatureCollection)features);
        Assert.assertEquals((Object)"rgba", (Object)first.getType().getTypeName());
        Assert.assertEquals((long)1L, (long)first.getAttributes().size());
        reader.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestMultipleFiles() throws Exception {
        MultipleHarvestSetup multipleHarvestSetup = new MultipleHarvestSetup().invoke();
        Collection<File> files = multipleHarvestSetup.getFiles();
        ImageMosaicReader reader = multipleHarvestSetup.getReader();
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            this.assertMultipleFileHarvest(files, reader, originalCatalog);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestMultipleFilesOnStoredProperties() throws Exception {
        MultipleHarvestSetup multipleHarvestSetup = new MultipleHarvestSetup().invoke();
        Collection<File> files = multipleHarvestSetup.getFiles();
        multipleHarvestSetup.getReader().dispose();
        ImageMosaicReader reader = multipleHarvestSetup.getReader();
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            this.assertMultipleFileHarvest(files, reader, originalCatalog);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestMultipleFilesWithoutCRS() throws Exception {
        MultipleHarvestSetup multipleHarvestSetup = new MultipleHarvestSetup().invoke();
        Collection<File> files = multipleHarvestSetup.getFiles();
        ImageMosaicReader tempReader = multipleHarvestSetup.getReader();
        File directory = URLs.urlToFile((URL)((URL)tempReader.getSource()));
        tempReader.dispose();
        File config = new File(directory, directory.getName() + ".properties");
        Properties p = new Properties();
        try (FileInputStream fis = new FileInputStream(config);){
            p.load(fis);
        }
        p.remove("MosaicCRS");
        try (FileOutputStream fos = new FileOutputStream(config);){
            p.store(fos, null);
        }
        ImageMosaicReader reader = multipleHarvestSetup.getReader();
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            this.assertMultipleFileHarvest(files, reader, originalCatalog);
        }
        finally {
            reader.dispose();
        }
    }

    public void assertMultipleFileHarvest(Collection<File> files, ImageMosaicReader reader, GranuleCatalog originalCatalog) throws IOException {
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
        List summary = reader.harvest(null, files, null);
        Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
        Assert.assertEquals((long)2L, (long)summary.size());
        for (HarvestedSource hf : summary) {
            Assert.assertTrue((boolean)hf.success());
        }
        Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
        metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-03-01T00:00:00.000Z,2004-04-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestPalette() throws Exception {
        File source = URLs.urlToFile((URL)this.index2URL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "mosaic");
        File directory2 = new File(testDataDir, "singleHarvest");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"c"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        FileUtils.copyDirectory((File)source, (File)directory2);
        for (File file : FileUtils.listFiles((File)directory2, (IOFileFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"c")), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL, null);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            ArrayList<File> files = new ArrayList<File>();
            for (File file : FileUtils.listFiles((File)directory2, (IOFileFilter)FileFilterUtils.prefixFileFilter((String)"c"), null)) {
                files.add(file);
            }
            List summary = reader.harvest(null, files, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertTrue((boolean)hf.success());
            RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
            Assert.assertNotNull((Object)manager.defaultPalette);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestDirectory() throws Exception {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "harvest1");
        File directory2 = new File(testDataDir, "harvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("world\\.20040[^25].*\\.tiff"), null)) {
            File renamed = new File(directory2, file.getName());
            Assert.assertTrue((boolean)file.renameTo(renamed));
        }
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            List summary = reader.harvest(null, (Object)directory2, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)2L, (long)summary.size());
            for (HarvestedSource hf : summary) {
                Assert.assertTrue((boolean)hf.success());
            }
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-03-01T00:00:00.000Z,2004-04-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestListSingleDirectory() throws Exception {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "harvest1");
        File directory2 = new File(testDataDir, "harvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("world\\.20040[^25].*\\.tiff"), null)) {
            File renamed = new File(directory2, file.getName());
            Assert.assertTrue((boolean)file.renameTo(renamed));
        }
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        ArrayList<File> files = new ArrayList<File>();
        files.add(directory2);
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            this.assertMultipleFileHarvest(files, reader, originalCatalog);
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testHarvestListSingleFileRelative() throws Exception {
        Function<File, String> expectedLocation1 = d -> "world.200402.3x5400x2700.tiff";
        Function<File, String> expectedLocation2 = d -> "../singleHarvest2/world.200405.3x5400x2700.tiff".replace('/', File.separatorChar);
        Consumer<File> mosaicDirSetup = dir -> {};
        this.checkSingleFileHarvest(mosaicDirSetup, expectedLocation1, expectedLocation2);
    }

    @Test
    public void testHarvestListSingleFileAbsoluteLegacy() throws Exception {
        Function<File, String> expectedLocation1 = d -> new File((File)d, "world.200402.3x5400x2700.tiff").getAbsolutePath();
        Function<File, String> expectedLocation2 = d -> {
            File pf = d.getParentFile();
            return new File(pf, "singleHarvest2/world.200405.3x5400x2700.tiff").getAbsolutePath();
        };
        Consumer<File> mosaicDirSetup = dir -> {
            File indexer = new File((File)dir, "indexer.properties");
            try {
                Object indexerContents = FileUtils.readFileToString((File)indexer, (String)"UTF-8");
                indexerContents = (String)indexerContents + "AbsolutePath=true\n";
                FileUtils.writeStringToFile((File)indexer, (String)indexerContents, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.checkSingleFileHarvest(mosaicDirSetup, expectedLocation1, expectedLocation2);
    }

    @Test
    public void testHarvestListSingleFileAbsolutePathType() throws Exception {
        Function<File, String> expectedLocation1 = d -> new File((File)d, "world.200402.3x5400x2700.tiff").getAbsolutePath();
        Function<File, String> expectedLocation2 = d -> new File(d.getParentFile(), "singleHarvest2/world.200405.3x5400x2700.tiff").getAbsolutePath();
        Consumer<File> mosaicDirSetup = dir -> {
            File indexer = new File((File)dir, "indexer.properties");
            try {
                Object indexerContents = FileUtils.readFileToString((File)indexer, (String)"UTF-8");
                indexerContents = (String)indexerContents + "PathType=ABSOLUTE\n";
                FileUtils.writeStringToFile((File)indexer, (String)indexerContents, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        this.checkSingleFileHarvest(mosaicDirSetup, expectedLocation1, expectedLocation2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkSingleFileHarvest(Consumer<File> mosaicDirSetup, Function<File, String> expectedLocation1, Function<File, String> expectedLocation2) throws IOException, FactoryException {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "singleHarvest1");
        File directory2 = new File(testDataDir, "singleHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("world\\.20040[^25].*\\.tiff"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        String monthFiveName = "world.200405.3x5400x2700.tiff";
        File monthFive = new File(directory1, monthFiveName);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        File renamed = new File(directory2, monthFiveName);
        Assert.assertTrue((boolean)monthFive.renameTo(renamed));
        mosaicDirSetup.accept(directory1);
        ArrayList<File> files = new ArrayList<File>();
        files.add(renamed);
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            List summary = reader.harvest(null, files, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertEquals((Object)renamed.getCanonicalFile(), (Object)((File)hf.getSource()).getCanonicalFile());
            Assert.assertTrue((boolean)hf.success());
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)2L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                Assert.assertEquals((Object)expectedLocation1.apply(directory1), (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
                f = (SimpleFeature)fi.next();
                Assert.assertEquals((Object)expectedLocation2.apply(directory2), (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2004-05-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
            }
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveCoverageNoDelete() throws Exception {
        String referenceDir = "testRemove";
        File workDir = new File(TestData.file((Object)this, (String)"."), "testRemove");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "watertemp.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)zipFile);
        TestData.unzipFile((Object)this, (String)"testRemove/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"testRemove");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "testRemove/datastore.properties"));){
            out.write("database=imagemosaicremove\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        try {
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            File[] files = workDir.listFiles();
            Assert.assertNotNull((Object)files);
            Assert.assertEquals((long)16L, (long)files.length);
            reader.removeCoverage(reader.getGridCoverageNames()[0], false);
            Assert.assertEquals((long)0L, (long)reader.getGridCoverageNames().length);
            Assert.assertEquals((long)16L, (long)files.length);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoveCoverageDelete() throws Exception {
        String referenceDir = "testRemove2";
        File workDir = new File(TestData.file((Object)this, (String)"."), "testRemove2");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "watertemp.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)zipFile);
        TestData.unzipFile((Object)this, (String)"testRemove2/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"testRemove2");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "testRemove2/datastore.properties"));){
            out.write("database=imagemosaicremove2\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        try {
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            File[] files = workDir.listFiles();
            Assert.assertNotNull((Object)files);
            Assert.assertEquals((long)16L, (long)files.length);
            reader.removeCoverage(reader.getGridCoverageNames()[0], true);
            Assert.assertEquals((long)0L, (long)reader.getGridCoverageNames().length);
            files = workDir.listFiles();
            Assert.assertEquals((long)12L, (long)files.length);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderDeleteAll() throws Exception {
        String referenceDir = "testRemove3";
        File workDir = new File(TestData.file((Object)this, (String)"."), "testRemove3");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "watertemp.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)zipFile);
        TestData.unzipFile((Object)this, (String)"testRemove3/watertemp.zip");
        FileUtils.deleteQuietly((File)new File(String.valueOf(workDir) + "/watertemp.zip"));
        URL timeElevURL = TestData.url((Object)this, (String)"testRemove3");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "testRemove3/datastore.properties"));){
            out.write("database=imagemosaicremove3\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = null;
        try {
            reader = new ImageMosaicReader((Object)timeElevURL);
            File[] files = workDir.listFiles();
            Assert.assertEquals((long)15L, (long)files.length);
            reader.delete(true);
            files = workDir.listFiles();
            Assert.assertEquals((long)0L, (long)files.length);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReaderDeleteNoGranules() throws Exception {
        String referenceDir = "testRemove4";
        File workDir = new File(TestData.file((Object)this, (String)"."), "testRemove4");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "watertemp.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)zipFile);
        TestData.unzipFile((Object)this, (String)"testRemove4/watertemp.zip");
        FileUtils.deleteQuietly((File)new File(String.valueOf(workDir) + "/watertemp.zip"));
        URL timeElevURL = TestData.url((Object)this, (String)"testRemove4");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "testRemove4/datastore.properties"));){
            out.write("database=imagemosaicremove4\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = null;
        try {
            reader = new ImageMosaicReader((Object)timeElevURL);
            Assert.assertNotNull((Object)reader);
            File[] files = workDir.listFiles();
            Assert.assertEquals((long)15L, (long)files.length);
            reader.delete(false);
            files = workDir.listFiles();
            Assert.assertEquals((long)4L, (long)files.length);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestError() throws Exception {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory = new File(testDataDir, "harvest-error");
        if (directory.exists()) {
            FileUtils.deleteDirectory((File)directory);
        }
        FileUtils.copyDirectory((File)source, (File)directory);
        for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)new RegexFileFilter("world\\.20040[^2].*\\.tiff"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        for (File file : FileUtils.listFiles((File)directory, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        URL harvestSingleURL = URLs.fileToUrl((File)directory);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            File bogus = new File(directory, "test.tiff");
            Assert.assertTrue((boolean)bogus.createNewFile());
            List summary = reader.harvest(null, (Object)bogus, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertFalse((boolean)hf.success());
            Assert.assertEquals((Object)"test.tiff", (Object)((File)hf.getSource()).getName());
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestWithExternalMosaicDir() throws Exception {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "externalindex");
        File directory2 = new File(testDataDir, "singleHarvest2");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("world\\.20040[^25].*\\.tiff"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        String indexerPath = directory1.getCanonicalPath() + "/indexer.properties";
        String path = directory1.getCanonicalPath();
        path = path.replace("\\", "/");
        Properties prop = new Properties();
        try (FileInputStream stream = new FileInputStream(indexerPath);){
            prop.load(stream);
        }
        try (FileOutputStream outStream = new FileOutputStream(indexerPath);){
            prop.setProperty("RootMosaicDirectory", path);
            prop.store(outStream, null);
        }
        String monthFiveName = "world.200405.3x5400x2700.tiff";
        File monthFive = new File(directory1, monthFiveName);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        File renamed = new File(directory2, monthFiveName);
        Assert.assertTrue((boolean)monthFive.renameTo(renamed));
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        GranuleCatalog originalCatalog = reader.granuleCatalog;
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            List summary = reader.harvest(null, (Object)renamed, null);
            Assert.assertSame((Object)originalCatalog, (Object)reader.granuleCatalog);
            Assert.assertEquals((long)1L, (long)summary.size());
            HarvestedSource hf = (HarvestedSource)summary.get(0);
            Assert.assertEquals((Object)renamed.getCanonicalFile(), (Object)((File)hf.getSource()).getCanonicalFile());
            Assert.assertTrue((boolean)hf.success());
            Assert.assertEquals((long)1L, (long)reader.getGridCoverageNames().length);
            metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            String coverageName = reader.getGridCoverageNames()[0];
            GranuleSource granules = reader.getGranules(coverageName, true);
            Assert.assertEquals((long)2L, (long)granules.getCount(Query.ALL));
            Query q = new Query(Query.ALL);
            try (SimpleFeatureIterator fi = granules.getGranules(q).features();){
                Assert.assertTrue((boolean)fi.hasNext());
                SimpleFeature f = (SimpleFeature)fi.next();
                Assert.assertEquals((Object)"world.200402.3x5400x2700.tiff", (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
                f = (SimpleFeature)fi.next();
                String expected = "../singleHarvest2/world.200405.3x5400x2700.tiff".replace('/', File.separatorChar);
                Assert.assertEquals((Object)expected, (Object)f.getAttribute("location"));
                Assert.assertEquals((Object)"2004-05-01T00:00:00.000Z", (Object)ConvertersHack.convert((Object)f.getAttribute("time"), String.class));
            }
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSetupExternalMosaicDir() throws Exception {
        File source = URLs.urlToFile((URL)this.timeURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File data = new File(testDataDir, "externaldata");
        File mosaic = new File(testDataDir, "mosaicexternal");
        if (data.exists()) {
            FileUtils.deleteDirectory((File)data);
        }
        FileUtils.copyDirectory((File)source, (File)data);
        if (mosaic.exists()) {
            FileUtils.deleteDirectory((File)mosaic);
        }
        mosaic.mkdirs();
        for (File file : FileUtils.listFiles((File)data, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        for (File file : FileUtils.listFiles((File)data, (IOFileFilter)new RegexFileFilter(".*\\.properties"), null)) {
            File moved = new File(mosaic, file.getName());
            Assert.assertTrue((boolean)file.renameTo(moved));
        }
        File indexer = new File(mosaic, "indexer.properties");
        Properties prop = new Properties();
        try (FileInputStream stream = new FileInputStream(indexer);){
            prop.load(stream);
        }
        try (FileOutputStream outStream = new FileOutputStream(indexer);){
            prop.setProperty("IndexingDirectories", data.getCanonicalPath());
            prop.store(outStream, null);
        }
        URL mosaicURL = URLs.fileToUrl((File)mosaic);
        AbstractGridFormat format = TestUtils.getFormat(mosaicURL);
        ImageMosaicReader reader = TestUtils.getReader(mosaicURL, format);
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            Assert.assertEquals((long)13L, (long)metadataNames.length);
            Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
            Assert.assertEquals((Object)"2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
            Assert.assertEquals((Object)"2004-02-01T00:00:00.000Z,2004-03-01T00:00:00.000Z,2004-04-01T00:00:00.000Z,2004-05-01T00:00:00.000Z", (Object)reader.getMetadataValue(metadataNames[0]));
            Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    @Ignore
    public void oracle() throws Exception {
        File workDir = TestData.file((Object)this, (String)"wattemp");
        AbstractGridFormat format = TestUtils.getFormat(workDir.toURI().toURL());
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(workDir.toURI().toURL(), format);
        Assert.assertNotNull((Object)format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)19L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        Assert.assertNotNull((Object)timeMetadata);
        Assert.assertEquals((long)2L, (long)timeMetadata.split(",").length);
        Assert.assertEquals((Object)timeMetadata.split(",")[0], (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)timeMetadata.split(",")[1], (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.util.Date", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DAT_DOMAIN"));
        Assert.assertEquals((Object)"20081031T0000000,20081101T0000000", (Object)reader.getMetadataValue("DAT_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.String", (Object)reader.getMetadataValue("DAT_DOMAIN_DATATYPE"));
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_ELEVATION_DOMAIN"));
        Assert.assertEquals((Object)"false", (Object)reader.getMetadataValue("HAS_XX_DOMAIN"));
        Assert.assertEquals((Object)"20,100", (Object)reader.getMetadataValue("DEPTH_DOMAIN"));
        Assert.assertEquals((Object)"java.lang.Integer", (Object)reader.getMetadataValue("DEPTH_DOMAIN_DATATYPE"));
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        Date date = sdf.parse("2008-10-31T00:00:00.000Z");
        timeValues.add(date);
        time.setValue(timeValues);
        ParameterValue direct = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        direct.setValue(false);
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        ParameterValue dateValue = null;
        ParameterValue depthValue = null;
        String selectedWaveLength = "020";
        String selectedDate = "20081031T0000000";
        Set params = reader.getDynamicParameters();
        for (ParameterDescriptor param : params) {
            if (param.getName().getCode().equalsIgnoreCase("DAT")) {
                dateValue = param.createValue();
                dateValue.setValue((Object)new ArrayList<String>(){
                    {
                        this.add("20081031T0000000");
                    }
                });
                continue;
            }
            if (!param.getName().getCode().equalsIgnoreCase("DEPTH")) continue;
            depthValue = param.createValue();
            depthValue.setValue((Object)new ArrayList<String>(){
                {
                    this.add("020");
                }
            });
        }
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{gg, bkg, direct, depthValue, dateValue}, "oracle Test");
        reader.dispose();
    }

    @Test
    public void testExistingSchema() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "water_temp4");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"water_temp4/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"water_temp4");
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/water_temp4/indexer.properties"), true);){
            out.write("UseExistingSchema=true\n");
            out.flush();
        }
        File sampleImage = new File(TestData.file((Object)this, (String)"."), "/water_temp4/sample_image.dat");
        Assert.assertTrue((boolean)sampleImage.exists());
        sampleImage.delete();
        File mosaicProperties = new File(TestData.file((Object)this, (String)"."), "/water_temp4/water_temp4.properties");
        Assert.assertTrue((boolean)mosaicProperties.exists());
        mosaicProperties.delete();
        format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        Assert.assertTrue((boolean)sampleImage.exists());
        Assert.assertTrue((boolean)mosaicProperties.exists());
        reader.dispose();
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"water_temp4"));
        }
    }

    @Test
    public void testUserProvidedName() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "water_temp5");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"water_temp5/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"water_temp5");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/water_temp5/indexer.properties"), true);){
            out.write("Name=test\n");
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        File sampleImage = new File(TestData.file((Object)this, (String)"."), "/water_temp5/sample_image.dat");
        File mosaicProperties = new File(TestData.file((Object)this, (String)"."), "/water_temp5/test.properties");
        Assert.assertTrue((boolean)sampleImage.exists());
        Assert.assertTrue((boolean)mosaicProperties.exists());
        reader.dispose();
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"water_temp5"));
        }
    }

    @Test
    @Ignore
    public void testExistingOracleSchema() throws Exception {
        String folder = "mosaictemp";
        String zipFile = "mosaictemp.zip";
        File workDir = new File(TestData.file((Object)this, (String)"."), "mosaictemp");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"mosaictemp.zip"), (File)new File(workDir, "mosaictemp.zip"));
        TestData.unzipFile((Object)this, (String)("mosaictemp" + File.separatorChar + "mosaictemp.zip"));
        URL timeElevURL = URLs.fileToUrl((File)workDir);
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        reader.dispose();
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "mosaictemp" + File.separatorChar + "indexer.properties"), true);){
            out.write("UseExistingSchema=true\n");
            out.flush();
        }
        File sampleImage = new File(TestData.file((Object)this, (String)"."), "mosaictemp" + File.separatorChar + "sample_image.dat");
        File mosaicProperties = new File(TestData.file((Object)this, (String)"."), "mosaictemp" + File.separatorChar + "mosaictemp.properties");
        format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        Assert.assertTrue((boolean)sampleImage.exists());
        Assert.assertTrue((boolean)mosaicProperties.exists());
        reader.dispose();
        if (!INTERACTIVE) {
            FileUtils.deleteDirectory((File)TestData.file((Object)this, (String)"mosaictemp"));
        }
    }

    @Test
    public void testPAMAuxiliaryFiles() throws Exception {
        URL timePamURL = TestData.url((Object)this, (String)"pam");
        AbstractGridFormat format = TestUtils.getFormat(timePamURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timePamURL, format);
        Assert.assertNotNull((Object)format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        ParameterValue time = ImageMosaicFormat.TIME.createValue();
        ArrayList<Date> timeValues = new ArrayList<Date>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.sss'Z'");
        sdf.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = sdf.parse("2008-10-31T00:00:00.000Z");
        timeValues.add(date);
        time.setValue(timeValues);
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{time});
        Object object = coverage.getProperty("PamDataset");
        ImageMosaicReaderTest.checkPAMDataset(object, 73.0352, 84.3132);
        reader.dispose();
    }

    @Test
    public void testPAMMerged() throws Exception {
        URL timePamURL = TestData.url((Object)this, (String)"pam");
        AbstractGridFormat format = TestUtils.getFormat(timePamURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timePamURL, format);
        Assert.assertNotNull((Object)format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        GridCoverage2D coverage = reader.read(null);
        Object object = coverage.getProperty("PamDataset");
        ImageMosaicReaderTest.checkPAMDataset(object, 72.6912, 83.2542);
        reader.dispose();
    }

    @Test
    public void testPAMInternalMerged() throws Exception {
        URL timePamURL = TestData.url((Object)this, (String)"pam-internal");
        AbstractGridFormat format = TestUtils.getFormat(timePamURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timePamURL, format);
        Assert.assertNotNull((Object)format);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        GridCoverage2D coverage = reader.read(null);
        Object object = coverage.getProperty("PamDataset");
        ImageMosaicReaderTest.checkPAMDataset(object, 72.6912, 83.2542);
        reader.dispose();
    }

    private static void checkPAMDataset(Object object, double mean, double stddev) {
        Assert.assertNotNull((Object)object);
        Assert.assertTrue((boolean)(object instanceof PAMDataset));
        PAMDataset dataset = (PAMDataset)object;
        PAMDataset.PAMRasterBand band = (PAMDataset.PAMRasterBand)dataset.getPAMRasterBand().get(0);
        PAMParser parser = PAMParser.getInstance();
        Assert.assertEquals((double)0.0, (double)Double.parseDouble(parser.getMetadataValue(band, "STATISTICS_MINIMUM")), (double)1.0E-4);
        Assert.assertEquals((double)255.0, (double)Double.parseDouble(parser.getMetadataValue(band, "STATISTICS_MAXIMUM")), (double)1.0E-4);
        Assert.assertEquals((double)mean, (double)Double.parseDouble(parser.getMetadataValue(band, "STATISTICS_MEAN")), (double)1.0E-4);
        Assert.assertEquals((double)stddev, (double)Double.parseDouble(parser.getMetadataValue(band, "STATISTICS_STDDEV")), (double)1.0E-4);
    }

    @Test
    public void testStopCreationWhileWalkingMosaicDir() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "stop-it");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)new File(workDir, "watertemp.zip"));
        TestData.unzipFile((Object)this, (String)"stop-it/watertemp.zip");
        URL timeElevURL = TestData.url((Object)this, (String)"stop-it");
        try (FileWriter out = new FileWriter(new File(TestData.file((Object)this, (String)"."), "/stop-it/datastore.properties"));){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(timeElevURL);
        Assert.assertNotNull((Object)format);
        ImageMosaicReader reader = TestUtils.getReader(timeElevURL, format);
        Assert.assertNotNull((Object)reader);
        String[] metadataNames = reader.getMetadataNames();
        Assert.assertNotNull((Object)metadataNames);
        Assert.assertEquals((long)13L, (long)metadataNames.length);
        Assert.assertEquals((Object)"true", (Object)reader.getMetadataValue("HAS_TIME_DOMAIN"));
        String timeMetadata = reader.getMetadataValue("TIME_DOMAIN");
        Assert.assertNotNull((Object)timeMetadata);
        Assert.assertEquals((long)2L, (long)timeMetadata.split(",").length);
        Assert.assertEquals((Object)timeMetadata.split(",")[0], (Object)reader.getMetadataValue("TIME_DOMAIN_MINIMUM"));
        Assert.assertEquals((Object)timeMetadata.split(",")[1], (Object)reader.getMetadataValue("TIME_DOMAIN_MAXIMUM"));
        Assert.assertEquals((Object)"java.sql.Timestamp", (Object)reader.getMetadataValue("TIME_DOMAIN_DATATYPE"));
        reader.dispose();
        File mosaicFile = new File(TestData.file((Object)this, (String)"."), "/stop-it/stop-it.properties");
        mosaicFile.delete();
        File sampleImageFile = new File(TestData.file((Object)this, (String)"."), "/stop-it/sample_image.dat");
        sampleImageFile.delete();
        reader = (ImageMosaicReader)format.getReader((Object)timeElevURL);
        Assert.assertNull((Object)reader);
    }

    @Test
    public void testExpandToRGB() throws Exception {
        URL testURL = TestData.url((Object)this, (String)"index_palette/");
        Assert.assertNotNull((Object)testURL);
        File currentDir = URLs.urlToFile((URL)testURL);
        AbstractGridFormat format = TestUtils.getFormat(testURL);
        ImageMosaicReader reader = TestUtils.getReader(testURL, format);
        GridCoverage2D coverage = reader.read(null);
        Assert.assertTrue((boolean)(coverage.getRenderedImage().getColorModel() instanceof IndexColorModel));
        File props = new File(currentDir, "index_palette.properties");
        Assert.assertTrue((props.exists() && props.canRead() && props.canWrite() ? 1 : 0) != 0);
        String properties = FileUtils.readFileToString((File)props, (String)"UTF-8");
        Assert.assertTrue((boolean)properties.contains("ExpandToRGB"));
        properties = properties.replace("ExpandToRGB=false", "ExpandToRGB=true");
        FileUtils.write((File)props, (CharSequence)properties, (String)"UTF-8", (boolean)false);
        reader = TestUtils.getReader(testURL, format);
        coverage = reader.read(null);
        Assert.assertTrue((boolean)(coverage.getRenderedImage().getColorModel() instanceof ComponentColorModel));
        IOFileFilter prefixFileFilter = FileFilterUtils.prefixFileFilter((String)"index_palette");
        IOFileFilter nameFileFilter = FileFilterUtils.nameFileFilter((String)"sample_image.dat");
        IOFileFilter ff = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{prefixFileFilter, nameFileFilter});
        File[] listFiles = currentDir.listFiles((FileFilter)ff);
        if (listFiles != null && listFiles.length > 0) {
            for (File f : listFiles) {
                FileUtils.deleteQuietly((File)f);
            }
        }
        reader.dispose();
    }

    @Test
    public void testExpandToRGBBandSelection() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "index_palette_bandselect");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File mosaicSource = TestData.file((Object)this, (String)"index_palette");
        FileUtils.copyDirectory((File)mosaicSource, (File)workDir);
        URL testURL = URLs.fileToUrl((File)workDir);
        AbstractGridFormat format = TestUtils.getFormat(testURL);
        ImageMosaicReader reader = TestUtils.getReader(testURL, format);
        reader.dispose();
        File props = new File(workDir, "index_palette_bandselect.properties");
        Assert.assertTrue((props.exists() && props.canRead() && props.canWrite() ? 1 : 0) != 0);
        String properties = FileUtils.readFileToString((File)props, (String)"UTF-8");
        Assert.assertTrue((boolean)properties.contains("ExpandToRGB"));
        properties = properties.replace("ExpandToRGB=false", "ExpandToRGB=true");
        FileUtils.write((File)props, (CharSequence)properties, (String)"UTF-8", (boolean)false);
        reader = TestUtils.getReader(testURL, format);
        ParameterValue selectedBands = AbstractGridFormat.BANDS.createValue();
        selectedBands.setValue((Object)new int[]{2});
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{selectedBands}, null);
        RenderedImage ri = coverage.getRenderedImage();
        Assert.assertTrue((boolean)(ri.getColorModel() instanceof ComponentColorModel));
        Assert.assertEquals((long)1L, (long)ri.getSampleModel().getNumBands());
        reader.dispose();
    }

    @Test
    public void testSameCRS() throws Exception {
        String strangeWGS84 = "PROJCS[\"Google Mercator\",   GEOGCS[\"WGS 84\",     DATUM[\"World Geodetic System 1984\",       SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],       AUTHORITY[\"EPSG\",\"6326\"]],     PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],     UNIT[\"degree\", 0.017453292519943295],     AXIS[\"Geodetic latitude\", NORTH],     AXIS[\"Geodetic longitude\", EAST],     AUTHORITY[\"EPSG\",\"4326\"]],   PROJECTION[\"Mercator (1SP)\", AUTHORITY[\"EPSG\",\"9804\"]],   PARAMETER[\"semi_major\", 6378137.0],   PARAMETER[\"semi_minor\", 6378137.0],   PARAMETER[\"latitude_of_origin\", 0.0],   PARAMETER[\"central_meridian\", 0.0],   PARAMETER[\"scale_factor\", 1.0],   PARAMETER[\"false_easting\", 0.0],   PARAMETER[\"false_northing\", 0.0],   UNIT[\"m\", 1.0],   AXIS[\"Easting\", EAST],   AXIS[\"Northing\", NORTH],   AUTHORITY[\"EPSG\",\"900913\"]]";
        URL testURL = TestData.url((Object)this, (String)"same_crs/");
        Assert.assertNotNull((Object)testURL);
        AbstractGridFormat format = TestUtils.getFormat(testURL, null);
        Assert.assertNotNull((Object)format);
        Assert.assertFalse((boolean)(format instanceof UnknownFormat));
        ImageMosaicReader reader = TestUtils.getReader(testURL, format);
        GeneralEnvelope targetBBOX = new GeneralEnvelope((Envelope)reader.getOriginalEnvelope());
        targetBBOX.setCoordinateReferenceSystem(CRS.parseWKT((String)"PROJCS[\"Google Mercator\",   GEOGCS[\"WGS 84\",     DATUM[\"World Geodetic System 1984\",       SPHEROID[\"WGS 84\", 6378137.0, 298.257223563, AUTHORITY[\"EPSG\",\"7030\"]],       AUTHORITY[\"EPSG\",\"6326\"]],     PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]],     UNIT[\"degree\", 0.017453292519943295],     AXIS[\"Geodetic latitude\", NORTH],     AXIS[\"Geodetic longitude\", EAST],     AUTHORITY[\"EPSG\",\"4326\"]],   PROJECTION[\"Mercator (1SP)\", AUTHORITY[\"EPSG\",\"9804\"]],   PARAMETER[\"semi_major\", 6378137.0],   PARAMETER[\"semi_minor\", 6378137.0],   PARAMETER[\"latitude_of_origin\", 0.0],   PARAMETER[\"central_meridian\", 0.0],   PARAMETER[\"scale_factor\", 1.0],   PARAMETER[\"false_easting\", 0.0],   PARAMETER[\"false_northing\", 0.0],   UNIT[\"m\", 1.0],   AXIS[\"Easting\", EAST],   AXIS[\"Northing\", NORTH],   AUTHORITY[\"EPSG\",\"900913\"]]"));
        ParameterValue readGG = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        readGG.setValue((Object)new GridGeometry2D(reader.getOriginalGridRange(), (Envelope)targetBBOX));
        TestUtils.checkCoverage(reader, new GeneralParameterValue[]{readGG}, "Test Same CRS");
        reader.dispose();
    }

    @Test
    public void externalOverviews() throws Exception {
        File workDir = new File(TestData.file((Object)this, (String)"."), "mosaic-ext-ovr");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        FileUtils.copyDirectory((File)TestData.file((Object)this, (String)"ext-overview"), (File)workDir);
        URL dirURL = URLs.fileToUrl((File)workDir);
        AbstractGridFormat format = TestUtils.getFormat(dirURL);
        ImageMosaicReader reader = TestUtils.getReader(dirURL, format);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        Dimension dim = new Dimension();
        dim.setSize((double)reader.getOriginalGridRange().getSpan(0) / 2.0, (double)reader.getOriginalGridRange().getSpan(1) / 2.0);
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        rasterArea.setSize(dim);
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        GeneralParameterValue[] values = new GeneralParameterValue[]{gg, useJai, tileSize};
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, values, "external overviews test");
        Object fileLocation = coverage.getProperty("OriginalFileSource");
        Assert.assertNotNull((Object)fileLocation);
        Assert.assertTrue((boolean)(fileLocation instanceof String));
        String path = (String)fileLocation;
        Assert.assertFalse((boolean)path.isEmpty());
        Assert.assertTrue((boolean)path.endsWith(".ovr"));
        reader.dispose();
    }

    @Test
    public void testInitFromExistingStore() throws Exception {
        File testMosaic = new File(TestData.file((Object)this, (String)"."), "existingStore");
        if (testMosaic.exists()) {
            FileUtils.deleteDirectory((File)testMosaic);
        }
        File mosaicSource = TestData.file((Object)this, (String)"rgb");
        FileUtils.copyDirectory((File)mosaicSource, (File)testMosaic);
        this.cleanConfigurationFiles(testMosaic, "rgb");
        URL testMosaicUrl = URLs.fileToUrl((File)testMosaic);
        File dataStoreProperties = new File(testMosaic, "datastore.properties");
        try (FileWriter out = new FileWriter(dataStoreProperties);){
            out.write("database=imagemosaic\n");
            out.write(H2_SAMPLE_PROPERTIES);
            out.flush();
        }
        AbstractGridFormat format = TestUtils.getFormat(testMosaicUrl);
        ImageMosaicReader reader = TestUtils.getReader(testMosaicUrl, format);
        reader.dispose();
        this.cleanConfigurationFiles(testMosaic, "existingStore");
        Properties h2Connection = new Properties();
        try (FileReader fr = new FileReader(dataStoreProperties);){
            h2Connection.load(fr);
        }
        h2Connection.put("database", new File(testMosaic, "imagemosaic").getCanonicalPath());
        JDBCDataStore store = (JDBCDataStore)DataStoreFinder.getDataStore((Map)DataUtilities.toConnectionParameters((Properties)h2Connection));
        try (Connection c = store.getConnection(Transaction.AUTO_COMMIT);
             Statement st = c.createStatement();){
            st.execute("ALTER TABLE \"existingStore\" RENAME TO \"testMosaic\"");
            st.execute("UPDATE GEOMETRY_COLUMNS SET F_TABLE_NAME = 'testMosaic'");
        }
        store.dispose();
        Properties indexer = new Properties();
        indexer.put("UseExistingSchema", "true");
        indexer.put("TypeName", "testMosaic");
        try (FileOutputStream fos = new FileOutputStream(new File(testMosaic, "indexer.properties"));){
            indexer.store(fos, null);
        }
        ImageMosaicReader reader2 = TestUtils.getReader(testMosaicUrl, format);
        GridCoverage2D coverage = reader2.read(null);
        coverage.dispose(true);
        reader2.dispose();
    }

    @Test
    public void testMixedSampleModels() throws Exception {
        File mosaicFolder = URLs.urlToFile((URL)this.mixedSampleModelURL);
        this.cleanConfigurationFiles(mosaicFolder, mosaicFolder.getName());
        AbstractGridFormat format = TestUtils.getFormat(this.mixedSampleModelURL);
        ImageMosaicReader reader = TestUtils.getReader(this.mixedSampleModelURL, format);
        GridCoverage2D coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        RenderedImage ri = coverage.getRenderedImage();
        MatcherAssert.assertThat((Object)ri.getSampleModel(), (Matcher)CoreMatchers.instanceOf(ComponentSampleModel.class));
        MatcherAssert.assertThat((Object)ri.getColorModel(), (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
        File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/mixed-mosaic.png");
        ImageAssert.assertEquals((File)sample, (RenderedImage)ri, (int)100);
        coverage.dispose(true);
        this.checkColorModel(IndexColorModel.class, 1, 0, new ReferencedEnvelope(10.0, 10.1, 43.0, 43.1, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(IndexColorModel.class, 1, 0, new ReferencedEnvelope(13.5, 13.6, 43.5, 43.6, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 1, 0, new ReferencedEnvelope(8.0, 8.1, 45.5, 45.6, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 1, 1, new ReferencedEnvelope(10.5, 10.6, 45.5, 45.6, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 3, 0, new ReferencedEnvelope(13.5, 13.6, 45.5, 45.6, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 1, 1, new ReferencedEnvelope(8.0, 10.0, 45.0, 46.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 3, 0, new ReferencedEnvelope(7.0, 8.0, 43.0, 45.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 3, 0, new ReferencedEnvelope(11.0, 13.0, 45.0, 46.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 3, 0, new ReferencedEnvelope(10.0, 11.0, 43.0, 45.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        this.checkColorModel(ComponentColorModel.class, 3, 0, new ReferencedEnvelope(7.0, 11.0, 43.0, 44.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84), reader);
        reader.dispose();
    }

    @Test
    public void testCoverageOnBands() throws Exception {
        File mosaicFolder = URLs.urlToFile((URL)this.coverageBandsURL);
        for (File configFile : mosaicFolder.listFiles((FileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"db"), FileFilterUtils.suffixFileFilter((String)"sample_image.dat"), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".properties"), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.nameFileFilter((String)"indexer.properties"), FileFilterUtils.nameFileFilter((String)"datastore.properties")}))})}))) {
            configFile.delete();
        }
        AbstractGridFormat format = TestUtils.getFormat(this.coverageBandsURL);
        ImageMosaicReader reader = TestUtils.getReader(this.coverageBandsURL, format);
        this.testMultiCoverages(reader);
        reader.dispose();
        format = TestUtils.getFormat(this.coverageBandsURL);
        reader = TestUtils.getReader(this.coverageBandsURL, format);
        this.testMultiCoverages(reader);
        reader.dispose();
    }

    @Test
    public void testHeterogeneousConfigs() throws Exception {
        File mosaicFolder = URLs.urlToFile((URL)this.coverageBands2URL);
        for (File configFile : mosaicFolder.listFiles((FileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"db"), FileFilterUtils.suffixFileFilter((String)"sample_image.dat"), FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".properties"), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.nameFileFilter((String)"indexer.properties"), FileFilterUtils.nameFileFilter((String)"datastore.properties")}))})}))) {
            configFile.delete();
        }
        AbstractGridFormat format = TestUtils.getFormat(this.coverageBands2URL);
        ImageMosaicReader reader = TestUtils.getReader(this.coverageBands2URL, format);
        reader.read("rgb", null);
        reader.dispose();
    }

    private void testMultiCoverages(ImageMosaicReader reader) throws IOException {
        Object[] coverageNames = reader.getGridCoverageNames();
        Arrays.sort(coverageNames);
        Assert.assertNotNull((Object)coverageNames);
        int coverageCount = coverageNames.length;
        Assert.assertEquals((long)2L, (long)coverageCount);
        String[] expectedNames = new String[]{"gray", "rgb"};
        int[] expectedTypes = new int[]{6, 5};
        for (int i = 0; i < coverageCount; ++i) {
            Object coverageName = coverageNames[i];
            Assert.assertEquals((Object)expectedNames[i], (Object)coverageName);
            GridCoverage2D coverage = reader.read((String)coverageNames[i], null);
            Assert.assertNotNull((Object)coverage);
            RenderedImage ri = coverage.getRenderedImage();
            MatcherAssert.assertThat((Object)ri.getSampleModel(), (Matcher)CoreMatchers.instanceOf(ComponentSampleModel.class));
            ColorModel cm = ri.getColorModel();
            MatcherAssert.assertThat((Object)cm, (Matcher)CoreMatchers.instanceOf(ComponentColorModel.class));
            Assert.assertEquals((long)expectedTypes[i], (long)cm.getColorSpace().getType());
        }
    }

    private void checkColorModel(Class<? extends ColorModel> clazz, int bands, int dataType, ReferencedEnvelope box, ImageMosaicReader reader) throws NoninvertibleTransformException, TransformException, IOException {
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        MathTransform mt = reader.getOriginalGridToWorld(PixelInCell.CELL_CORNER);
        GeneralEnvelope ge = CRS.transform((MathTransform)mt.inverse(), (Envelope)box);
        GridEnvelope2D range = new GridEnvelope2D(new Envelope2D((Envelope)ge), PixelInCell.CELL_CENTER);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, mt, box.getCoordinateReferenceSystem()));
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{gg});
        RenderedImage ri = coverage.getRenderedImage();
        MatcherAssert.assertThat((Object)ri.getColorModel(), (Matcher)CoreMatchers.instanceOf(clazz));
        Assert.assertEquals((long)bands, (long)ri.getSampleModel().getNumBands());
        Assert.assertEquals((long)dataType, (long)ri.getSampleModel().getDataType());
        coverage.dispose(true);
    }

    private void cleanConfigurationFiles(File testMosaic, String mosaicName) {
        new File(testMosaic, "sample_image.dat").delete();
        for (File configFile : testMosaic.listFiles((FileFilter)FileFilterUtils.prefixFileFilter((String)mosaicName))) {
            configFile.delete();
        }
    }

    @AfterClass
    public static void close() {
        System.clearProperty("org.geotools.referencing.forceXY");
        CRS.reset((String)"all");
    }

    @Test
    public void testEmptyShapefileMosaic() throws Exception {
        File testMosaic = TestData.file((Object)this, (String)"/empty_mosaic/empty_mosaic.shp");
        Assert.assertTrue((boolean)testMosaic.exists());
        ImageMosaicReader reader = new ImageMosaicFormat().getReader((Object)testMosaic);
        reader.granuleCatalog.removeGranules(new Query("empty_mosaic", (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
        reader.dispose();
        reader = new ImageMosaicFormat().getReader((Object)testMosaic);
        RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
        Assert.assertTrue((boolean)manager.spatialDomainManager.coverageBBox.isEmpty());
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{gg});
        Assert.assertNull((Object)coverage);
        coverage = reader.read(null);
        Assert.assertNull((Object)coverage);
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Envelope2D env = new Envelope2D(reader.getCoordinateReferenceSystem(), 0.0, 0.0, 1000.0, 1000.0);
        GridGeometry2D gg2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 100, 100), (Envelope)env);
        gg.setValue((Object)gg2D);
        coverage = reader.read(new GeneralParameterValue[]{bkg, gg, useJai, tileSize});
        Assert.assertNull((Object)coverage);
        SimpleFeatureType granuleType = reader.granuleCatalog.getType(reader.granuleCatalog.getTypeNames()[0]);
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureBuilder sFB = new SimpleFeatureBuilder(granuleType);
        SimpleFeature f = sFB.buildFeature(null);
        f.setAttribute("location", (Object)"addedGranule.tif");
        LinearRing shell = gf.createLinearRing(new Coordinate[]{new Coordinate(0.0, 0.0), new Coordinate(0.0, 5903.0), new Coordinate(5662.0, 5903.0), new Coordinate(5662.0, 0.0), new Coordinate(0.0, 0.0)});
        f.setDefaultGeometry((Object)gf.createPolygon(shell));
        LinkedList<SimpleFeature> granules = new LinkedList<SimpleFeature>();
        granules.add(f);
        reader.granuleCatalog.addGranules("empty_mosaic", granules, null);
        manager.initialize(false);
        Assert.assertFalse((boolean)manager.spatialDomainManager.coverageBBox.isEmpty());
        coverage = reader.read(null);
        Assert.assertNotNull((Object)coverage);
        Assert.assertNotNull((Object)coverage.getRenderedImage());
        coverage.dispose(true);
        coverage = reader.read(new GeneralParameterValue[]{bkg, gg, useJai, tileSize});
        Assert.assertNotNull((Object)coverage);
        Assert.assertNotNull((Object)coverage.getRenderedImage());
        coverage.dispose(true);
        reader.granuleCatalog.removeGranules(new Query("empty_mosaic", (Filter)Filter.INCLUDE), Transaction.AUTO_COMMIT);
        manager.initialize(false);
        Assert.assertTrue((boolean)manager.spatialDomainManager.coverageBBox.isEmpty());
        coverage = reader.read(null);
        Assert.assertNull((Object)coverage);
        coverage = reader.read(new GeneralParameterValue[]{bkg, gg, useJai, tileSize});
        Assert.assertNull((Object)coverage);
        reader.dispose();
    }

    @Test
    public void testEmptyShapefileMosaicWithCaching() throws Exception {
        File testMosaic = TestData.file((Object)this, (String)"/empty_mosaic/empty_mosaic_with_caching.shp");
        Assert.assertTrue((boolean)testMosaic.exists());
        ImageMosaicReader reader = new ImageMosaicFormat().getReader((Object)testMosaic);
        RasterManager manager = reader.getRasterManager(reader.getGridCoverageNames()[0]);
        Assert.assertTrue((boolean)manager.spatialDomainManager.coverageBBox.isEmpty());
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        GridEnvelope2D rasterArea = (GridEnvelope2D)reader.getOriginalGridRange();
        GridEnvelope2D range = new GridEnvelope2D((Rectangle)rasterArea);
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)range, (Envelope)envelope));
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{gg});
        Assert.assertNull((Object)coverage);
        coverage = reader.read(null);
        Assert.assertNull((Object)coverage);
        ParameterValue useJai = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        useJai.setValue(false);
        ParameterValue tileSize = AbstractGridFormat.SUGGESTED_TILE_SIZE.createValue();
        tileSize.setValue((Object)"128,128");
        ParameterValue bkg = ImageMosaicFormat.BACKGROUND_VALUES.createValue();
        bkg.setValue((Object)new double[]{-9999.0});
        gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        Envelope2D env = new Envelope2D(reader.getCoordinateReferenceSystem(), 0.0, 0.0, 1000.0, 1000.0);
        GridGeometry2D gg2D = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 100, 100), (Envelope)env);
        gg.setValue((Object)gg2D);
        coverage = reader.read(new GeneralParameterValue[]{bkg, gg, useJai, tileSize});
        Assert.assertNull((Object)coverage);
        reader.dispose();
    }

    @Test
    public void testIgnoreInvalidGranule() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, this.rgbURL, "poisoned");
        URL poisonedURL = URLs.fileToUrl((File)directory);
        AbstractGridFormat format = TestUtils.getFormat(poisonedURL);
        ImageMosaicReader reader = TestUtils.getReader(poisonedURL, format);
        GranuleStore granules = (GranuleStore)reader.getGranules(reader.getGridCoverageNames()[0], false);
        SimpleFeature first = (SimpleFeature)DataUtilities.first((FeatureCollection)granules.getGranules(Query.ALL));
        first.setAttribute("location", (Object)"global_mosaic_11-invalid.png");
        try (DefaultTransaction t = new DefaultTransaction();){
            granules.setTransaction((Transaction)t);
            granules.addGranules(DataUtilities.collection((SimpleFeature)first));
            t.commit();
        }
        TestUtils.checkCoverage(reader, new GeneralParameterValue[0], "Ignore invalid granule");
    }

    @Test
    public void testReadSingleGranule() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(this.rgbURL, format);
        double EPS = 1.0E-6;
        ReferencedEnvelope re = new ReferencedEnvelope(9.242875600000001, 12.1395792, 42.5511679, 44.5709689, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        ParameterValue gg = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        gg.setValue((Object)new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 50, 50), (Envelope)re));
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{gg});
        RenderedImage ri = coverage.getRenderedImage();
        Assert.assertEquals((long)1L, (long)this.getSourceGranules(ri));
        reader.dispose();
    }

    private int getSourceGranules(RenderedImage ri) {
        if (ri instanceof RenderedOp) {
            RenderedOp ro = (RenderedOp)ri;
            if (ro.getOperationName().startsWith("ImageRead")) {
                return 1;
            }
            int count = 0;
            for (int i = 0; i < ro.getNumSources(); ++i) {
                count += this.getSourceGranules((RenderedImage)((RenderedOp)ri).getSourceImage(i));
            }
            return count;
        }
        return 1;
    }

    @Test
    public void testGIFSupportFiles() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.indexURL);
        ImageMosaicReader reader = TestUtils.getReader(this.indexURL, format);
        ResourceInfo info = reader.getInfo(reader.getGridCoverageNames()[0]);
        Assert.assertTrue((boolean)(info instanceof FileResourceInfo));
        FileResourceInfo fileInfo = (FileResourceInfo)info;
        try (CloseableIterator files = fileInfo.getFiles(null);){
            File myFile;
            ArrayList<FileGroupProvider.FileGroup> fileGroups = new ArrayList<FileGroupProvider.FileGroup>();
            HashSet<File> mainFiles = new HashSet<File>();
            HashSet supportFiles = new HashSet();
            while (files.hasNext()) {
                FileGroupProvider.FileGroup group = (FileGroupProvider.FileGroup)files.next();
                fileGroups.add(group);
                mainFiles.add(group.getMainFile());
                supportFiles.addAll(group.getSupportFiles());
            }
            Assert.assertEquals((long)3L, (long)fileGroups.size());
            Assert.assertEquals((long)3L, (long)mainFiles.size());
            Assert.assertEquals((long)6L, (long)supportFiles.size());
            File dir = URLs.urlToFile((URL)this.indexURL);
            String[] mainFilesPaths = dir.list((FilenameFilter)FileFilterUtils.suffixFileFilter((String)".gif"));
            String[] supportFilesPaths = dir.list((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".prj"), FileFilterUtils.suffixFileFilter((String)".wld")}), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"index"))}));
            for (String filePath : mainFilesPaths) {
                myFile = new File(dir, filePath);
                Assert.assertTrue((boolean)mainFiles.contains(myFile));
            }
            for (String filePath : supportFilesPaths) {
                myFile = new File(dir, filePath);
                Assert.assertTrue((boolean)supportFiles.contains(myFile));
            }
        }
        reader.dispose();
    }

    @Test
    public void testOverviewSupportFiles() throws Exception {
        File overviewDir = TestData.file((Object)this, (String)"ext-overview");
        URL overviewURL = URLs.fileToUrl((File)overviewDir);
        AbstractGridFormat format = TestUtils.getFormat(overviewURL);
        ImageMosaicReader reader = TestUtils.getReader(overviewURL, format);
        ResourceInfo info = reader.getInfo(reader.getGridCoverageNames()[0]);
        Assert.assertTrue((boolean)(info instanceof FileResourceInfo));
        FileResourceInfo fileInfo = (FileResourceInfo)info;
        try (CloseableIterator files = fileInfo.getFiles(null);){
            File myFile;
            ArrayList<FileGroupProvider.FileGroup> fileGroups = new ArrayList<FileGroupProvider.FileGroup>();
            HashSet<File> mainFiles = new HashSet<File>();
            HashSet supportFiles = new HashSet();
            while (files.hasNext()) {
                FileGroupProvider.FileGroup group = (FileGroupProvider.FileGroup)files.next();
                fileGroups.add(group);
                mainFiles.add(group.getMainFile());
                supportFiles.addAll(group.getSupportFiles());
            }
            Assert.assertEquals((long)2L, (long)fileGroups.size());
            Assert.assertEquals((long)2L, (long)mainFiles.size());
            Assert.assertEquals((long)2L, (long)supportFiles.size());
            File dir = URLs.urlToFile((URL)overviewURL);
            String[] mainFilesPaths = dir.list((FilenameFilter)FileFilterUtils.suffixFileFilter((String)".tif"));
            String[] supportFilesPaths = dir.list((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)".ovr")}), FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.prefixFileFilter((String)"index"))}));
            for (String filePath : mainFilesPaths) {
                myFile = new File(dir, filePath);
                Assert.assertTrue((boolean)mainFiles.contains(myFile));
            }
            for (String filePath : supportFilesPaths) {
                myFile = new File(dir, filePath);
                Assert.assertTrue((boolean)supportFiles.contains(myFile));
            }
        }
        reader.dispose();
    }

    @Test
    public void testBandsSelection() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(this.rgbURL, format);
        ParameterValue selectedBands = AbstractGridFormat.BANDS.createValue();
        selectedBands.setValue((Object)new int[]{2, 0, 1, 0, 1});
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{selectedBands}, null);
        SampleModel sampleModel = coverage.getRenderedImage().getSampleModel();
        MatcherAssert.assertThat((Object)sampleModel.getNumBands(), (Matcher)CoreMatchers.is((Object)5));
        reader.dispose();
    }

    @Test
    public void testFilteredGranuleFootprint() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(this.rgbURL, format);
        ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
        filter.setValue((Object)ECQL.toFilter((String)"location = 'global_mosaic_16.png'"));
        GridCoverage2D coverage = TestUtils.checkCoverage(reader, new GeneralParameterValue[]{filter}, null);
        File file = new File(URLs.urlToFile((URL)this.rgbURL), "global_mosaic_16.png");
        URL granuleUrl = URLs.fileToUrl((File)file);
        AbstractGridFormat granuleFormat = TestUtils.getFormat(granuleUrl);
        AbstractGridCoverage2DReader granuleReader = granuleFormat.getReader((Object)granuleUrl);
        GridCoverage2D expected = granuleReader.read(null);
        Envelope expectedEnvelope = expected.getEnvelope();
        Envelope actualEnvelope = coverage.getEnvelope();
        double EPS = 1.0E-6;
        Assert.assertEquals((double)expectedEnvelope.getMinimum(0), (double)actualEnvelope.getMinimum(0), (double)1.0E-6);
        Assert.assertEquals((double)expectedEnvelope.getMinimum(1), (double)actualEnvelope.getMinimum(1), (double)1.0E-6);
        Assert.assertEquals((double)expectedEnvelope.getMaximum(0), (double)actualEnvelope.getMaximum(0), (double)1.0E-6);
        Assert.assertEquals((double)expectedEnvelope.getMaximum(1), (double)actualEnvelope.getMaximum(1), (double)1.0E-6);
        reader.dispose();
    }

    @Test
    public void testFilteredNoResults() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbURL);
        ImageMosaicReader reader = TestUtils.getReader(this.rgbURL, format);
        ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
        filter.setValue((Object)ECQL.toFilter((String)"location = 'abcdefghi'"));
        GridCoverage2D coverage = TestUtils.getCoverage(reader, new GeneralParameterValue[]{filter}, false);
        Assert.assertNull((Object)coverage);
        reader.dispose();
    }

    @Test
    public void testSortOnCachedCatalogDescending() throws Exception {
        File timeCached = this.setupTimeCachedMosaic();
        BufferedImage expected = ImageIO.read(new File(timeCached, "world.200405.3x5400x2700.tiff"));
        ParameterValue sortBy = ImageMosaicFormat.SORT_BY.createValue();
        sortBy.setValue((Object)"time D");
        ImageMosaicReader reader = new ImageMosaicReader((Object)timeCached);
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{sortBy});
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)coverage.getRenderedImage(), (int)0);
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void testSortOnCachedCatalogAscending() throws Exception {
        File timeCached = this.setupTimeCachedMosaic();
        BufferedImage expected = ImageIO.read(new File(timeCached, "world.200402.3x5400x2700.tiff"));
        ParameterValue sortBy = ImageMosaicFormat.SORT_BY.createValue();
        sortBy.setValue((Object)"time A");
        ImageMosaicReader reader = new ImageMosaicReader((Object)timeCached);
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{sortBy});
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)coverage.getRenderedImage(), (int)0);
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void testSortOnCachedCatalogAscendingFiltered() throws Exception {
        File timeCached = this.setupTimeCachedMosaic();
        BufferedImage expected = ImageIO.read(new File(timeCached, "world.200403.3x5400x2700.tiff"));
        ParameterValue sortBy = ImageMosaicFormat.SORT_BY.createValue();
        sortBy.setValue((Object)"time A");
        ParameterValue filter = ImageMosaicFormat.FILTER.createValue();
        filter.setValue((Object)ECQL.toFilter((String)"time during 2004-02-28T23:59:59/2004-05-01T00:00:00"));
        ImageMosaicReader reader = new ImageMosaicReader((Object)timeCached);
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{sortBy, filter});
        ImageAssert.assertEquals((RenderedImage)expected, (RenderedImage)coverage.getRenderedImage(), (int)0);
        coverage.dispose(true);
        reader.dispose();
    }

    private File setupTimeCachedMosaic() throws IOException, FactoryException {
        File source = URLs.urlToFile((URL)this.timeURL);
        File timeCached = this.tempFolder.newFolder("timeCached");
        FileUtils.copyDirectory((File)source, (File)timeCached);
        Arrays.stream(timeCached.listFiles((dir, name) -> name.startsWith("time_geotiff") || "sample_image".equals(name))).forEach(f -> f.delete());
        ImageMosaicReader reader = TestUtils.getReader(timeCached);
        reader.dispose();
        File indexerProperties = new File(timeCached, "timeCached.properties");
        Properties indexer = new Properties();
        try (FileInputStream is = new FileInputStream(indexerProperties);){
            indexer.load(is);
        }
        indexer.put("Caching", "true");
        try (FileOutputStream os = new FileOutputStream(indexerProperties);){
            indexer.store(os, null);
        }
        return timeCached;
    }

    @Test
    public void testMaintainNoData() throws Exception {
        String testLocation = "hetero_utm_footprint";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        File testDirectory = new File("./target", "keep_nodata");
        FileUtils.copyDirectory((File)testDataFolder, (File)testDirectory);
        Stream.of(testDirectory.listFiles()).filter(f -> f.getName().endsWith(".wkt")).forEach(f -> f.delete());
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDirectory, null);
        Assert.assertNotNull((Object)imReader);
        ParameterValue deferredLoading = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        deferredLoading.setValue(true);
        GridCoverage2D coverageDeferred = imReader.read(new GeneralParameterValue[]{deferredLoading});
        this.assertNoData(coverageDeferred, 0.0);
        deferredLoading.setValue(false);
        GridCoverage2D coverage = imReader.read(new GeneralParameterValue[]{deferredLoading});
        this.assertNoData(coverage, 0.0);
        imReader.dispose();
    }

    @Test
    public void testMaintainNoDataIdentity() throws Exception {
        String testLocation = "nodata";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        ImageMosaicReader imReader = new ImageMosaicReader((Object)testDataFolder, null);
        Assert.assertNotNull((Object)imReader);
        ParameterValue deferredLoading = AbstractGridFormat.USE_JAI_IMAGEREAD.createValue();
        deferredLoading.setValue(true);
        GridCoverage2D coverage = imReader.read(new GeneralParameterValue[]{deferredLoading});
        this.assertNoData(coverage, 7.0);
        imReader.dispose();
    }

    public void assertNoData(GridCoverage2D coverageDeferred, Double expectedNoData) {
        NoDataContainer noDataContainer = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverageDeferred);
        if (expectedNoData != null) {
            Assert.assertNotNull((Object)noDataContainer);
            Assert.assertEquals((double)expectedNoData, (double)noDataContainer.getAsSingleValue(), (double)0.0);
        } else {
            Assert.assertNull((Object)noDataContainer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHarvestWithExtraNonSpatialFile() throws Exception {
        File source = URLs.urlToFile((URL)this.rgbAURLTiff);
        File extras = URLs.urlToFile((URL)this.rgbaExtraURLTiff);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory = new File(testDataDir, "rgba_tiff_extra_test");
        if (directory.exists()) {
            FileUtils.deleteDirectory((File)directory);
        }
        FileUtils.copyDirectory((File)source, (File)directory);
        FileUtils.copyDirectory((File)extras, (File)directory);
        ImageMosaicReader reader = TestUtils.getReader(directory);
        try {
            String[] names = reader.getGridCoverageNames();
            Assert.assertEquals((long)1L, (long)names.length);
            Assert.assertEquals((Object)"passA", (Object)names[0]);
            CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
            CoordinateReferenceSystem expected = CRS.decode((String)"EPSG:4326", (boolean)true);
            Assert.assertTrue((boolean)CRS.equalsIgnoreMetadata((Object)expected, (Object)crs));
            GranuleSource passA = reader.getGranules("passA", true);
            UniqueVisitor visitor = new UniqueVisitor(new String[]{"location"});
            passA.getGranules(Query.ALL).accepts((FeatureVisitor)visitor, null);
            Set locations = visitor.getUnique();
            MatcherAssert.assertThat((Object)locations, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.equalTo((Object)"passA2006128211927.tiff")));
            MatcherAssert.assertThat((Object)locations, (Matcher)CoreMatchers.hasItem((Matcher)CoreMatchers.equalTo((Object)"passA2006128194218.tiff")));
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testNoDataRescaleStats() throws Exception {
        String testLocation = "nodata_high";
        URL storeUrl = TestData.url((Object)this, (String)testLocation);
        File testDataFolder = new File(storeUrl.toURI());
        ImageMosaicReader reader = new ImageMosaicReader((Object)testDataFolder, null);
        Assert.assertNotNull((Object)reader);
        GridGeometry2D gg = new GridGeometry2D((GridEnvelope)new GridEnvelope2D(0, 0, 1, 3), (Envelope)new ReferencedEnvelope(151.0, 152.0, 85.0, 88.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        ParameterValue ggValue = AbstractGridFormat.READ_GRIDGEOMETRY2D.createValue();
        ggValue.setValue((Object)gg);
        ParameterValue interpValue = AbstractGridFormat.INTERPOLATION.createValue();
        interpValue.setValue((Object)Interpolation.getInstance((int)1));
        GridCoverage2D coverage = reader.read(new GeneralParameterValue[]{ggValue, interpValue});
        NoDataContainer noData = (NoDataContainer)coverage.getProperty("GC_NODATA");
        Assert.assertEquals((double)9.96921E36f, (double)noData.getAsSingleValue(), (double)0.1);
        RenderedImage ri = coverage.getRenderedImage();
        Assert.assertEquals((long)1L, (long)ri.getWidth());
        Assert.assertEquals((long)3L, (long)ri.getHeight());
        float[] pixel = new float[1];
        ri.getData().getPixel(0, 0, pixel);
        Assert.assertEquals((double)9.96921E36f, (double)pixel[0], (double)0.1);
        ri.getData().getPixel(0, 1, pixel);
        Assert.assertEquals((double)311.92, (double)pixel[0], (double)0.1);
        ri.getData().getPixel(0, 2, pixel);
        Assert.assertEquals((double)311.77, (double)pixel[0], (double)0.1);
        coverage.dispose(true);
        reader.dispose();
    }

    @Test
    public void testGrayRGBAlpha() throws Exception {
        URL mosaicURL = TestData.url((Object)this, (String)"tiff_gray_rbg_alpha");
        AbstractGridFormat format = TestUtils.getFormat(mosaicURL);
        ImageMosaicReader reader = TestUtils.getReader(mosaicURL, format);
        Consumer<GridCoverage2D> verifier = c -> {
            RenderedImage renderedImage = c.getRenderedImage();
            SampleModel sampleModel = renderedImage.getSampleModel();
            ColorModel colorModel = renderedImage.getColorModel();
            MatcherAssert.assertThat((Object)sampleModel.getNumBands(), (Matcher)CoreMatchers.is((Object)4));
            MatcherAssert.assertThat((Object)colorModel.getNumComponents(), (Matcher)CoreMatchers.is((Object)4));
            MatcherAssert.assertThat((Object)colorModel.getTransparency(), (Matcher)CoreMatchers.is((Object)3));
            c.dispose(true);
        };
        ParameterValue ascending = ImageMosaicFormat.SORT_BY.createValue();
        ascending.setValue((Object)"location A");
        GridCoverage2D coverageA = reader.read(new GeneralParameterValue[]{ascending});
        verifier.accept(coverageA);
        ParameterValue descending = ImageMosaicFormat.SORT_BY.createValue();
        descending.setValue((Object)"location D");
        GridCoverage2D coverageD = reader.read(new GeneralParameterValue[]{descending});
        verifier.accept(coverageD);
        reader.dispose();
    }

    @Test
    public void testCleanUpMetadataOnlyWorldImage() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, this.rgbURL, "worldimage_clean_meta");
        ImageMosaicReader reader = TestUtils.getReader(directory);
        FileFilter fileFilter = f -> f.getName().startsWith("global_mosaic_1");
        FileFilter otherFileFilter = f -> !fileFilter.accept(f) && !f.getName().endsWith(".qix");
        Object[] existingFiles = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFiles, (Matcher)Matchers.arrayWithSize((int)33));
        TreeSet<File> otherFiles = new TreeSet<File>(Arrays.asList(directory.listFiles(otherFileFilter)));
        GranuleStore store = (GranuleStore)reader.getGranules(reader.getGridCoverageNames()[0], false);
        int removed = store.removeGranules((Filter)FF.like((Expression)FF.property("location"), "*global_mosaic_1*"));
        Assert.assertEquals((long)11L, (long)removed);
        Object[] existingFilesPastCleanup = directory.listFiles(fileFilter);
        Assert.assertArrayEquals((Object[])existingFiles, (Object[])existingFilesPastCleanup);
        MatcherAssert.assertThat(otherFiles, (Matcher)CoreMatchers.equalTo(new TreeSet<File>(Arrays.asList(directory.listFiles(otherFileFilter)))));
    }

    @Test
    public void testCleanUpMetadataAndDataWorldImage() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, this.rgbURL, "worldimage_clean_data");
        ImageMosaicReader reader = TestUtils.getReader(directory);
        FileFilter fileFilter = f -> f.getName().startsWith("global_mosaic_1");
        FileFilter otherFileFilter = f -> !fileFilter.accept(f) && !f.getName().endsWith(".qix");
        File[] existingFiles = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFiles, (Matcher)Matchers.arrayWithSize((int)33));
        int otherFilesCount = directory.listFiles(otherFileFilter).length;
        GranuleStore store = (GranuleStore)reader.getGranules(reader.getGridCoverageNames()[0], false);
        Hints hints = new Hints((RenderingHints.Key)Hints.GRANULE_REMOVAL_POLICY, (Object)GranuleRemovalPolicy.ALL);
        int removed = store.removeGranules((Filter)FF.like((Expression)FF.property("location"), "*global_mosaic_1*"), hints);
        Assert.assertEquals((long)11L, (long)removed);
        File[] existingFilesPastCleanup = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFilesPastCleanup, (Matcher)Matchers.emptyArray());
        Assert.assertEquals((long)otherFilesCount, (long)directory.listFiles(otherFileFilter).length);
    }

    @Test
    public void testCleanUpMetadataAndDataOverviews() throws Exception {
        URL hetero_s2_ovr = TestData.url((Object)this, (String)"hetero_s2_ovr");
        File directory = TestUtils.setupTestDirectory(this, hetero_s2_ovr, "hetero_s2_ovr_clean");
        ImageMosaicReader reader = TestUtils.getReader(directory);
        FileFilter fileFilter = f -> f.getName().startsWith("g1");
        FileFilter notFileFilter = f -> !fileFilter.accept(f) && !f.getName().endsWith(".qix");
        File[] existingFiles = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFiles, (Matcher)Matchers.arrayWithSize((int)2));
        int otherFilesCount = directory.listFiles(notFileFilter).length;
        GranuleStore store = (GranuleStore)reader.getGranules(reader.getGridCoverageNames()[0], false);
        Hints hints = new Hints((RenderingHints.Key)Hints.GRANULE_REMOVAL_POLICY, (Object)GranuleRemovalPolicy.ALL);
        int removed = store.removeGranules((Filter)FF.like((Expression)FF.property("location"), "*g1*"), hints);
        Assert.assertEquals((long)1L, (long)removed);
        File[] existingFilesPastCleanup = directory.listFiles(fileFilter);
        MatcherAssert.assertThat((Object)existingFilesPastCleanup, (Matcher)Matchers.emptyArray());
        Assert.assertEquals((long)otherFilesCount, (long)directory.listFiles(notFileFilter).length);
    }

    @Test
    @Ignore(value="Does not work due to limitations in ContentDataStore transaction handling, not even with rw locking")
    public void testConcurrentHarvestAndRemoveShapefile() throws Exception {
        this.checkConcurrentHarvestAndRemove(f -> {}, 20);
    }

    @Test
    public void testConcurrentHarvestAndRemoveH2() throws Exception {
        this.checkConcurrentHarvestAndRemove(f -> {
            try (FileWriter out = new FileWriter(new File((File)f, "datastore.properties"));){
                out.write("database=imagemosaic\n");
                out.write(H2_SAMPLE_PROPERTIES);
                out.flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }, 10);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkConcurrentHarvestAndRemove(Consumer<File> mosaicCustomizer, int loops) throws Exception {
        File source = URLs.urlToFile((URL)this.rgbURL);
        File testDataDir = TestData.file((Object)this, (String)".");
        File directory1 = new File(testDataDir, "harvest1-concurrent");
        File directory2 = new File(testDataDir, "harvest2-concurrent");
        if (directory1.exists()) {
            FileUtils.deleteDirectory((File)directory1);
        }
        FileUtils.copyDirectory((File)source, (File)directory1);
        if (directory2.exists()) {
            FileUtils.deleteDirectory((File)directory2);
        }
        directory2.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("global_mosaic_[^0].*"), null)) {
            File renamed = new File(directory2, file.getName());
            Assert.assertTrue((boolean)file.renameTo(renamed));
            if (!file.getName().endsWith("png")) continue;
            files.add(renamed);
        }
        for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("rgb.*"), null)) {
            Assert.assertTrue((boolean)file.delete());
        }
        mosaicCustomizer.accept(directory1);
        URL harvestSingleURL = URLs.fileToUrl((File)directory1);
        AbstractGridFormat format = TestUtils.getFormat(harvestSingleURL);
        ImageMosaicReader reader = TestUtils.getReader(harvestSingleURL, format);
        ExecutorService executor = Executors.newFixedThreadPool(2);
        try {
            String[] metadataNames = reader.getMetadataNames();
            Assert.assertNotNull((Object)metadataNames);
            String coverageName = reader.getGridCoverageNames()[0];
            ArrayList<Future<Integer>> futures = new ArrayList<Future<Integer>>();
            CountDownLatch latch = new CountDownLatch(1);
            for (File file : files) {
                PropertyIsLike propertyIsLike = FF.like((Expression)FF.property("location"), "*" + file.getName() + "*");
                Callable<Integer> callable = () -> ImageMosaicReaderTest.lambda$checkConcurrentHarvestAndRemove$24(latch, reader, coverageName, loops, (Filter)propertyIsLike, file);
                Future<Integer> future = executor.submit(callable);
                futures.add(future);
            }
            latch.countDown();
            boolean failed = false;
            for (Future future : futures) {
                try {
                    Integer removedCount = (Integer)future.get();
                    Assert.assertEquals((long)(loops - 1), (long)removedCount.intValue());
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, "Thread failed execution", e);
                    failed = true;
                }
            }
            Assert.assertFalse((String)"Terminating test due to previus failures", (boolean)failed);
            Assert.assertEquals((long)(files.size() + 1), (long)reader.getGranules(coverageName, true).getCount(Query.ALL));
        }
        finally {
            executor.shutdown();
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleOffsetEnabled() throws Exception {
        URL scaleOffsetURL = TestData.url((Object)this, (String)"scaleOffset");
        AbstractGridFormat format = TestUtils.getFormat(scaleOffsetURL);
        ImageMosaicReader reader = TestUtils.getReader(scaleOffsetURL, format);
        try {
            ParameterValue rescalePixels = AbstractGridFormat.RESCALE_PIXELS.createValue();
            rescalePixels.setValue(true);
            GridCoverage2D gc = reader.read(new GeneralParameterValue[]{rescalePixels});
            RenderedImage imScaled = gc.getRenderedImage();
            Assert.assertEquals((long)5L, (long)imScaled.getSampleModel().getDataType());
            double[] pixelDouble = new double[6];
            imScaled.getData().getPixel(0, 0, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{0.116, 0.116, 0.116, 0.0, 0.0, 1.0}, (double[])pixelDouble, (double)0.0);
            imScaled.getData().getPixel(19, 9, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{0.1957, 0.1957, 0.1957, 0.0, 0.0, 1.0}, (double[])pixelDouble, (double)0.0);
            gc.dispose(true);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleOffsetDisabled() throws Exception {
        URL scaleOffsetURL = TestData.url((Object)this, (String)"scaleOffset");
        AbstractGridFormat format = TestUtils.getFormat(scaleOffsetURL);
        ImageMosaicReader reader = TestUtils.getReader(scaleOffsetURL, format);
        try {
            ParameterValue rescalePixels = AbstractGridFormat.RESCALE_PIXELS.createValue();
            rescalePixels.setValue(false);
            GridCoverage2D gc = reader.read(new GeneralParameterValue[]{rescalePixels});
            RenderedImage imScaled = gc.getRenderedImage();
            Assert.assertEquals((long)3L, (long)imScaled.getSampleModel().getDataType());
            double[] pixelDouble = new double[6];
            imScaled.getData().getPixel(0, 0, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{1160.0, 1160.0, 1160.0, 0.0, 0.0, 10000.0}, (double[])pixelDouble, (double)0.0);
            imScaled.getData().getPixel(19, 9, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{1957.0, 1957.0, 1957.0, 0.0, 0.0, 10000.0}, (double[])pixelDouble, (double)0.0);
            gc.dispose(true);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testScaleOffsetEnabledWithBandSelection() throws Exception {
        URL scaleOffsetURL = TestData.url((Object)this, (String)"scaleOffset");
        AbstractGridFormat format = TestUtils.getFormat(scaleOffsetURL);
        ImageMosaicReader reader = TestUtils.getReader(scaleOffsetURL, format);
        try {
            ParameterValue rescalePixels = AbstractGridFormat.RESCALE_PIXELS.createValue();
            rescalePixels.setValue(true);
            ParameterValue bands = AbstractGridFormat.BANDS.createValue();
            bands.setValue((Object)new int[]{5});
            GridCoverage2D gc = reader.read(new GeneralParameterValue[]{rescalePixels, bands});
            RenderedImage imScaled = gc.getRenderedImage();
            Assert.assertEquals((long)5L, (long)imScaled.getSampleModel().getDataType());
            double[] pixelDouble = new double[1];
            imScaled.getData().getPixel(0, 0, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{1.0}, (double[])pixelDouble, (double)0.0);
            imScaled.getData().getPixel(19, 9, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{1.0}, (double[])pixelDouble, (double)0.0);
            bands.setValue((Object)new int[]{1, 4});
            gc = reader.read(new GeneralParameterValue[]{rescalePixels, bands});
            imScaled = gc.getRenderedImage();
            pixelDouble = new double[2];
            imScaled.getData().getPixel(0, 0, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{0.116, 0.0}, (double[])pixelDouble, (double)0.0);
            imScaled.getData().getPixel(19, 9, pixelDouble);
            Assert.assertArrayEquals((double[])new double[]{0.1957, 0.0}, (double[])pixelDouble, (double)0.0);
            gc.dispose(true);
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGranuleFileViewSidecars() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, this.rgbURL, "rbgFileView");
        ImageMosaicReader reader = TestUtils.getReader(directory);
        try {
            GranuleSource source = reader.getGranules(reader.getGridCoverageNames()[0], true);
            MatcherAssert.assertThat((Object)source.getSupportedHints(), (Matcher)CoreMatchers.hasItem((Object)GranuleSource.FILE_VIEW));
            Query q = new Query();
            q.setHints(new Hints((RenderingHints.Key)GranuleSource.FILE_VIEW, (Object)true));
            SimpleFeatureCollection granules = source.getGranules(q);
            SimpleFeatureType schema = (SimpleFeatureType)granules.getSchema();
            Assert.assertNull((Object)schema.getDescriptor("location"));
            Assert.assertEquals(Arrays.asList(schema.getGeometryDescriptor()), (Object)schema.getDescriptors());
            SimpleFeature first = null;
            SimpleFeature last = null;
            int count = 0;
            try (SimpleFeatureIterator it = granules.features();){
                while (it.hasNext()) {
                    ++count;
                    SimpleFeature next = (SimpleFeature)it.next();
                    if (first == null) {
                        first = next;
                    }
                    last = next;
                }
            }
            Assert.assertEquals((long)24L, (long)count);
            FileGroupProvider.FileGroup groupFirst = (FileGroupProvider.FileGroup)first.getUserData().get("GranuleFiles");
            Assert.assertNotNull((Object)groupFirst);
            MatcherAssert.assertThat((Object)groupFirst.getMainFile().getPath().toLowerCase(), (Matcher)CoreMatchers.endsWith((String)"global_mosaic_0.png"));
            MatcherAssert.assertThat(groupFirst.getSupportFiles().stream().map(f -> f.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)"global_mosaic_0.prj"), Matchers.equalToIgnoringCase((String)"global_mosaic_0.pgw")}));
            FileGroupProvider.FileGroup groupLast = (FileGroupProvider.FileGroup)last.getUserData().get("GranuleFiles");
            Assert.assertNotNull((Object)groupLast);
            MatcherAssert.assertThat((Object)groupLast.getMainFile().getPath().toLowerCase(), (Matcher)CoreMatchers.endsWith((String)"global_mosaic_9.png"));
            MatcherAssert.assertThat(groupLast.getSupportFiles().stream().map(f -> f.getName()).collect(Collectors.toList()), (Matcher)Matchers.containsInAnyOrder((Matcher[])new Matcher[]{Matchers.equalToIgnoringCase((String)"global_mosaic_9.prj"), Matchers.equalToIgnoringCase((String)"global_mosaic_9.pgw")}));
        }
        finally {
            reader.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testGranuleFileViewPreserveAttributes() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, this.timeAdditionalDomainsURL, "additionalDomainsFileView");
        ImageMosaicReader reader = TestUtils.getReader(directory);
        try {
            GranuleSource source = reader.getGranules(reader.getGridCoverageNames()[0], true);
            MatcherAssert.assertThat((Object)source.getSupportedHints(), (Matcher)CoreMatchers.hasItem((Object)GranuleSource.FILE_VIEW));
            Query q = new Query();
            q.setHints(new Hints((RenderingHints.Key)GranuleSource.FILE_VIEW, (Object)true));
            SimpleFeatureCollection granules = source.getGranules(q);
            SimpleFeatureType schema = (SimpleFeatureType)granules.getSchema();
            Assert.assertNull((Object)schema.getDescriptor("location"));
            Assert.assertNotNull((Object)schema.getDescriptor("the_geom"));
            Assert.assertNotNull((Object)schema.getDescriptor("time"));
            Assert.assertNotNull((Object)schema.getDescriptor("date"));
            Assert.assertNotNull((Object)schema.getDescriptor("depth"));
            SimpleFeature first = null;
            int count = 0;
            try (SimpleFeatureIterator it = granules.features();){
                while (it.hasNext()) {
                    ++count;
                    SimpleFeature next = (SimpleFeature)it.next();
                    if (first != null) continue;
                    first = next;
                }
            }
            Assert.assertEquals((long)4L, (long)count);
            Assert.assertEquals((Object)20, (Object)first.getAttribute("depth"));
            FileGroupProvider.FileGroup groupFirst = (FileGroupProvider.FileGroup)first.getUserData().get("GranuleFiles");
            Assert.assertNotNull((Object)groupFirst);
            MatcherAssert.assertThat((Object)groupFirst.getMainFile().getPath(), (Matcher)CoreMatchers.endsWith((String)"NCOM_wattemp_020_20081031T0000000_12.tiff"));
            MatcherAssert.assertThat((Object)groupFirst.getSupportFiles(), (Matcher)Matchers.nullValue());
        }
        finally {
            reader.dispose();
        }
    }

    @Test
    public void testWrongSuggestedFormat() throws IOException {
        File workDir = new File(TestData.file((Object)this, (String)"."), "testWrong");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdirs());
        }
        if (!(workDir = new File(workDir, "rgba")).mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdirs());
        }
        File source = TestData.file((Object)this, (String)"rgba");
        FileUtils.copyDirectory((File)source, (File)workDir);
        try (FileWriter out = new FileWriter(new File(workDir, "rgba.properties"), true);){
            out.write("SuggestedFormat=org.geotools.gce.arcgrid.ArcGridFormat");
            out.flush();
        }
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)workDir);
        GridCoverage2D gc = reader.read(null);
        Assert.assertNotNull((Object)gc);
        reader.dispose();
    }

    @Test
    public void testConcurrentMosaic() throws Exception {
        AbstractGridFormat format = TestUtils.getFormat(this.rgbURL);
        this.compareSequentialParallel(this.rgbURL, format);
    }

    @Test
    public void testConcurrentMosaicDanglingReference() throws Exception {
        File containerDir = new File("./target", "testConcurrentDangling");
        containerDir.mkdir();
        Assert.assertTrue((boolean)containerDir.isDirectory());
        File workDir = new File(containerDir, "rgb");
        if (workDir.isDirectory()) {
            FileUtils.deleteQuietly((File)workDir);
        }
        workDir.mkdir();
        Assert.assertTrue((boolean)workDir.isDirectory());
        File source = TestData.file((Object)this, (String)"rgb");
        FileUtils.copyDirectory((File)source, (File)workDir);
        ImageMosaicFormat format = new ImageMosaicFormat();
        format.getReader((Object)workDir).dispose();
        File shp = new File(workDir, "rgb.shp");
        ShapefileDataStore shpStore = new ShapefileDataStore(URLs.fileToUrl((File)shp));
        SimpleFeatureStore shpFeatures = (SimpleFeatureStore)shpStore.getFeatureSource();
        PropertyIsEqualTo f2f = FF.equal((Expression)FF.property("location"), (Expression)FF.literal((Object)"global_mosaic_2.png"), true);
        PropertyIsEqualTo f9f = FF.equal((Expression)FF.property("location"), (Expression)FF.literal((Object)"global_mosaic_9.png"), true);
        shpFeatures.modifyFeatures("location", (Object)"rgb_not_there.png", (Filter)FF.or((Filter)f2f, (Filter)f9f));
        shpStore.dispose();
        this.compareSequentialParallel(workDir, (AbstractGridFormat)format);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compareSequentialParallel(Object source, AbstractGridFormat format) throws IOException {
        ExecutorService es = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ImageMosaicReader mtReader = null;
        ImageMosaicReader reader = null;
        try {
            reader = (ImageMosaicReader)format.getReader(source);
            GridCoverage2D coverage = TestUtils.checkCoverage(reader, null, null);
            Hints hints = new Hints((RenderingHints.Key)Hints.EXECUTOR_SERVICE, (Object)es);
            mtReader = (ImageMosaicReader)format.getReader(source, hints);
            ParameterValue mtParam = ImageMosaicFormat.ALLOW_MULTITHREADING.createValue();
            mtParam.setValue(true);
            ParameterValue ioParam = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
            ioParam.setValue(false);
            GeneralParameterValue[] params = new GeneralParameterValue[]{mtParam, ioParam};
            GridCoverage2D mtCoverage = TestUtils.checkCoverage(mtReader, params, null);
            Assert.assertEquals((Object)coverage.getEnvelope2D(), (Object)mtCoverage.getEnvelope2D());
            ImageAssert.assertEquals((RenderedImage)coverage.getRenderedImage(), (RenderedImage)mtCoverage.getRenderedImage(), (int)0);
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
            if (mtReader != null) {
                mtReader.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSkipOverviews() throws IOException {
        String workDirName = "skipOverviews";
        File workDir = new File(TestData.file((Object)this, (String)"."), workDirName);
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            if (!workDir.mkdir()) {
                Assert.fail((String)("Unable to create workdir:" + String.valueOf(workDir)));
            }
        }
        File source = TestData.file((Object)this, (String)"rgba");
        FileUtils.copyDirectory((File)source, (File)workDir);
        for (File file : workDir.listFiles(f -> f.getName().startsWith("rgba."))) {
            file.delete();
        }
        try (FileWriter out = new FileWriter(new File(workDir, "indexer.properties"), true);){
            out.write("SkipExternalOverviews=true");
            out.flush();
        }
        ImageMosaicFormat format = new ImageMosaicFormat();
        ImageMosaicReader reader = format.getReader((Object)workDir);
        try {
            try (FileReader fr = new FileReader(new File(workDir, workDirName + ".properties"));){
                Properties p = new Properties();
                p.load(fr);
                Assert.assertEquals((Object)"true", (Object)p.getProperty("SkipExternalOverviews"));
            }
            RasterManager manager = (RasterManager)reader.rasterManagers.get(workDirName);
            manager.granuleCatalog.getGranuleDescriptors(new Query(workDirName), (granule, feature) -> Assert.assertTrue((boolean)granule.getMaskOverviewProvider().isSkipExternalLookup()));
        }
        finally {
            if (reader != null) {
                reader.dispose();
            }
        }
        ImageMosaicReader reader2 = format.getReader((Object)workDir);
        try {
            RasterManager manager = (RasterManager)reader2.rasterManagers.get(workDirName);
            manager.granuleCatalog.getGranuleDescriptors(new Query(workDirName), (granule, feature) -> Assert.assertTrue((boolean)granule.getMaskOverviewProvider().isSkipExternalLookup()));
        }
        finally {
            if (reader2 != null) {
                reader2.dispose();
            }
        }
    }

    @Test
    public void testMultilocation() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, TestData.url((Object)this, (String)"coverage_multilocation"), "multilocation");
        Properties prop = new Properties();
        prop.put("url", URLs.fileToUrl((File)new File(directory, "multilocation.shp")).toExternalForm());
        prop.put("SPI", ShapefileDataStoreFactory.class.getName());
        try (FileOutputStream fos = new FileOutputStream(new File(directory, "datastore.properties"));){
            prop.store(fos, null);
        }
        ImageMosaicReader reader = TestUtils.getReader(directory);
        MatcherAssert.assertThat(Arrays.asList(reader.getGridCoverageNames()), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"rgb", "gray"}));
        GridCoverage2D rgb = reader.read("rgb", null);
        MatcherAssert.assertThat((Object)((String)rgb.getProperty("OriginalFileSource")), (Matcher)CoreMatchers.endsWith((String)"rgb_sample.tif"));
        rgb.dispose(true);
        GridCoverage2D gray = reader.read("gray", null);
        MatcherAssert.assertThat((Object)((String)gray.getProperty("OriginalFileSource")), (Matcher)CoreMatchers.endsWith((String)"gray_sample.tif"));
        gray.dispose(true);
        reader.dispose();
    }

    @Test
    public void testMultiLocationCached() throws Exception {
        File directory = TestUtils.setupTestDirectory(this, TestData.url((Object)this, (String)"coverage_multilocation"), "multilocation");
        Properties prop = new Properties();
        prop.put("url", URLs.fileToUrl((File)new File(directory, "multilocation.shp")).toExternalForm());
        prop.put("SPI", ShapefileDataStoreFactory.class.getName());
        try (FileOutputStream fos = new FileOutputStream(new File(directory, "datastore.properties"));){
            prop.store(fos, null);
        }
        ParameterValue imageRead = ImageMosaicFormat.USE_JAI_IMAGEREAD.createValue();
        imageRead.setValue(false);
        GeneralParameterValue[] params = new GeneralParameterValue[]{imageRead};
        ImageMosaicReader reader = TestUtils.getReader(directory);
        GridCoverage2D rgb = reader.read("rgb", params);
        RenderedImage rgbNonCached = rgb.getRenderedImage();
        GridCoverage2D gray = reader.read("gray", params);
        RenderedImage grayNonCached = gray.getRenderedImage();
        reader.dispose();
        prop.put("QueryCacheMaxFeatures", "10000");
        prop.put("QueryCacheMaxAge", "60000");
        try (FileOutputStream fos = new FileOutputStream(new File(directory, "datastore.properties"));){
            prop.store(fos, null);
        }
        reader = TestUtils.getReader(directory);
        RenderedImage rgbCached = reader.read("rgb", params).getRenderedImage();
        RenderedImage grayCached = reader.read("gray", params).getRenderedImage();
        GranuleCatalog catalog = ((RasterManager)reader.rasterManagers.get("rgb")).getGranuleCatalog();
        MatcherAssert.assertThat((Object)catalog, (Matcher)CoreMatchers.instanceOf(LockingGranuleCatalog.class));
        catalog = ((LockingGranuleCatalog)catalog).getAdaptee();
        MatcherAssert.assertThat((Object)catalog, (Matcher)CoreMatchers.instanceOf(CachingDataStoreGranuleCatalog.class));
        MatcherAssert.assertThat((Object)((CachingDataStoreGranuleCatalog)catalog).getAdaptee(), (Matcher)CoreMatchers.instanceOf(QueryCacheGranuleCatalog.class));
        reader.dispose();
        ImageAssert.assertEquals((RenderedImage)rgbNonCached, (RenderedImage)rgbCached, (int)0);
        ImageAssert.assertEquals((RenderedImage)grayNonCached, (RenderedImage)grayCached, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAlphaOverlap() throws Exception {
        URL alphaOverlap = TestData.url((Object)this, (String)"alpha-overlap/");
        AbstractGridFormat format = TestUtils.getFormat(alphaOverlap);
        File mosaicFile = URLs.urlToFile((URL)alphaOverlap);
        ImageMosaicReader reader = (ImageMosaicReader)format.getReader((Object)mosaicFile.getAbsolutePath());
        GridCoverage2D coverage = null;
        try {
            coverage = reader.read(null);
            File sample = new File("src/test/resources/org/geotools/gce/imagemosaic/test-data/rgba-overlap.png");
            ImageAssert.assertEquals((File)sample, (RenderedImage)coverage.getRenderedImage(), (int)0);
        }
        finally {
            if (coverage != null) {
                coverage.dispose(true);
            }
            reader.dispose();
        }
    }

    @Test
    public void testPropertySelection() throws Exception {
        File workDir = new File("./target", "water_temp_selection");
        if (!workDir.mkdir()) {
            FileUtils.deleteDirectory((File)workDir);
            Assert.assertTrue((String)("Unable to create workdir:" + String.valueOf(workDir)), (boolean)workDir.mkdir());
        }
        File zipFile = new File(workDir, "watertemp.zip");
        FileUtils.copyFile((File)TestData.file((Object)this, (String)"watertemp.zip"), (File)zipFile);
        TestData.unzip((File)zipFile, (File)workDir);
        try (FileWriter out = new FileWriter(new File(workDir, "indexer.properties"), true);){
            out.write("PropertySelection=true");
            out.flush();
        }
        ImageMosaicReader reader = TestUtils.getReader(workDir);
        GridCoverage2D coverage = reader.read(null);
        coverage.dispose(true);
        String name = reader.getGridCoverageNames()[0];
        RasterManager rm = reader.getRasterManager(name);
        Assert.assertTrue((boolean)rm.getConfiguration().getCatalogConfigurationBean().isPropertySelectionEnabled());
        rm.getGranuleCatalog().getGranuleDescriptors(new Query(name), (granule, feature) -> {
            SimpleFeature originator = granule.getOriginator();
            Assert.assertNotNull((Object)originator.getProperty("the_geom"));
            Assert.assertNotNull((Object)originator.getProperty("location"));
            Assert.assertNull((Object)originator.getProperty("elevation"));
            Assert.assertNull((Object)originator.getProperty("ingestion"));
        });
        GranuleSource granules = reader.getGranules(name, true);
        granules.getGranules(Query.ALL).accepts(f -> {
            Assert.assertNotNull((Object)f.getProperty("the_geom"));
            Assert.assertNotNull((Object)f.getProperty("location"));
            Assert.assertNotNull((Object)f.getProperty("elevation"));
            Assert.assertNotNull((Object)f.getProperty("ingestion"));
        }, null);
        reader.dispose();
    }

    private static /* synthetic */ Integer lambda$checkConcurrentHarvestAndRemove$24(CountDownLatch latch, ImageMosaicReader reader, String coverageName, int loops, Filter filter, File file) throws Exception {
        latch.await();
        int removedCount = 0;
        GranuleStore store = (GranuleStore)reader.getGranules(coverageName, false);
        for (int i = 0; i < loops; ++i) {
            Query query = new Query(null, filter);
            if (store.getCount(query) > 0) {
                store.removeGranules(filter);
                ++removedCount;
            }
            List harvested = reader.harvest(coverageName, (Object)file, null);
            MatcherAssert.assertThat((Object)harvested, (Matcher)Matchers.hasSize((int)1));
            Assert.assertTrue((String)("Feature not found after successful harvest? Loop is " + i + " and filter " + String.valueOf(filter)), (store.getCount(query) > 0 ? 1 : 0) != 0);
        }
        return removedCount;
    }

    private class MultipleHarvestSetup {
        private Collection<File> files;
        private URL harvestSingleURL;
        private AbstractGridFormat format;
        private ImageMosaicReader reader;

        private MultipleHarvestSetup() {
        }

        public Collection<File> getFiles() {
            return this.files;
        }

        public ImageMosaicReader getReader() throws FactoryException {
            return TestUtils.getReader(this.harvestSingleURL, this.format);
        }

        public MultipleHarvestSetup invoke() throws IOException, FactoryException {
            File source = URLs.urlToFile((URL)ImageMosaicReaderTest.this.timeURL);
            File testDataDir = TestData.file((Object)ImageMosaicReaderTest.this, (String)".");
            File directory1 = new File(testDataDir, "harvest1");
            File directory2 = new File(testDataDir, "harvest2");
            if (directory1.exists()) {
                FileUtils.deleteDirectory((File)directory1);
            }
            FileUtils.copyDirectory((File)source, (File)directory1);
            if (directory2.exists()) {
                FileUtils.deleteDirectory((File)directory2);
            }
            directory2.mkdirs();
            this.files = new ArrayList<File>();
            for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("world\\.20040[^25].*\\.tiff"), null)) {
                File renamed = new File(directory2, file.getName());
                Assert.assertTrue((boolean)file.renameTo(renamed));
                this.files.add(renamed);
            }
            for (File file : FileUtils.listFiles((File)directory1, (IOFileFilter)new RegexFileFilter("time_geotiff.*"), null)) {
                Assert.assertTrue((boolean)file.delete());
            }
            this.harvestSingleURL = URLs.fileToUrl((File)directory1);
            this.format = TestUtils.getFormat(this.harvestSingleURL);
            return this;
        }
    }
}

