/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReaderSpi;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.spi.ImageReaderSpi;
import junit.framework.JUnit4TestAdapter;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.test.TestData;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.TransformException;

public class OverviewsControllerTest
extends Assert {
    static double THRESHOLD = 1.0E-6;
    private static final TestSet at1 = new TestSet(new OverviewConfig[]{new OverviewConfig(OverviewPolicy.QUALITY, new GranuleParams(3, 1, 1), new GranuleParams(2, 1, 1)), new OverviewConfig(OverviewPolicy.SPEED, new GranuleParams(4, 1, 1), new GranuleParams(2, 1, 1)), new OverviewConfig(OverviewPolicy.NEAREST, new GranuleParams(3, 1, 1), new GranuleParams(2, 1, 1)), new OverviewConfig(OverviewPolicy.IGNORE, new GranuleParams(0, 9, 9), new GranuleParams(0, 5, 5))});
    private static final TestSet at2 = new TestSet(new OverviewConfig[]{new OverviewConfig(OverviewPolicy.QUALITY, new GranuleParams(3, 1, 1), new GranuleParams(2, 1, 2)), new OverviewConfig(OverviewPolicy.SPEED, new GranuleParams(4, 1, 1), new GranuleParams(2, 1, 2)), new OverviewConfig(OverviewPolicy.NEAREST, new GranuleParams(3, 1, 1), new GranuleParams(2, 1, 2)), new OverviewConfig(OverviewPolicy.IGNORE, new GranuleParams(0, 9, 9), new GranuleParams(0, 5, 5))});
    private static final Logger LOGGER = Logger.getLogger(OverviewsControllerTest.class.toString());
    private static final ImageReaderSpi spi = new TIFFImageReaderSpi();

    public static junit.framework.Test suite() {
        return new JUnit4TestAdapter(OverviewsControllerTest.class);
    }

    @Test
    public void testHeterogeneousGranules() throws IOException, MismatchedDimensionException, FactoryException, TransformException {
        CoordinateReferenceSystem WGS84 = CRS.decode((String)"EPSG:4326", (boolean)true);
        ReferencedEnvelope TEST_BBOX_A = new ReferencedEnvelope(-180.0, 0.0, -90.0, 90.0, WGS84);
        ReferencedEnvelope TEST_BBOX_B = new ReferencedEnvelope(0.0, 180.0, 0.0, 90.0, WGS84);
        URL heterogeneousGranulesURL = TestData.url((Object)((Object)this), (String)"heterogeneous");
        Hints hints = new Hints((RenderingHints.Key)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM, (Object)WGS84);
        hints.put((Object)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)true);
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)heterogeneousGranulesURL, (Hints)hints);
        Assert.assertNotNull((Object)format);
        Assert.assertFalse((String)"UknownFormat", (boolean)(format instanceof UnknownFormat));
        ImageMosaicReader reader = (ImageMosaicReader)format.getReader((Object)heterogeneousGranulesURL, hints);
        Assert.assertNotNull((Object)reader);
        String name = reader.getGridCoverageNames()[0];
        int nOv = reader.getDatasetLayout().getNumInternalOverviews();
        double[][] hRes = reader.getResolutionLevels();
        RasterManager rasterManager = reader.getRasterManager(name);
        File g1File = new File(URLs.urlToFile((URL)heterogeneousGranulesURL), "world_a.tif");
        File g2File = new File(URLs.urlToFile((URL)heterogeneousGranulesURL), "world_b.tif");
        ImageReadParam readParamsG1 = new ImageReadParam();
        ImageReadParam readParamsG2 = new ImageReadParam();
        int imageIndexG1 = 0;
        int imageIndexG2 = 0;
        GranuleDescriptor granuleDescriptor1 = new GranuleDescriptor(g1File.getAbsolutePath(), (BoundingBox)TEST_BBOX_A, null, spi, null, null, -1, true, false, hints);
        GranuleDescriptor granuleDescriptor2 = new GranuleDescriptor(g2File.getAbsolutePath(), (BoundingBox)TEST_BBOX_B, null, spi, null, null, -1, true, false, hints);
        OverviewsControllerTest.assertNotNull((Object)granuleDescriptor1.toString());
        OverviewsControllerTest.assertNotNull((Object)granuleDescriptor2.toString());
        OverviewsController ovControllerG1 = granuleDescriptor1.overviewsController;
        OverviewsController ovControllerG2 = granuleDescriptor2.overviewsController;
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        GridEnvelope originalRange = reader.getOriginalGridRange();
        Rectangle rasterArea = new Rectangle(0, 0, (int)Math.ceil((double)originalRange.getSpan(0) / 9.0), (int)Math.ceil((double)originalRange.getSpan(1) / 9.0));
        GridEnvelope2D range = new GridEnvelope2D(rasterArea);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper((GridEnvelope)range, (Envelope)envelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        AffineTransform gridToWorld = geMapper.createAffineTransform();
        double[] requestedResolution = new double[]{XAffineTransform.getScaleX0((AffineTransform)gridToWorld), XAffineTransform.getScaleY0((AffineTransform)gridToWorld)};
        TestSet at = null;
        if (nOv == 4 && Math.abs(hRes[0][0] - 0.833333333333) <= THRESHOLD) {
            at = at1;
        } else if (nOv == 2 && Math.abs(hRes[0][1] - 1.40625) <= THRESHOLD) {
            at = at2;
        } else {
            return;
        }
        OverviewPolicy[] ovPolicies = new OverviewPolicy[]{OverviewPolicy.QUALITY, OverviewPolicy.SPEED, OverviewPolicy.NEAREST, OverviewPolicy.IGNORE};
        for (int i = 0; i < ovPolicies.length; ++i) {
            OverviewPolicy ovPolicy = ovPolicies[i];
            LOGGER.info("Testing with OverviewPolicy = " + ovPolicy.toString());
            imageIndexG1 = ReadParamsController.setReadParams((double[])requestedResolution, (OverviewPolicy)ovPolicy, (DecimationPolicy)DecimationPolicy.ALLOW, (ImageReadParam)readParamsG1, (RasterManager)rasterManager, (OverviewsController)ovControllerG1, null);
            imageIndexG2 = ReadParamsController.setReadParams((double[])requestedResolution, (OverviewPolicy)ovPolicy, (DecimationPolicy)DecimationPolicy.ALLOW, (ImageReadParam)readParamsG2, (RasterManager)rasterManager, (OverviewsController)ovControllerG2, null);
            OverviewsControllerTest.assertSame((Object)at.ot[i].g1.imageIndex, (Object)imageIndexG1);
            OverviewsControllerTest.assertSame((Object)at.ot[i].g2.imageIndex, (Object)imageIndexG2);
            OverviewsControllerTest.assertSame((Object)at.ot[i].g1.ssx, (Object)readParamsG1.getSourceXSubsampling());
            OverviewsControllerTest.assertSame((Object)at.ot[i].g1.ssy, (Object)readParamsG1.getSourceYSubsampling());
            OverviewsControllerTest.assertSame((Object)at.ot[i].g2.ssx, (Object)readParamsG2.getSourceXSubsampling());
            OverviewsControllerTest.assertSame((Object)at.ot[i].g2.ssy, (Object)readParamsG2.getSourceYSubsampling());
        }
        reader.dispose();
    }

    @Before
    public void setUp() throws Exception {
        this.cleanUp();
    }

    private void cleanUp() throws FileNotFoundException, IOException {
        File[] files;
        File dir = TestData.file((Object)((Object)this), (String)"heterogeneous/");
        for (File file : files = dir.listFiles((FilenameFilter)FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"tif"), FileFilterUtils.suffixFileFilter((String)"aux")}), FileFilterUtils.nameFileFilter((String)"datastore.properties")})))) {
            file.delete();
        }
    }

    @After
    public void tearDown() throws FileNotFoundException, IOException {
        this.cleanUp();
    }

    static class OverviewConfig {
        OverviewPolicy ovPolicy;
        GranuleParams g1;
        GranuleParams g2;

        public OverviewConfig(OverviewPolicy ovPolicy, GranuleParams g1, GranuleParams g2) {
            this.ovPolicy = ovPolicy;
            this.g1 = g1;
            this.g2 = g2;
        }
    }

    static class GranuleParams {
        int imageIndex;
        int ssx;
        int ssy;

        public GranuleParams(int imageIndex, int ssx, int ssy) {
            this.imageIndex = imageIndex;
            this.ssx = ssx;
            this.ssy = ssy;
        }
    }

    static class TestSet {
        double resolution;
        OverviewConfig[] ot;

        public TestSet(OverviewConfig[] ot) {
            this.ot = ot;
        }
    }
}

