/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.data.Query;
import org.geotools.api.data.Transaction;
import org.geotools.api.feature.simple.SimpleFeature;
import org.geotools.api.filter.FilterVisitor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.BoundsFeatureCollection;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.DelegatingGranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;

public class CachingDataStoreGranuleCatalog
extends DelegatingGranuleCatalog {
    private static final Logger LOGGER = Logging.getLogger(CachingDataStoreGranuleCatalog.class);
    private final SoftValueHashMap<String, GranuleDescriptor> descriptorsCache = new SoftValueHashMap();

    public CachingDataStoreGranuleCatalog(GranuleCatalog adaptee) {
        super(adaptee);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        return this.getGranules(q, Transaction.AUTO_COMMIT);
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q, Transaction t) throws IOException {
        boolean decorateWithBounds = Boolean.TRUE.equals(q.getHints().get((Object)GranuleSource.NATIVE_BOUNDS));
        if (decorateWithBounds) {
            Query copy = new Query(q);
            copy.getHints().remove((Object)GranuleSource.NATIVE_BOUNDS);
            q = copy;
            SimpleFeatureCollection granules = this.adaptee.getGranules(q, t);
            CatalogConfigurationBean configuration = this.adaptee.getConfigurations().getByTypeQuery(q);
            return new BoundsFeatureCollection(granules, sf -> this.getGranuleDescriptor(configuration, (SimpleFeature)sf));
        }
        return this.adaptee.getGranules(q, t);
    }

    @Override
    public void getGranuleDescriptors(Query q, GranuleCatalogVisitor visitor) throws IOException {
        SimpleFeatureCollection features = this.adaptee.getGranules(q);
        if (features == null) {
            throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Index Loaded");
        }
        Utils.BBOXFilterExtractor bboxExtractor = new Utils.BBOXFilterExtractor();
        q.getFilter().accept((FilterVisitor)bboxExtractor, null);
        ReferencedEnvelope requestedBBox = bboxExtractor.getBBox();
        Polygon intersectionGeometry = requestedBBox != null ? JTS.toGeometry((ReferencedEnvelope)requestedBBox) : null;
        CatalogConfigurationBean configuration = this.adaptee.getConfigurations().getByTypeQuery(q);
        try (SimpleFeatureIterator fi = features.features();){
            Object executor = q.getHints().get((Object)Hints.EXECUTOR_SERVICE);
            if (executor instanceof ExecutorService) {
                this.parallelGranuleVisit(configuration, visitor, (Geometry)intersectionGeometry, fi, (ExecutorService)executor);
            } else {
                this.sequentialGranuleVisit(configuration, visitor, (Geometry)intersectionGeometry, fi);
            }
        }
    }

    private void parallelGranuleVisit(CatalogConfigurationBean configuration, GranuleCatalogVisitor visitor, Geometry intersectionGeometry, SimpleFeatureIterator fi, ExecutorService executor) {
        ArrayList<Future<GranuleDescriptor>> futures = new ArrayList<Future<GranuleDescriptor>>();
        try {
            while (fi.hasNext() && !visitor.isVisitComplete()) {
                SimpleFeature sf = (SimpleFeature)fi.next();
                futures.add(executor.submit(() -> this.getGranuleDescriptor(configuration, sf)));
            }
        }
        catch (RejectedExecutionException e) {
            int n = futures.size();
            int leftover = 1;
            while (fi.hasNext()) {
                fi.next();
                ++leftover;
            }
            throw new RuntimeException("We were not allowed to fetch all mosaic granules, submitted " + Integer.toString(n) + " while still having " + Integer.toString(leftover) + " left", e);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Parallel granule visit using executor " + executor.toString());
        }
        for (Future future : futures) {
            try {
                GranuleDescriptor granule = (GranuleDescriptor)future.get();
                this.visitGranule(visitor, intersectionGeometry, granule);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException("Unexpected exception occurred loading granules", e);
            }
        }
    }

    private void sequentialGranuleVisit(CatalogConfigurationBean configuration, GranuleCatalogVisitor visitor, Geometry intersectionGeometry, SimpleFeatureIterator fi) {
        while (fi.hasNext() && !visitor.isVisitComplete()) {
            SimpleFeature sf = (SimpleFeature)fi.next();
            GranuleDescriptor granule = this.getGranuleDescriptor(configuration, sf);
            this.visitGranule(visitor, intersectionGeometry, granule);
        }
    }

    private void visitGranule(GranuleCatalogVisitor visitor, Geometry intersectionGeometry, GranuleDescriptor granule) {
        if (granule != null) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Visiting granule " + granule.getGranuleUrl().toString());
            }
            Geometry footprint = granule.getFootprint();
            if (intersectionGeometry == null || footprint == null || this.polygonOverlap(footprint, intersectionGeometry)) {
                visitor.visit(granule, granule.getOriginator());
            } else if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Skipping granule " + granule + "\n since its ROI does not intersect the requested area");
            }
        }
    }

    protected GranuleDescriptor getGranuleDescriptor(CatalogConfigurationBean configuration, SimpleFeature sf) {
        String featureId = sf.getID();
        String key = configuration.getName() + "/" + featureId;
        GranuleDescriptor granule = null;
        if (this.descriptorsCache.containsKey((Object)key)) {
            granule = (GranuleDescriptor)this.descriptorsCache.get((Object)key);
        } else {
            try {
                MultiLevelROI footprint = this.getGranuleFootprint(sf);
                if (footprint == null || !footprint.isEmpty()) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Creating new Granule Descriptor for feature Id: " + key);
                    }
                    granule = new GranuleDescriptor(sf, configuration.suggestedFormat(), configuration.suggestedSPI(), configuration.suggestedIsSPI(), configuration.getPathType(), configuration.getLocationAttribute(), this.adaptee.getParentLocation(), footprint, configuration.isHeterogeneous(), this.adaptee.getHints());
                    this.descriptorsCache.put((Object)key, (Object)granule);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Skipping invalid granule", e);
            }
        }
        return granule;
    }

    protected boolean polygonOverlap(Geometry g1, Geometry g2) {
        Geometry intersection = g1.intersection(g2);
        return intersection != null && intersection.getDimension() == 2;
    }

    @Override
    public int removeGranules(Query query) {
        return this.removeGranules(query, Transaction.AUTO_COMMIT);
    }

    @Override
    public int removeGranules(Query query, Transaction transaction) {
        int val = this.adaptee.removeGranules(query, transaction);
        if (val >= 1) {
            this.descriptorsCache.clear();
        }
        return val;
    }
}

