/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.api.coverage.grid.GridEnvelope;
import org.geotools.api.geometry.Bounds;
import org.geotools.api.geometry.MismatchedDimensionException;
import org.geotools.api.referencing.datum.PixelInCell;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Envelope;

public final class RendererUtilities {
    private static final Logger LOGGER = Logging.getLogger(RendererUtilities.class);
    private static final ThreadLocal<GridToEnvelopeMapper> gridToEnvelopeMappers = new ThreadLocal<GridToEnvelopeMapper>(){

        @Override
        protected GridToEnvelopeMapper initialValue() {
            GridToEnvelopeMapper mapper = new GridToEnvelopeMapper();
            mapper.setPixelAnchor(PixelInCell.CELL_CORNER);
            return mapper;
        }
    };

    private RendererUtilities() {
    }

    public static AffineTransform worldToScreenTransform(ReferencedEnvelope mapExtent, Rectangle paintArea) {
        ReferencedEnvelope genvelope = new ReferencedEnvelope(mapExtent);
        GridToEnvelopeMapper m = gridToEnvelopeMappers.get();
        try {
            m.setGridRange((GridEnvelope)new GridEnvelope2D(paintArea));
            m.setEnvelope((Bounds)genvelope);
            return m.createAffineTransform().createInverse();
        }
        catch (NoninvertibleTransformException | MismatchedDimensionException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            return null;
        }
    }

    public static Envelope createMapEnvelope(Rectangle paintArea, AffineTransform worldToScreen) throws NoninvertibleTransformException {
        double[] pts = new double[]{paintArea.getMinX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMinY(), paintArea.getMaxX(), paintArea.getMaxY(), paintArea.getMinX(), paintArea.getMaxY()};
        worldToScreen.inverseTransform(pts, 0, pts, 0, 4);
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = -1.7976931348623157E308;
        double yMax = -1.7976931348623157E308;
        for (int i = 0; i < 4; ++i) {
            xMin = Math.min(xMin, pts[2 * i]);
            yMin = Math.min(yMin, pts[2 * i + 1]);
            xMax = Math.max(xMax, pts[2 * i]);
            yMax = Math.max(yMax, pts[2 * i + 1]);
        }
        return new Envelope(xMin, xMax, yMin, yMax);
    }
}

